/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.tileEntities;

import buildcraftAdditions.config.ConfigurationHandler;
import buildcraftAdditions.inventories.CustomInventory;
import buildcraftAdditions.reference.Variables;
import buildcraftAdditions.tileEntities.Bases.TileMachineBase;
import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.common.FMLCommonHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileChargingStation
extends TileMachineBase
implements IInventory {
    private final CustomInventory inventory = new CustomInventory("ChargingStation", 1, 1, this);

    public TileChargingStation() {
        super(ConfigurationHandler.capacityChargingStation, ConfigurationHandler.maxTransferChargingStation, Variables.SyncIDs.CHARGING_STATION.ordinal());
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.energy > 0 && this.getRequiredEnergy() > 0) {
            ItemStack stack = this.func_70301_a(0);
            IEnergyContainerItem containerItem = (IEnergyContainerItem)stack.func_77973_b();
            this.energy -= containerItem.receiveEnergy(stack, Math.min(this.energy, this.maxTransfer), false);
        }
    }

    public int getRequiredEnergy() {
        ItemStack stack = this.func_70301_a(0);
        if (stack != null && stack.func_77973_b() != null && stack.func_77973_b() instanceof IEnergyContainerItem) {
            IEnergyContainerItem containerItem = (IEnergyContainerItem)stack.func_77973_b();
            return containerItem.getMaxEnergyStored(stack) - containerItem.getEnergyStored(stack);
        }
        return 0;
    }

    public boolean canUpdate() {
        return !FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.inventory.readFromNBT(nbtTagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        this.inventory.writeToNBT(nbtTagCompound);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int var1) {
        return this.inventory.func_70301_a(var1);
    }

    public ItemStack func_70298_a(int var1, int var2) {
        return this.inventory.func_70298_a(var1, var2);
    }

    public ItemStack func_70304_b(int var1) {
        return this.inventory.func_70304_b(var1);
    }

    public void func_70299_a(int var1, ItemStack var2) {
        this.inventory.func_70299_a(var1, var2);
    }

    public String func_145825_b() {
        return this.inventory.func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof IEnergyContainerItem;
    }

    public double getProgress() {
        ItemStack stack = this.inventory.func_70301_a(0);
        if (stack != null && stack.func_77973_b() instanceof IEnergyContainerItem) {
            IEnergyContainerItem battery = (IEnergyContainerItem)stack.func_77973_b();
            return battery.getEnergyStored(stack) / battery.getMaxEnergyStored(stack);
        }
        return 0.0;
    }
}

