/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.tileEntities;

import buildcraftAdditions.config.ConfigurationHandler;
import buildcraftAdditions.inventories.CustomInventory;
import buildcraftAdditions.reference.Variables;
import buildcraftAdditions.tileEntities.Bases.TileCoilBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;

public class TileBasicCoil
extends TileCoilBase
implements IInventory {
    private final CustomInventory inventory = new CustomInventory("BasicCoil", 1, 64, this);

    public TileBasicCoil() {
        super(Variables.SyncIDs.BASIC_COIL.ordinal());
        this.burnTime = 0;
        this.fullBurnTime = 0;
        this.shouldHeat = false;
        this.burning = false;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.burnTime == 0) {
            this.burning = false;
            if (this.shouldHeat) {
                this.burn();
            }
        }
        if (this.burning) {
            --this.burnTime;
        }
        if (this.burning && this.increment < ConfigurationHandler.basicCoilHeat) {
            ++this.increment;
        }
        if (!this.burning && this.increment > 0) {
            --this.increment;
        }
    }

    public void burn() {
        ItemStack stack = this.func_70301_a(0);
        if (stack != null && stack.func_77973_b() != null && stack.field_77994_a > 0) {
            this.fullBurnTime = this.burnTime = this.getBurnTime(stack);
            --stack.field_77994_a;
            if (stack.field_77994_a <= 0) {
                this.func_70299_a(0, stack.func_77973_b().getContainerItem(stack));
            }
            this.burning = true;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.inventory.writeToNBT(tag);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.readFromNBT(tag);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.inventory.func_70298_a(slot, amount);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
    }

    public String func_145825_b() {
        return this.inventory.func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.getBurnTime(stack) != 0;
    }

    public int getBurnTime(ItemStack stack) {
        return TileEntityFurnace.func_145952_a((ItemStack)stack) * 5;
    }

    public int getBurnIconHeight() {
        if (this.fullBurnTime == 0) {
            return 0;
        }
        return this.burnTime * ConfigurationHandler.basicCoilHeat / this.fullBurnTime;
    }
}

