/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.tileEntities;

import buildcraftAdditions.armour.ItemKineticBackpack;
import buildcraftAdditions.inventories.CustomInventory;
import buildcraftAdditions.reference.ArmorLoader;
import buildcraftAdditions.reference.ItemLoader;
import buildcraftAdditions.reference.Variables;
import buildcraftAdditions.tileEntities.Bases.TileBase;
import buildcraftAdditions.utils.Utils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileBackpackStand
extends TileBase {
    public CustomInventory inventory = new CustomInventory("backpackStand", 1, 1, this);

    public TileBackpackStand() {
        super(Variables.SyncIDs.BACKPACK_STAND.ordinal());
    }

    public void onBlockActivated(float hitX, float hitY, float hitZ, int rotation, EntityPlayer player) {
        if (this.inventory.func_70301_a(0) == null) {
            if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() == ArmorLoader.kineticBackpack) {
                this.inventory.func_70299_a(0, player.func_71045_bC());
                player.func_71028_bD();
            }
        } else {
            ItemStack bStack;
            ItemKineticBackpack backpack;
            if (player.func_71045_bC() == null && player.func_70093_af()) {
                Utils.dropItemstackAtEntity((Entity)player, this.inventory.func_70301_a(0));
                this.inventory.func_70299_a(0, null);
                return;
            }
            int capsuleSlot = this.getSlot(rotation, hitX, hitY, hitZ);
            if (capsuleSlot == -1) {
                return;
            }
            ItemStack playerStack = player.func_71045_bC();
            if (playerStack == null) {
                return;
            }
            if ((playerStack.func_77973_b() == ItemLoader.powerCapsuleTier1 || playerStack.func_77973_b() == ItemLoader.powerCapsuleTier2 || playerStack.func_77973_b() == ItemLoader.powerCapsuleTier3) && (backpack = (ItemKineticBackpack)(bStack = this.inventory.func_70301_a(0)).func_77973_b()).getInstalledCapsule(bStack, capsuleSlot) == 0) {
                backpack.installCapsule(bStack, capsuleSlot, playerStack);
                player.func_71028_bD();
            }
        }
        this.sync();
    }

    public void removeCapsule(EntityPlayer player, int rotation, double hitX, double hitY, double hitZ) {
        int slot;
        if (this.inventory.func_70301_a(0) == null) {
            return;
        }
        ItemStack bStack = this.inventory.func_70301_a(0);
        ItemKineticBackpack backpack = (ItemKineticBackpack)bStack.func_77973_b();
        if (backpack.getInstalledCapsule(bStack, slot = this.getSlot(rotation, hitX, hitY, hitZ)) > 0) {
            Utils.dropItemstacksAtEntity((Entity)player, Utils.getDropsForCapsule(backpack.removeCapsule(bStack, slot)));
        }
    }

    private int getSlot(int rotation, double hitX, double hitY, double hitZ) {
        switch (ForgeDirection.getOrientation((int)rotation)) {
            case NORTH: {
                if (hitY >= 1.1 && hitY <= 1.3) {
                    if (hitX >= 0.58 && hitX <= 0.81) {
                        return 0;
                    }
                    if (!(hitX >= 0.18) || !(hitX <= 0.41)) break;
                    return 1;
                }
                if (!(hitY >= 0.78) || !(hitY <= 1.0)) break;
                if (hitX >= 0.58 && hitX <= 0.81) {
                    return 2;
                }
                if (!(hitX >= 0.18) || !(hitX <= 0.41)) break;
                return 3;
            }
            case EAST: {
                if (hitY >= 1.1 && hitY <= 1.3) {
                    if (hitZ >= 0.58 && hitZ <= 0.81) {
                        return 0;
                    }
                    if (!(hitZ >= 0.18) || !(hitZ <= 0.41)) break;
                    return 1;
                }
                if (!(hitY >= 0.78) || !(hitY <= 1.0)) break;
                if (hitZ >= 0.58 && hitZ <= 0.81) {
                    return 2;
                }
                if (!(hitZ >= 0.18) || !(hitZ <= 0.41)) break;
                return 3;
            }
            case SOUTH: {
                if (hitY >= 1.1 && hitY <= 1.3) {
                    if (hitX >= 0.58 && hitX <= 0.81) {
                        return 1;
                    }
                    if (!(hitX >= 0.18) || !(hitX <= 0.41)) break;
                    return 0;
                }
                if (!(hitY >= 0.78) || !(hitY <= 1.0)) break;
                if (hitX >= 0.58 && hitX <= 0.81) {
                    return 3;
                }
                if (!(hitX >= 0.18) || !(hitX <= 0.41)) break;
                return 2;
            }
            case WEST: {
                if (hitY >= 1.1 && hitY <= 1.3) {
                    if (hitZ >= 0.58 && hitZ <= 0.81) {
                        return 1;
                    }
                    if (!(hitZ >= 0.18) || !(hitZ <= 0.41)) break;
                    return 0;
                }
                if (!(hitY >= 0.78) || !(hitY <= 1.0)) break;
                if (hitZ >= 0.58 && hitZ <= 0.81) {
                    return 3;
                }
                if (!(hitZ >= 0.18) || !(hitZ <= 0.41)) break;
                return 2;
            }
        }
        return -1;
    }

    @Override
    public void writeToByteBuff(ByteBuf buf) {
        this.inventory.writeToByteBuff(buf);
    }

    @Override
    public void readFromByteBuff(ByteBuf buf) {
        this.inventory.readFromByteBuff(buf);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 2), (double)(this.field_145848_d - 2), (double)(this.field_145849_e - 2), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 2));
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.readFromNBT(tag);
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.inventory.writeToNBT(tag);
    }
}

