/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.tileEntities.Bases;

import buildcraftAdditions.tileEntities.Bases.TileBase;
import cofh.api.energy.IEnergyReceiver;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileMachineBase
extends TileBase
implements IEnergyReceiver {
    protected final int capacity;
    protected final int maxTransfer;
    protected int energy;

    protected TileMachineBase(int capacity, int maxTransfer, int identifier) {
        super(identifier);
        this.capacity = capacity;
        this.maxTransfer = maxTransfer;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.energy = tag.func_74762_e("energy");
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("energy", this.energy);
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        int energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxTransfer, maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
        }
        return energyReceived;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.energy;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.capacity;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public void writeToByteBuff(ByteBuf buf) {
        buf.writeInt(this.energy);
    }

    @Override
    public void readFromByteBuff(ByteBuf buf) {
        this.energy = buf.readInt();
    }
}

