/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.tileEntities.Bases;

import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import buildcraftAdditions.api.configurableOutput.EnumPriority;
import buildcraftAdditions.api.configurableOutput.EnumSideStatus;
import buildcraftAdditions.api.configurableOutput.IConfigurableOutput;
import buildcraftAdditions.api.configurableOutput.SideConfiguration;
import buildcraftAdditions.api.networking.ISynchronizedTile;
import buildcraftAdditions.config.ConfigurationHandler;
import buildcraftAdditions.networking.MessageConfiguration;
import buildcraftAdditions.networking.MessageSelfDestruct;
import buildcraftAdditions.networking.PacketHandler;
import buildcraftAdditions.tileEntities.Bases.TileBase;
import buildcraftAdditions.tileEntities.TileKineticEnergyBufferTier1;
import buildcraftAdditions.tileEntities.interfaces.IOwnableMachine;
import buildcraftAdditions.utils.PlayerUtils;
import buildcraftAdditions.utils.Utils;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.Explosion;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileKineticEnergyBufferBase
extends TileBase
implements IEnergyReceiver,
IEnergyProvider,
IConfigurableOutput,
ISynchronizedTile,
IOwnableMachine,
IPipeConnection {
    public final int tier;
    protected final SideConfiguration configuration = new SideConfiguration();
    protected final boolean[] blocked = new boolean[6];
    public int energy;
    public int capacity;
    public int maxTransfer;
    public int loss;
    public int fuse;
    public boolean selfDestruct;
    public boolean engineControl;
    public EntityPlayer destroyer;
    private UUID owner;

    public TileKineticEnergyBufferBase(int capacity, int maxTransfer, int loss, int tier, int identifier) {
        super(identifier);
        this.capacity = capacity;
        this.maxTransfer = maxTransfer;
        this.loss = loss;
        this.tier = tier;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (!this.configuration.canReceive(from)) {
            return 0;
        }
        int energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxTransfer, maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
            this.blocked[from.ordinal()] = true;
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (!this.configuration.canSend(from)) {
            return 0;
        }
        int energyExtracted = Math.min(this.energy, Math.min(this.maxTransfer, maxExtract));
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        return energyExtracted;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.energy;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.capacity;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("energy")) {
            this.energy = tag.func_74762_e("energy");
            this.capacity = tag.func_74762_e("maxEnergy");
            this.maxTransfer = Math.max(tag.func_74762_e("maxTransfer"), Math.max(tag.func_74762_e("maxInput"), tag.func_74762_e("maxOutput")));
            this.loss = tag.func_74762_e("loss");
            this.engineControl = tag.func_74767_n("engineControl");
            this.configuration.readFromNBT(tag);
            this.owner = PlayerUtils.readFromNBT(tag);
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("energy", this.energy);
        tag.func_74768_a("maxEnergy", this.capacity);
        tag.func_74768_a("maxTransfer", this.maxTransfer);
        tag.func_74768_a("loss", this.loss);
        tag.func_74757_a("engineControl", this.engineControl);
        this.configuration.writeToNBT(tag);
        PlayerUtils.writeToNBT(tag, this.owner);
    }

    public void func_145845_h() {
        if (this.getEnergyLevel() > 85) {
            this.engineControl = false;
        }
        if (this.getEnergyLevel() < 30) {
            this.engineControl = true;
        }
        super.func_145845_h();
        if (this.selfDestruct) {
            --this.fuse;
            if (this.fuse % 20 == 0) {
                this.destroyer.func_146105_b((IChatComponent)new ChatComponentText(Utils.localize("selfdestructCountdouwn") + ": " + this.fuse / 20));
            }
        }
        if (this.fuse <= 0 && this.selfDestruct) {
            this.byeBye();
        }
        if (ConfigurationHandler.powerloss) {
            this.energy -= this.loss;
        }
        if (this.energy < 0) {
            this.energy = 0;
        }
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        }
        this.outputEnergy();
    }

    public abstract void outputEnergy();

    protected boolean canSharePower(TileEntity target, ForgeDirection outputSide) {
        TileKineticEnergyBufferTier1 keb;
        return this.configuration.canReceive(outputSide) && this.configuration.canSend(outputSide) && target instanceof TileKineticEnergyBufferTier1 && (keb = (TileKineticEnergyBufferTier1)target).getStatus(outputSide.getOpposite()) == EnumSideStatus.BOTH;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.configuration.canReceive(from) || this.configuration.canSend(from);
    }

    public void sendConfigurationToSever() {
        PacketHandler.instance.sendToServer((IMessage)new MessageConfiguration(this));
    }

    @Override
    public UUID getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    @Override
    public boolean hasOwner() {
        return this.owner != null;
    }

    public void activateSelfDestruct() {
        if (this.field_145850_b.field_72995_K) {
            PacketHandler.instance.sendToServer((IMessage)new MessageSelfDestruct(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            return;
        }
        this.selfDestruct = true;
        this.fuse = 100;
        this.destroyer.func_146105_b((IChatComponent)new ChatComponentText(Utils.localize("selfdestructActivated")));
        this.destroyer.func_71053_j();
    }

    public void byeBye() {
        Explosion explosion = this.field_145850_b.func_72876_a((Entity)this.destroyer, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (float)(this.energy / 900000 + 5), true);
        explosion.func_77278_a();
        explosion.func_77279_a(true);
    }

    @Override
    public EnumSideStatus getStatus(ForgeDirection side) {
        return this.configuration.getStatus(side);
    }

    @Override
    public void changeStatus(ForgeDirection side) {
        this.configuration.changeStatus(side);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void writeToByteBuff(ByteBuf buf) {
        buf.writeInt(this.energy);
        this.configuration.writeToByteBuff(buf);
        PlayerUtils.writeToByteBuff(buf, this.owner);
    }

    @Override
    public void readFromByteBuff(ByteBuf buf) {
        this.energy = buf.readInt();
        this.configuration.readFromByteBuff(buf);
        this.owner = PlayerUtils.readFromByteBuff(buf);
    }

    @Override
    public int getX() {
        return this.field_145851_c;
    }

    @Override
    public int getY() {
        return this.field_145848_d;
    }

    @Override
    public int getZ() {
        return this.field_145849_e;
    }

    public int getEnergyLevel() {
        if (this.getMaxEnergyStored(ForgeDirection.UNKNOWN) == 0) {
            return 0;
        }
        return (int)((float)this.getEnergyStored(ForgeDirection.UNKNOWN) / (float)this.getMaxEnergyStored(ForgeDirection.UNKNOWN) * 100.0f);
    }

    @Override
    public EnumPriority getPriority(ForgeDirection side) {
        return this.configuration.getPriority(side);
    }

    @Override
    public void changePriority(ForgeDirection side) {
        this.configuration.changePriority(side);
    }

    @Override
    public SideConfiguration getSideConfiguration() {
        return this.configuration;
    }

    @Override
    public void setSideConfiguration(SideConfiguration configuration) {
        this.configuration.load(configuration);
    }

    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection from) {
        if ((this.configuration.getStatus(from).canReceive() || this.configuration.getStatus(from).canSend()) && type == IPipeTile.PipeType.POWER) {
            return IPipeConnection.ConnectOverride.CONNECT;
        }
        return IPipeConnection.ConnectOverride.DISCONNECT;
    }
}

