/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.tileEntities.Bases;

import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import buildcraftAdditions.api.configurableOutput.EnumPriority;
import buildcraftAdditions.api.configurableOutput.EnumSideStatus;
import buildcraftAdditions.api.configurableOutput.IConfigurableOutput;
import buildcraftAdditions.api.configurableOutput.SideConfiguration;
import buildcraftAdditions.api.recipe.BCARecipeManager;
import buildcraftAdditions.tileEntities.Bases.TileBaseDuster;
import buildcraftAdditions.utils.Location;
import buildcraftAdditions.utils.Utils;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileDusterWithConfigurableOutput
extends TileBaseDuster
implements IConfigurableOutput,
IPipeConnection {
    protected final SideConfiguration configuration = new SideConfiguration();

    public TileDusterWithConfigurableOutput(String key, int identifier) {
        super(key, identifier);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.configuration.readFromNBT(tag);
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.configuration.writeToNBT(tag);
    }

    @Override
    public EnumSideStatus getStatus(ForgeDirection side) {
        return this.configuration.getStatus(side);
    }

    @Override
    public void changeStatus(ForgeDirection side) {
        this.configuration.changeStatus(side);
    }

    @Override
    public void writeToByteBuff(ByteBuf buf) {
        super.writeToByteBuff(buf);
        this.configuration.writeToByteBuff(buf);
    }

    @Override
    public void readFromByteBuff(ByteBuf buf) {
        super.readFromByteBuff(buf);
        this.configuration.readFromByteBuff(buf);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return BCARecipeManager.duster.getRecipe(stack) != null;
    }

    @Override
    public int[] func_94128_d(int side) {
        int[] nArray;
        if (this.configuration.canReceive(ForgeDirection.getOrientation((int)side))) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            nArray = new int[]{};
        }
        return nArray;
    }

    @Override
    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.configuration.canReceive(ForgeDirection.getOrientation((int)side)) && this.func_94041_b(slot, stack);
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return this.configuration.canSend(ForgeDirection.getOrientation((int)side));
    }

    @Override
    public EnumPriority getPriority(ForgeDirection side) {
        return this.configuration.getPriority(side);
    }

    @Override
    public void changePriority(ForgeDirection side) {
        this.configuration.changePriority(side);
    }

    @Override
    public void dust() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack output = BCARecipeManager.duster.getRecipe(this.func_70301_a(0)).getOutput(this.func_70301_a(0));
        Utils.outputStack(new Location(this), output, this.configuration);
        if (output != null && output.field_77994_a > 0 && output.func_77973_b() != null) {
            Utils.dropItemstack(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, output);
        }
        this.func_70299_a(0, null);
    }

    @Override
    public SideConfiguration getSideConfiguration() {
        return this.configuration;
    }

    @Override
    public void setSideConfiguration(SideConfiguration configuration) {
        this.configuration.load(configuration);
    }

    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        EnumSideStatus status = this.getStatus(with);
        return type == IPipeTile.PipeType.ITEM && (status.canSend() || status.canReceive()) ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DEFAULT;
    }
}

