/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.tileEntities.Bases;

import buildcraftAdditions.api.recipe.BCARecipeManager;
import buildcraftAdditions.api.recipe.duster.IDusterRecipe;
import buildcraftAdditions.config.ConfigurationHandler;
import buildcraftAdditions.inventories.CustomInventory;
import buildcraftAdditions.tileEntities.Bases.TileBase;
import com.google.common.base.Strings;
import eureka.api.EurekaAPI;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldServer;

public abstract class TileBaseDuster
extends TileBase
implements ISidedInventory {
    public final CustomInventory inventory = new CustomInventory("Duster", 1, 1, this);
    protected final String key;
    public int progress;
    protected int particles = ConfigurationHandler.particleCount;

    public TileBaseDuster(String key, int identifier) {
        super(identifier);
        this.key = key;
    }

    public boolean canUpdate() {
        return false;
    }

    public abstract void dust();

    public abstract double getProgress();

    public IDusterRecipe getRecipe() {
        return BCARecipeManager.duster.getRecipe(this.func_70301_a(0));
    }

    protected void spawnDustingParticles() {
        if (!ConfigurationHandler.dusterParticles) {
            return;
        }
        if (!this.field_145850_b.field_72995_K && this.field_145850_b instanceof WorldServer) {
            WorldServer worldServer = (WorldServer)this.field_145850_b;
            ItemStack stack = this.func_70301_a(0);
            if (stack != null && stack.func_77973_b() != null && stack.field_77994_a > 0) {
                Item item = stack.func_77973_b();
                String s = null;
                double offsetY = 0.0;
                if (item instanceof ItemBlock) {
                    s = "blockcrack_" + Block.func_149682_b((Block)((ItemBlock)item).field_150939_a) + "_" + stack.func_77960_j();
                    offsetY = 0.1;
                } else {
                    s = "iconcrack_" + Item.func_150891_b((Item)item);
                    if (stack.func_77981_g()) {
                        s = s + "_" + stack.func_77960_j();
                    }
                    offsetY = 0.5;
                }
                offsetY += this.getParticleOffset();
                if (!Strings.isNullOrEmpty((String)s)) {
                    worldServer.func_147487_a(s, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + offsetY, (double)this.field_145849_e + 0.5, this.particles, 0.0, 0.0, 0.0, 0.075);
                }
            }
        }
    }

    protected double getParticleOffset() {
        return 1.0;
    }

    public void makeEurekaProgress(EntityPlayer player) {
        if (!Strings.isNullOrEmpty((String)this.key)) {
            EurekaAPI.API.makeProgress(this.key, player);
        }
    }

    @Override
    public void writeToByteBuff(ByteBuf buf) {
        buf.writeInt(this.progress);
        this.inventory.writeToByteBuff(buf);
    }

    @Override
    public void readFromByteBuff(ByteBuf buf) {
        this.progress = buf.readInt();
        this.inventory.readFromByteBuff(buf);
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("progress", this.progress);
        this.inventory.writeToNBT(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.progress = tag.func_74762_e("progress");
        this.inventory.readFromNBT(tag);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.inventory.func_70298_a(slot, amount);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
        this.func_70296_d();
    }

    public String func_145825_b() {
        return this.inventory.func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
        this.inventory.func_70295_k_();
    }

    public void func_70305_f() {
        this.inventory.func_70305_f();
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return false;
    }

    public int[] func_94128_d(int side) {
        return new int[0];
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return false;
    }
}

