/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.reference;

import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.recipes.IIntegrationRecipe;
import buildcraftAdditions.compat.buildcraft.BCItems;
import buildcraftAdditions.compat.buildcraft.recipe.ToolCoreRecipe;
import buildcraftAdditions.compat.buildcraft.recipe.tool.KineticToolUpgradeRecipe;
import buildcraftAdditions.config.ConfigurationHandler;
import buildcraftAdditions.items.ItemCanister;
import buildcraftAdditions.items.ItemMachineConfigurator;
import buildcraftAdditions.items.ItemMachineUpgrade;
import buildcraftAdditions.items.ItemPoweredBase;
import buildcraftAdditions.items.ItemStickBCA;
import buildcraftAdditions.items.Tools.ItemKineticMultiTool;
import buildcraftAdditions.items.Tools.ItemPipeColoringTool;
import buildcraftAdditions.items.Tools.ItemPortableLaser;
import buildcraftAdditions.items.Tools.ItemToolUpgrade;
import buildcraftAdditions.items.bases.ItemBase;
import buildcraftAdditions.items.dust.ItemDust;
import buildcraftAdditions.reference.BlockLoader;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ItemLoader {
    public static ItemCanister ironCanister;
    public static ItemCanister goldCanister;
    public static ItemCanister diamondCanister;
    public static Item powerCapsuleTier1;
    public static Item powerCapsuleTier2;
    public static Item powerCapsuleTier3;
    public static ItemStickBCA ironStick;
    public static ItemStickBCA goldStick;
    public static ItemStickBCA diamondStick;
    public static ItemStickBCA emeraldStick;
    public static ItemStickBCA netherStarStick;
    public static ItemStickBCA quartzStick;
    public static ItemStickBCA enderStick;
    public static ItemStickBCA redstoneStick;
    public static ItemStickBCA glowstoneStick;
    public static ItemStickBCA slimeStick;
    public static ItemStickBCA blazeStick;
    public static ItemBase toolCore;
    public static ItemToolUpgrade toolUpgradeHoe;
    public static ItemToolUpgrade toolUpgradeDigger;
    public static ItemToolUpgrade toolUpgradeDrill;
    public static ItemToolUpgrade toolUpgradeChainsaw;
    public static ItemToolUpgrade toolUpgradeArea;
    public static ItemToolUpgrade toolUpgradeSilky;
    public static ItemToolUpgrade toolUpgradeFortune1;
    public static ItemToolUpgrade toolUpgradeFortune2;
    public static ItemToolUpgrade toolUpgradeFortune3;
    public static Item grindingWheel;
    public static Item itemIronWireUnhardened;
    public static Item itemIronWire;
    public static Item goldWireUnhardened;
    public static Item goldWire;
    public static Item diamondWireUnhardened;
    public static Item diamondWire;
    public static Item kineticMultiTool;
    public static Item machineConfigurator;
    public static Item heatPlating;
    public static Item heatPlatingRaw;
    public static Item dust;
    public static Item pipeColoringTool;
    public static Item upgrade;
    public static Item blankUpgrade;
    public static Item portableLaser;
    public static Item gildedRedMetalIngot;
    public static Item conductivePlateRaw;
    public static Item conductivePlate;
    public static Item spring;
    public static Item lightPlating;
    public static Item thruster;
    public static Item fluxConductor;
    public static Item fluxDisperser;

    public static void loadItems() {
        ironCanister = new ItemCanister("ironCanister", 2000);
        goldCanister = new ItemCanister("goldCanister", 8000);
        diamondCanister = new ItemCanister("diamondCanister", 64000);
        powerCapsuleTier1 = new ItemPoweredBase("powerCapsuleTier1", 100000, 1024);
        powerCapsuleTier2 = new ItemPoweredBase("powerCapsuleTier2", 300000, 4096);
        powerCapsuleTier3 = new ItemPoweredBase("powerCapsuleTier3", 1000000, 16384);
        ironStick = new ItemStickBCA("Iron");
        goldStick = new ItemStickBCA("Gold");
        diamondStick = new ItemStickBCA("Diamond");
        emeraldStick = new ItemStickBCA("Emerald");
        netherStarStick = new ItemStickBCA("NetherStar");
        quartzStick = new ItemStickBCA("Quartz");
        enderStick = new ItemStickBCA("Ender");
        redstoneStick = new ItemStickBCA("Redstone");
        glowstoneStick = new ItemStickBCA("Glowstone");
        slimeStick = new ItemStickBCA("Slime");
        blazeStick = new ItemStickBCA("Blaze");
        toolUpgradeHoe = new ItemToolUpgrade("Hoe", "upgrades/hoe");
        toolUpgradeDigger = new ItemToolUpgrade("Digger", "upgrades/digger");
        toolUpgradeDrill = new ItemToolUpgrade("Drill", "upgrades/drill");
        toolUpgradeChainsaw = new ItemToolUpgrade("Chainsaw", "upgrades/chainsaw");
        toolUpgradeArea = new ItemToolUpgrade("Area", "upgrades/area");
        toolUpgradeSilky = new ItemToolUpgrade("Silky", "upgrades/silky");
        toolUpgradeFortune1 = new ItemToolUpgrade("Fortune1", "upgrades/fortune1");
        toolUpgradeFortune2 = new ItemToolUpgrade("Fortune2", "upgrades/fortune2");
        toolUpgradeFortune3 = new ItemToolUpgrade("Fortune3", "upgrades/fortune3");
        kineticMultiTool = new ItemKineticMultiTool();
        machineConfigurator = new ItemMachineConfigurator();
        pipeColoringTool = new ItemPipeColoringTool();
        portableLaser = new ItemPortableLaser();
        toolCore = new ItemBase("toolCore");
        grindingWheel = new ItemBase("grindingWheel");
        itemIronWireUnhardened = new ItemBase("wireIronUnhardened");
        itemIronWire = new ItemBase("wireIron");
        goldWireUnhardened = new ItemBase("wireGoldUnhardened");
        goldWire = new ItemBase("wireGold");
        diamondWireUnhardened = new ItemBase("wireDiamondUnhardened");
        diamondWire = new ItemBase("wireDiamond");
        heatPlatingRaw = new ItemBase("heatPlatingRaw");
        heatPlating = new ItemBase("heatPlating");
        blankUpgrade = new ItemBase("baseUpgrade", "upgrades/base", "blankUpgrade");
        conductivePlateRaw = new ItemBase("conductivePlateRaw");
        conductivePlate = new ItemBase("conductivePlate");
        spring = new ItemBase("spring", "components/spring");
        thruster = new ItemBase("thruster", "components/thruster");
        lightPlating = new ItemBase("lightPlating", "components/light plating");
        fluxConductor = new ItemBase("fluxConductor", "components/Flux_Conductor");
        fluxDisperser = new ItemBase("fluxDisperser", "components/Flux_Disperser");
        dust = new ItemDust();
        upgrade = new ItemMachineUpgrade();
        gildedRedMetalIngot = new ItemBase("gildedRedMetalIngot", "gildedRedMetalIngot", "ingotGildedRedMetal");
        OreDictionary.registerOre((String)"ingotGildedRedMetal", (Item)gildedRedMetalIngot);
    }

    public static void addRecipes() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(grindingWheel), new Object[]{"FFF", "FGF", "FFF", Character.valueOf('F'), Items.field_151145_ak, Character.valueOf('G'), "gearStone"}));
        KineticToolUpgradeRecipe kineticToolUpgradeRecipe = new KineticToolUpgradeRecipe();
        if (ConfigurationHandler.enabled("MultiTools")) {
            ItemLoader.addStickRecipe(ironStick, 1000, "ingotIron");
            ItemLoader.addStickRecipe(goldStick, 2000, "ingotGold");
            ItemLoader.addStickRecipe((ItemBase)diamondStick, 3000, "stickGold", "gemDiamond");
            ItemLoader.addStickRecipe((ItemBase)netherStarStick, 10000, "stickEmerald", Items.field_151156_bN);
            ItemLoader.addStickRecipe((ItemBase)quartzStick, 2000, "stickIron", "gemQuartz");
            ItemLoader.addStickRecipe((ItemBase)enderStick, 5000, "stickGold", Items.field_151079_bi);
            ItemLoader.addStickRecipe((ItemBase)redstoneStick, 3000, "stickIron", "dustRedstone");
            ItemLoader.addStickRecipe((ItemBase)glowstoneStick, 3000, "stickIron", "dustGlowstone");
            ItemLoader.addStickRecipe((ItemBase)slimeStick, 2000, "stickIron", "slimeball");
            ItemLoader.addStickRecipe((ItemBase)blazeStick, 4000, "stickQuartz", Items.field_151072_bj);
            ItemLoader.addAssemblyRecipe("kineticTool", kineticMultiTool, 8000, new Object[]{"gemDiamond", "gemDiamond", "gemDiamond", "stickIron", toolCore});
            ItemLoader.addUpgradeRecipe(toolUpgradeChainsaw);
            ItemLoader.addUpgradeRecipe(toolUpgradeDrill);
            ItemLoader.addUpgradeRecipe(toolUpgradeDigger);
            ItemLoader.addUpgradeRecipe(toolUpgradeHoe);
            BuildcraftRecipeRegistry.integrationTable.addRecipe((IIntegrationRecipe)new ToolCoreRecipe());
            kineticToolUpgradeRecipe.register("drill", toolUpgradeDrill);
            kineticToolUpgradeRecipe.register("digger", toolUpgradeDigger);
            kineticToolUpgradeRecipe.register("chainsaw", toolUpgradeChainsaw);
            kineticToolUpgradeRecipe.register("hoe", toolUpgradeHoe);
        }
        if (ConfigurationHandler.enabled("MultiToolsArea")) {
            kineticToolUpgradeRecipe.register("area", toolUpgradeArea);
            ItemLoader.addUpgradeRecipe(toolUpgradeArea, new ItemStack((Block)Blocks.field_150320_F), new ItemStack(Items.field_151079_bi), "ingotGold");
        }
        if (ConfigurationHandler.enabled("MultiToolsSilky")) {
            kineticToolUpgradeRecipe.register("silky", toolUpgradeSilky);
            ItemLoader.addUpgradeRecipe(toolUpgradeSilky, new ItemStack(Items.field_151007_F, 3), "slimeball", "ingotGold");
        }
        if (ConfigurationHandler.enabled("MultiToolsFortune")) {
            ItemLoader.addUpgradeRecipe(toolUpgradeFortune1, new ItemStack(Items.field_151007_F, 3), "gemLapis", "blockLapis", "ingotGold");
            ItemLoader.addUpgradeRecipe(toolUpgradeFortune2, new ItemStack((Item)toolUpgradeFortune1), "gemDiamond", "blockLapis", "ingotGold");
            ItemLoader.addUpgradeRecipe(toolUpgradeFortune3, new ItemStack((Item)toolUpgradeFortune2), "gemEmerald", "blockLapis", "ingotGold");
            kineticToolUpgradeRecipe.register("fortune1", toolUpgradeFortune1);
            kineticToolUpgradeRecipe.register("fortune2", toolUpgradeFortune2);
            kineticToolUpgradeRecipe.register("fortune3", toolUpgradeFortune3);
        }
        if (ConfigurationHandler.enabled("FluidCanisters")) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ironCanister, 4), new Object[]{"PIP", "IGI", "PIP", Character.valueOf('P'), BCItems.SEALANT, Character.valueOf('I'), "ingotIron", Character.valueOf('G'), "paneGlass"}));
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)goldCanister), (Object[])new Object[]{"PGP", "GIG", "PGP", Character.valueOf('P'), BCItems.SEALANT, Character.valueOf('G'), Items.field_151043_k, Character.valueOf('I'), ironCanister});
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)diamondCanister), (Object[])new Object[]{"PDP", "DGD", "PDP", Character.valueOf('P'), BCItems.SEALANT, Character.valueOf('D'), Items.field_151045_i, Character.valueOf('G'), goldCanister});
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(BlockLoader.fluidicCompressorBlock), new Object[]{"GFG", "PCP", "IGI", Character.valueOf('G'), "ingotGold", Character.valueOf('F'), fluxConductor, Character.valueOf('C'), goldCanister, Character.valueOf('I'), "ingotIron", Character.valueOf('P'), Blocks.field_150331_J}));
            if (ConfigurationHandler.enabled("PortableLaser")) {
                ItemLoader.addAssemblyRecipe("portableLaser", portableLaser, 8000, new Object[]{"blockGlass", "gemDiamond", "stickBlaze", "stickBlaze", BCItems.LASER, toolCore});
            }
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(heatPlatingRaw, 2), new Object[]{"DD", "DD", Character.valueOf('D'), "dustIron"}));
            GameRegistry.addSmelting((ItemStack)new ItemStack(heatPlatingRaw), (ItemStack)new ItemStack(heatPlating), (float)0.0f);
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)toolUpgradeChainsaw), (Object[])new Object[]{"U", Character.valueOf('U'), toolUpgradeDigger});
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)toolUpgradeDigger), (Object[])new Object[]{"U", Character.valueOf('U'), toolUpgradeDrill});
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)toolUpgradeDrill), (Object[])new Object[]{"U", Character.valueOf('U'), toolUpgradeHoe});
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)toolUpgradeHoe), (Object[])new Object[]{"U", Character.valueOf('U'), toolUpgradeChainsaw});
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(machineConfigurator), new Object[]{"RIB", " W ", "YIY", Character.valueOf('B'), "dyeBlue", Character.valueOf('I'), "ingotIron", Character.valueOf('R'), "dyeRed", Character.valueOf('W'), BCItems.WRENCH != null ? BCItems.WRENCH : Items.field_151042_j, Character.valueOf('Y'), "dyeYellow"}));
        }
        kineticToolUpgradeRecipe.register("goldStick", "stickGold");
        kineticToolUpgradeRecipe.register("diamondStick", "stickDiamond", "goldStick");
        kineticToolUpgradeRecipe.register("enderStick", "stickEnder", "goldStick");
        kineticToolUpgradeRecipe.register("emeraldStick", "stickEmerald", "diamondStick");
        kineticToolUpgradeRecipe.register("netherStarStick", "stickNetherStar", "emeraldStick");
        kineticToolUpgradeRecipe.register("redstoneStick", "stickRedstone");
        kineticToolUpgradeRecipe.register("slimeStick", "stickSlime", "redstoneStick");
        kineticToolUpgradeRecipe.register("blazeStick", "stickBlaze", "redstoneStick");
        kineticToolUpgradeRecipe.register("glowstoneStick", "stickGlowstone", "redstoneStick");
        kineticToolUpgradeRecipe.register("quartzStick", "stickQuartz", "glowstoneStick");
        BuildcraftRecipeRegistry.integrationTable.addRecipe((IIntegrationRecipe)kineticToolUpgradeRecipe);
        if (ConfigurationHandler.enabled("ColoringTool")) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(pipeColoringTool, new Object[]{"  S", " C ", "W  ", Character.valueOf('W'), new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE), Character.valueOf('S'), "stickIron", Character.valueOf('C'), powerCapsuleTier1}));
        }
        GameRegistry.addRecipe((ItemStack)new ItemStack(blankUpgrade, 2), (Object[])new Object[]{"GGG", "GPG", "GGG", Character.valueOf('G'), Items.field_151043_k, Character.valueOf('P'), heatPlating});
        GameRegistry.addSmelting((Item)conductivePlateRaw, (ItemStack)new ItemStack(conductivePlate), (float)0.5f);
        GameRegistry.addRecipe((ItemStack)new ItemStack(thruster), (Object[])new Object[]{"LCL", "LPL", "I I", Character.valueOf('L'), lightPlating, Character.valueOf('C'), powerCapsuleTier2, Character.valueOf('P'), conductivePlate, Character.valueOf('I'), Items.field_151042_j});
        GameRegistry.addRecipe((ItemStack)new ItemStack(lightPlating, 2), (Object[])new Object[]{"CH", "HC", Character.valueOf('C'), conductivePlate, Character.valueOf('H'), heatPlating});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(spring), new Object[]{"III", "I I", "III", Character.valueOf('I'), "ingotIron"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(fluxConductor), new Object[]{"GIG", "GRG", "GIG", Character.valueOf('G'), "ingotGold", Character.valueOf('I'), "ingotIron", Character.valueOf('R'), "dustRedstone"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(fluxDisperser), new Object[]{"IGI", "IRI", "IGI", Character.valueOf('G'), "ingotGold", Character.valueOf('I'), "ingotIron", Character.valueOf('R'), "dustRedstone"}));
    }

    private static void addUpgradeRecipe(ItemToolUpgrade upgrade, Object ... inputs) {
        if (inputs != null) {
            Object[] inputs2 = new Object[inputs.length + 1];
            inputs2[0] = new ItemStack((Item)toolCore);
            System.arraycopy(inputs, 0, inputs2, 1, inputs2.length - 1);
            ItemLoader.addAssemblyRecipe("toolUpgrade" + upgrade.getType(), upgrade, 1000, inputs2);
        }
    }

    private static void addUpgradeRecipe(ItemToolUpgrade upgrade) {
        ItemLoader.addAssemblyRecipe("toolUpgrade" + upgrade.getType(), upgrade, 1000, new Object[]{toolCore, "ingotIron", "ingotIron", "ingotIron", "ingotGold", "ingotGold"});
    }

    private static void addAssemblyRecipe(String name, Item output, int power, Object ... inputs) {
        BuildcraftRecipeRegistry.assemblyTable.addRecipe("bcadditions:" + name, power, new ItemStack(output), inputs);
    }

    private static void addStickRecipe(ItemBase stick, int power, String materialItem) {
        BuildcraftRecipeRegistry.assemblyTable.addRecipe("bcadditions:" + stick.getName(), power, new ItemStack((Item)stick), new Object[]{materialItem});
    }

    private static void addStickRecipe(ItemBase stick, int power, String stickInput, String materialItem) {
        BuildcraftRecipeRegistry.assemblyTable.addRecipe("bcadditions:" + stick.getName(), power, new ItemStack((Item)stick), new Object[]{stickInput, materialItem});
    }

    private static void addStickRecipe(ItemBase stick, int power, String stickInput, Item materialItem) {
        BuildcraftRecipeRegistry.assemblyTable.addRecipe("bcadditions:" + stick.getName(), power, new ItemStack((Item)stick), new Object[]{stickInput, new ItemStack(materialItem)});
    }
}

