/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.recipe.refinery;

import buildcraftAdditions.api.recipe.refinery.IRefineryRecipe;
import buildcraftAdditions.api.recipe.refinery.IRefineryRecipeManager;
import buildcraftAdditions.core.Logger;
import buildcraftAdditions.recipe.refinery.RefineryRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraftforge.fluids.FluidStack;

public class RefineryRecipeManager
implements IRefineryRecipeManager {
    private final List<IRefineryRecipe> recipes = new ArrayList<IRefineryRecipe>();

    @Override
    public void addRecipe(FluidStack input, FluidStack output, int requiredHeat) {
        if (input == null || input.getFluid() == null || input.amount <= 0 || output == null || output.getFluid() == null || output.amount <= 0) {
            Logger.error("Tried to register an invalid refinery recipe! Skipping.");
            Logger.error("Was trying to add: Input: " + input + " Output: " + output + " Required heat: " + requiredHeat);
            return;
        }
        IRefineryRecipe recipe = this.getRecipe(input);
        if (recipe != null) {
            Logger.error("A refinery recipe with input  " + input + " is already registered! Skipping.");
            Logger.error("Was trying to add: Input: " + input + " Output: " + output + " Required heat: " + requiredHeat);
            Logger.error("Found: Input: " + input + " Output: " + recipe.getOutput() + " Required heat: " + recipe.getRequiredHeat());
            return;
        }
        this.recipes.add(new RefineryRecipe(input, output, requiredHeat));
    }

    @Override
    public void addRecipe(IRefineryRecipe recipe) {
        IRefineryRecipe refineryRecipe;
        if (recipe == null || recipe.getInput() == null || recipe.getOutput() == null || recipe.getRequiredHeat() < 0) {
            Logger.error("Tried to register an invalid cooling tower recipe! Skipping.");
            Logger.error("Was trying to add: " + recipe);
        }
        if ((refineryRecipe = this.getRecipe(recipe.getInput())) != null) {
            Logger.error("A refinery recipe with input  " + recipe.getInput() + " is already registered! Skipping.");
            Logger.error("Was trying to add: Input: " + recipe.getInput() + " Output: " + recipe.getInput() + " Required heat: " + recipe.getRequiredHeat());
            Logger.error("Found: Input: " + refineryRecipe.getInput() + " Output: " + refineryRecipe.getOutput() + " Required heat: " + refineryRecipe.getRequiredHeat());
            return;
        }
        this.recipes.add(recipe);
    }

    @Override
    public void removeRecipe(FluidStack input) {
        if (input != null) {
            IRefineryRecipe recipe = null;
            Iterator<IRefineryRecipe> iterator = this.recipes.iterator();
            while (iterator.hasNext()) {
                if (recipe != null && input.isFluidEqual(recipe.getInput())) {
                    iterator.remove();
                    return;
                }
                recipe = iterator.next();
            }
        }
    }

    @Override
    public IRefineryRecipe getRecipe(FluidStack input) {
        if (input != null) {
            for (IRefineryRecipe recipe : this.recipes) {
                if (recipe == null || !input.isFluidEqual(recipe.getInput())) continue;
                return recipe;
            }
        }
        return null;
    }

    @Override
    public List<? extends IRefineryRecipe> getRecipes() {
        return Collections.unmodifiableList(this.recipes);
    }
}

