/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.recipe.refinery;

import buildcraftAdditions.api.recipe.refinery.ICoolingTowerRecipe;
import buildcraftAdditions.api.recipe.refinery.ICoolingTowerRecipeManager;
import buildcraftAdditions.core.Logger;
import buildcraftAdditions.recipe.refinery.CoolingTowerRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraftforge.fluids.FluidStack;

public class CoolingTowerRecipeManager
implements ICoolingTowerRecipeManager {
    private final List<ICoolingTowerRecipe> recipes = new ArrayList<ICoolingTowerRecipe>();

    @Override
    public void addRecipe(FluidStack input, FluidStack output, float heat) {
        if (input == null || input.getFluid() == null || input.amount <= 0 || output == null || output.getFluid() == null || output.amount <= 0) {
            Logger.error("Tried to register an invalid cooling tower recipe! Skipping.");
            Logger.error("Was trying to add: Input: " + input + " Output: " + output + " Heat: " + heat);
            return;
        }
        ICoolingTowerRecipe recipe = this.getRecipe(input);
        if (recipe != null) {
            Logger.error("A cooling tower recipe with input  " + input + " is already registered! Skipping.");
            Logger.error("Was trying to add: Input: " + input + " Output: " + output + " Heat: " + heat);
            Logger.error("Found: Input: " + input + " Output: " + recipe.getOutput() + " Heat: " + recipe.getHeat());
            return;
        }
        this.recipes.add(new CoolingTowerRecipe(input, output, heat));
    }

    @Override
    public void addRecipe(ICoolingTowerRecipe recipe) {
        ICoolingTowerRecipe coolingTowerRecipe;
        if (recipe == null || recipe.getInput() == null || recipe.getOutput() == null) {
            Logger.error("Tried to register an invalid cooling tower recipe! Skipping.");
            Logger.error("Was trying to add: " + recipe);
        }
        if ((coolingTowerRecipe = this.getRecipe(recipe.getInput())) != null) {
            Logger.error("A cooling tower recipe with input  " + recipe.getInput() + " is already registered! Skipping.");
            Logger.error("Was trying to add: Input: " + recipe.getInput() + " Output: " + recipe.getInput() + " Heat: " + recipe.getHeat());
            Logger.error("Found: Input: " + coolingTowerRecipe.getInput() + " Output: " + coolingTowerRecipe.getOutput() + " Heat: " + coolingTowerRecipe.getHeat());
            return;
        }
        this.recipes.add(recipe);
    }

    @Override
    public void removeRecipe(FluidStack input) {
        if (input != null) {
            ICoolingTowerRecipe recipe = null;
            Iterator<ICoolingTowerRecipe> iterator = this.recipes.iterator();
            while (iterator.hasNext()) {
                if (recipe != null && input.isFluidEqual(recipe.getInput())) {
                    iterator.remove();
                    return;
                }
                recipe = iterator.next();
            }
        }
    }

    @Override
    public ICoolingTowerRecipe getRecipe(FluidStack input) {
        if (input != null) {
            for (ICoolingTowerRecipe recipe : this.recipes) {
                if (recipe == null || !input.isFluidEqual(recipe.getInput())) continue;
                return recipe;
            }
        }
        return null;
    }

    @Override
    public List<? extends ICoolingTowerRecipe> getRecipes() {
        return Collections.unmodifiableList(this.recipes);
    }
}

