/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.recipe.duster;

import buildcraftAdditions.api.recipe.duster.IDusterRecipe;
import buildcraftAdditions.api.recipe.duster.IDusterRecipeManager;
import buildcraftAdditions.core.Logger;
import buildcraftAdditions.recipe.duster.DusterRecipe;
import buildcraftAdditions.recipe.duster.DusterRecipeOreDict;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StringUtils;

public class DusterRecipeManager
implements IDusterRecipeManager {
    private final List<IDusterRecipe> recipes = new ArrayList<IDusterRecipe>();

    @Override
    public void addRecipe(ItemStack input, ItemStack output) {
        if (input == null || input.func_77973_b() == null || output == null || output.func_77973_b() == null || output.field_77994_a <= 0) {
            Logger.error("Tried to register an invalid duster recipe! Skipping.");
            Logger.error("Was trying to add: Input: " + input + " Output: " + output);
            return;
        }
        IDusterRecipe recipe = this.getRecipe(input);
        if (recipe != null) {
            Logger.error("A duster recipe with input " + input + " is already registered! Skipping.");
            Logger.error("Was trying to add: Input: " + input + " Output: " + output);
            Logger.error("Found: Input: " + input + " Output: " + recipe.getOutput(input));
            return;
        }
        this.recipes.add(new DusterRecipe(input, output));
        Logger.info("Successfully added duster recipe with Input: " + input + " Output: " + output);
    }

    @Override
    public void addRecipe(String oreInput, ItemStack output) {
        if (StringUtils.func_151246_b((String)oreInput) || output == null || output.func_77973_b() == null || output.field_77994_a <= 0) {
            Logger.error("Tried to register an invalid duster recipe! Skipping.");
            Logger.error("Was trying to add: Input: " + oreInput + " Output: " + output);
            return;
        }
        DusterRecipeOreDict newRecipe = new DusterRecipeOreDict(oreInput, output);
        for (ItemStack input : newRecipe.getInputs()) {
            IDusterRecipe recipe = this.getRecipe(input);
            if (recipe == null) continue;
            Logger.error("A duster recipe with input " + input + " is already registered! " + (recipe instanceof DusterRecipeOreDict ? "Skipping." : "Overwriting."));
            Logger.error("Was trying to add: Input: " + oreInput + " Output: " + output);
            Logger.error("Found: Input: " + input + " Output: " + recipe.getOutput(input));
            if (recipe instanceof DusterRecipeOreDict) {
                return;
            }
            this.removeRecipe(input);
        }
        this.recipes.add(newRecipe);
        Logger.info("Successfully added duster recipe with Input: " + oreInput + " Output: " + output);
    }

    @Override
    public void addRecipe(IDusterRecipe recipe) {
        if (recipe == null || recipe.getInputs() == null || recipe.getInputs().size() <= 0) {
            Logger.error("Tried to register an invalid duster recipe! Skipping.");
            Logger.error("Was trying to add: " + recipe);
        }
        for (ItemStack input : recipe.getInputs()) {
            IDusterRecipe dusterRecipe = this.getRecipe(input);
            if (dusterRecipe == null) continue;
            Logger.error("A duster recipe with input " + input + " is already registered! " + (dusterRecipe instanceof DusterRecipeOreDict ? "Skipping." : "Overwriting."));
            Logger.error("Was trying to add: Valid inputs: " + recipe.getInputs() + " Output: " + recipe.getOutput(input));
            Logger.error("Found: Input: " + input + " Output: " + dusterRecipe.getOutput(input));
            if (dusterRecipe instanceof DusterRecipeOreDict) {
                return;
            }
            this.removeRecipe(input);
        }
        this.recipes.add(recipe);
        Logger.info("Successfully added duster recipe with Valid inputs: " + recipe.getInputs());
    }

    @Override
    public void removeRecipe(ItemStack input) {
        if (input != null) {
            IDusterRecipe recipe = null;
            Iterator<IDusterRecipe> iterator = this.recipes.iterator();
            while (iterator.hasNext()) {
                if (recipe != null && recipe.getOutput(input) != null) {
                    iterator.remove();
                    Logger.info("Successfully removed duster recipe with Valid inputs: " + recipe.getInputs());
                    return;
                }
                recipe = iterator.next();
            }
            Logger.error("Tried to remove an invalid duster recipe! A duster recipe with the input " + input + " could not be found! Skipping.");
        } else {
            Logger.error("Tried to remove an invalid duster recipe! Skipping.");
        }
    }

    @Override
    public IDusterRecipe getRecipe(ItemStack input) {
        if (input != null) {
            for (IDusterRecipe recipe : this.recipes) {
                if (recipe == null || recipe.getOutput(input) == null) continue;
                return recipe;
            }
        }
        return null;
    }

    @Override
    public List<? extends IDusterRecipe> getRecipes() {
        return Collections.unmodifiableList(this.recipes);
    }
}

