/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.multiBlocks;

import buildcraftAdditions.blocks.multiBlocks.MultiBlockBase;
import buildcraftAdditions.multiBlocks.IMultiBlockTile;
import buildcraftAdditions.utils.Location;
import buildcraftAdditions.utils.RotationUtils;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.material.Material;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MultiBlockPatern {
    protected final ForgeDirection[] directions;
    protected final char[] identifiers;
    protected ForgeDirection[] rotatedDirections;
    protected HashMap<String, String> replacements = new HashMap(5);
    protected boolean rotatable;

    public MultiBlockPatern(ForgeDirection[] directions, char identifier) {
        int length = directions.length;
        this.directions = directions;
        this.identifiers = new char[length];
        for (int t = 0; t < length; ++t) {
            this.identifiers[t] = identifier;
        }
        this.rotatable = true;
    }

    public MultiBlockPatern(ForgeDirection[] directions, char[] identifiers, HashMap<String, String> replacements) {
        this.directions = directions;
        this.identifiers = identifiers;
        this.replacements = replacements;
        this.rotatable = true;
    }

    public MultiBlockPatern(ForgeDirection[] directions, char identifier, HashMap<String, String> replacements) {
        int length = directions.length;
        this.directions = directions;
        this.identifiers = new char[length];
        for (int t = 0; t < length; ++t) {
            this.identifiers[t] = identifier;
        }
        this.replacements = replacements;
        this.rotatable = true;
    }

    public void checkPatern(World world, int x, int y, int z) {
        int rotation = 0;
        boolean valid = false;
        for (int t = 0; t < 4 && (t <= 0 || this.rotatable); ++t) {
            if (!this.isPaternValid(world, x, y, z, t)) continue;
            rotation = t;
            valid = true;
            break;
        }
        if (valid) {
            this.rotatedDirections = RotationUtils.rotateDirections(rotation, this.directions);
            Location location = new Location(world, x, y, z);
            for (ForgeDirection direction : this.rotatedDirections) {
                location.move(direction);
                if (location.getBlock().func_149688_o() == Material.field_151579_a) continue;
                location.setMetadata(1);
                IMultiBlockTile slave = (IMultiBlockTile)location.getTileEntity();
                slave.formMultiblock(x, y, z, rotation);
            }
            this.letNeighboursKnow(world, x, y, z, rotation);
            this.addMaster(world, x, y, z, rotation);
        }
    }

    public boolean isPaternValid(World world, int startX, int startY, int startZ, int rotationIndex) {
        Location location = new Location(world, startX, startY, startZ);
        int length = this.directions.length;
        this.rotatedDirections = RotationUtils.rotateDirections(rotationIndex, this.directions);
        for (int t = 0; t < length; ++t) {
            ForgeDirection direction = this.rotatedDirections[t];
            location.move(direction);
            if (this.identifiers[t] == '\n') {
                if (location.getBlock().func_149688_o() == Material.field_151579_a) continue;
                return false;
            }
            if (!(location.getBlock() instanceof MultiBlockBase)) {
                return false;
            }
            MultiBlockBase block = (MultiBlockBase)location.getBlock();
            if (block.identifier == this.identifiers[t] && location.getMeatadata() == 0) continue;
            return false;
        }
        return true;
    }

    public boolean isPaternValid(World world, int startX, int startY, int startZ) {
        Location location = new Location(world, startX, startY, startZ);
        int length = this.directions.length;
        for (int t = 0; t < length; ++t) {
            ForgeDirection direction = this.directions[t];
            location.move(direction);
            if (this.identifiers[t] == '\n') {
                if (location.getBlock().func_149688_o() == Material.field_151579_a) continue;
                return false;
            }
            if (!(location.getBlock() instanceof MultiBlockBase)) {
                return false;
            }
            MultiBlockBase block = (MultiBlockBase)location.getBlock();
            if (block.identifier == this.identifiers[t] && location.getMeatadata() == 0) continue;
            return false;
        }
        return true;
    }

    public void destroyMultiblock(World world, int x, int y, int z, int rotationIndex) {
        Location location = new Location(world, x, y, z);
        for (ForgeDirection direction : this.rotatedDirections = RotationUtils.rotateDirections(rotationIndex, this.directions)) {
            location.move(direction);
            if (!(location.getTileEntity() instanceof IMultiBlockTile)) continue;
            ((IMultiBlockTile)location.getTileEntity()).invalidateBlock();
        }
    }

    public ArrayList<Location> getLocations(World world, int masterX, int masterY, int masterZ, int rotationIndex) {
        ArrayList<Location> list = new ArrayList<Location>(this.directions.length);
        Location location = new Location(world, masterX, masterY, masterZ);
        for (ForgeDirection direction : this.rotatedDirections = RotationUtils.rotateDirections(rotationIndex, this.directions)) {
            location.move(direction);
            list.add(location.copy());
        }
        return list;
    }

    protected void addMaster(World world, int x, int y, int z, int rotationIndex) {
        TileEntity entity = world.func_147438_o(x, y, z);
        if (entity != null && entity instanceof IMultiBlockTile) {
            IMultiBlockTile master = (IMultiBlockTile)entity;
            master.makeMaster(rotationIndex);
            master.sync();
        }
    }

    public void letNeighboursKnow(World world, int x, int y, int z, int rotationIndex) {
        this.rotatedDirections = RotationUtils.rotateDirections(rotationIndex, this.directions);
        Location location = new Location(world, x, y, z);
        for (ForgeDirection direction : this.rotatedDirections) {
            location.move(direction);
            location.neighbourUpdate();
        }
    }

    public boolean isRotatable() {
        return this.rotatable;
    }

    public MultiBlockPatern setRotatable(boolean rotatable) {
        this.rotatable = rotatable;
        return this;
    }
}

