/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.items.dust;

import buildcraftAdditions.api.item.dust.IDustType;
import buildcraftAdditions.api.recipe.BCARecipeManager;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class DustTypes {
    public static final IDustType METAL_DUST = new IDustType(){

        @Override
        public void register(int meta, String name, ItemStack dust) {
            OreDictionary.registerOre((String)("dust" + name), (ItemStack)dust.func_77946_l());
            ItemStack twoDusts = dust.func_77946_l();
            twoDusts.field_77994_a = 2;
            ItemStack nineDusts = dust.func_77946_l();
            nineDusts.field_77994_a = 9;
            BCARecipeManager.duster.addRecipe("ore" + name, twoDusts);
            BCARecipeManager.duster.addRecipe("ingot" + name, dust.func_77946_l());
            BCARecipeManager.duster.addRecipe("block" + name, nineDusts);
            for (ItemStack stack : OreDictionary.getOres((String)("ingot" + name))) {
                ItemStack copy = ItemStack.func_77944_b((ItemStack)stack);
                if (copy == null || copy.func_77973_b() == null) continue;
                copy.field_77994_a = 1;
                GameRegistry.addSmelting((ItemStack)dust.func_77946_l(), (ItemStack)copy, (float)0.0f);
                return;
            }
        }

        @Override
        public String getName() {
            return "Metal";
        }

        @Override
        public boolean isValid(int meta, String name, ItemStack dust) {
            return OreDictionary.getOres((String)("ore" + name)).size() > 0 || OreDictionary.getOres((String)("ingot" + name)).size() > 0 || OreDictionary.getOres((String)("block" + name)).size() > 0 || OreDictionary.getOres((String)("dust" + name)).size() > 0;
        }
    };
    public static final IDustType METAL_DUST_FORCE_REGISTRATION = new DustAlwaysValid();
    public static final IDustType GEM_DUST = new IDustType(){

        @Override
        public void register(int meta, String name, ItemStack dust) {
            OreDictionary.registerOre((String)("dust" + name), (ItemStack)dust.func_77946_l());
            BCARecipeManager.duster.addRecipe("gem" + name, dust.func_77946_l());
        }

        @Override
        public String getName() {
            return "Gem";
        }

        @Override
        public boolean isValid(int meta, String name, ItemStack dust) {
            return OreDictionary.getOres((String)("ore" + name)).size() > 0 || OreDictionary.getOres((String)("gem" + name)).size() > 0 || OreDictionary.getOres((String)("dust" + name)).size() > 0;
        }
    };
    public static final IDustType ENDERIUM_BASE_DUST = new IDustType(){

        @Override
        public void register(int meta, String name, ItemStack dust) {
            OreDictionary.registerOre((String)("dust" + name), (ItemStack)dust.func_77946_l());
            BCARecipeManager.duster.addRecipe("ingot" + name, dust.func_77946_l());
            for (ItemStack stack : OreDictionary.getOres((String)("ingot" + name))) {
                ItemStack copy = ItemStack.func_77944_b((ItemStack)stack);
                if (copy == null || copy.func_77973_b() == null) continue;
                copy.field_77994_a = 1;
                GameRegistry.addSmelting((ItemStack)dust.func_77946_l(), (ItemStack)copy, (float)0.0f);
                return;
            }
        }

        @Override
        public String getName() {
            return "Enderium Base";
        }

        @Override
        public boolean isValid(int meta, String name, ItemStack dust) {
            return OreDictionary.getOres((String)("ingot" + name)).size() > 0 || OreDictionary.getOres((String)("block" + name)).size() > 0 || OreDictionary.getOres((String)("dust" + name)).size() > 0 || OreDictionary.getOres((String)"ingotEnderium").size() > 0 || OreDictionary.getOres((String)"blockEnderium").size() > 0 || OreDictionary.getOres((String)"dustEnderium").size() > 0;
        }
    };
    public static final IDustType ENDERIUM_DUST = new IDustType(){

        @Override
        public void register(int meta, String name, ItemStack dust) {
            ItemStack nineDusts = dust.func_77946_l();
            nineDusts.field_77994_a = 9;
            BCARecipeManager.duster.addRecipe("ingot" + name, dust.func_77946_l());
            BCARecipeManager.duster.addRecipe("block" + name, nineDusts);
            for (ItemStack stack : OreDictionary.getOres((String)("ingot" + name))) {
                ItemStack copy = ItemStack.func_77944_b((ItemStack)stack);
                if (copy == null || copy.func_77973_b() == null) continue;
                copy.field_77994_a = 1;
                GameRegistry.addSmelting((ItemStack)dust.func_77946_l(), (ItemStack)copy, (float)0.0f);
                return;
            }
        }

        @Override
        public String getName() {
            return "Enderium";
        }

        @Override
        public boolean isValid(int meta, String name, ItemStack dust) {
            return OreDictionary.getOres((String)("ingot" + name)).size() > 0 || OreDictionary.getOres((String)("block" + name)).size() > 0 || OreDictionary.getOres((String)("dust" + name)).size() > 0 || OreDictionary.getOres((String)"ingotEnderiumBase").size() > 0 || OreDictionary.getOres((String)"blockEnderiumBase").size() > 0 || OreDictionary.getOres((String)"dustEnderiumBase").size() > 0;
        }
    };
    public static final IDustType ONLY_ORE_DICTIONARY_REGISTRATION = new IDustType(){

        @Override
        public void register(int meta, String name, ItemStack dust) {
            OreDictionary.registerOre((String)("dust" + name), (ItemStack)dust.func_77946_l());
        }

        @Override
        public String getName() {
            return "OreDictionary";
        }

        @Override
        public boolean isValid(int meta, String name, ItemStack dust) {
            return OreDictionary.getOres((String)("dust" + name)).size() > 0;
        }
    };

    public static class SimpleDustWithOre
    implements IDustType {
        private final int dustNumber;

        public SimpleDustWithOre(int dustNumber) {
            this.dustNumber = dustNumber;
        }

        @Override
        public void register(int meta, String name, ItemStack dust) {
            OreDictionary.registerOre((String)("dust" + name), (ItemStack)dust.func_77946_l());
            ItemStack dusts = dust.func_77946_l();
            dusts.field_77994_a = this.dustNumber;
            BCARecipeManager.duster.addRecipe("ore" + name, dusts);
        }

        @Override
        public String getName() {
            return "Simple Dust with Ore (" + this.dustNumber + "x dust)";
        }

        @Override
        public boolean isValid(int meta, String name, ItemStack dust) {
            return OreDictionary.getOres((String)("ore" + name)).size() > 0 || OreDictionary.getOres((String)("dust" + name)).size() > 0;
        }
    }

    public static class SimpleDustAlwaysValid
    implements IDustType {
        private final ItemStack stack;
        private final int dustNumber;

        public SimpleDustAlwaysValid(ItemStack stack) {
            this(stack, 1);
        }

        public SimpleDustAlwaysValid(ItemStack stack, int dustNumber) {
            this.stack = stack;
            this.dustNumber = dustNumber;
        }

        @Override
        public void register(int meta, String name, ItemStack dust) {
            OreDictionary.registerOre((String)("dust" + name), (ItemStack)dust.func_77946_l());
            ItemStack dusts = dust.func_77946_l();
            dusts.field_77994_a = this.dustNumber;
            BCARecipeManager.duster.addRecipe(this.stack, dusts);
        }

        @Override
        public String getName() {
            return "SimpleDust";
        }

        @Override
        public boolean isValid(int meta, String name, ItemStack dust) {
            return true;
        }
    }

    public static final class DustAlwaysValid
    implements IDustType {
        @Override
        public void register(int meta, String name, ItemStack dust) {
            OreDictionary.registerOre((String)("dust" + name), (ItemStack)dust.func_77946_l());
            ItemStack twoDusts = dust.func_77946_l();
            twoDusts.field_77994_a = 2;
            ItemStack nineDusts = dust.func_77946_l();
            nineDusts.field_77994_a = 9;
            BCARecipeManager.duster.addRecipe("ore" + name, twoDusts);
            BCARecipeManager.duster.addRecipe("ingot" + name, dust.func_77946_l());
            BCARecipeManager.duster.addRecipe("block" + name, nineDusts);
            for (ItemStack stack : OreDictionary.getOres((String)("ingot" + name))) {
                ItemStack copy = ItemStack.func_77944_b((ItemStack)stack);
                if (copy == null || copy.func_77973_b() == null) continue;
                copy.field_77994_a = 1;
                GameRegistry.addSmelting((ItemStack)dust.func_77946_l(), (ItemStack)copy, (float)0.0f);
                return;
            }
        }

        @Override
        public String getName() {
            return "Metal";
        }

        @Override
        public boolean isValid(int meta, String name, ItemStack dust) {
            return true;
        }
    }
}

