/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.items.dust;

import buildcraftAdditions.api.item.dust.IDust;
import buildcraftAdditions.api.item.dust.IDustManager;
import buildcraftAdditions.api.item.dust.IDustType;
import buildcraftAdditions.config.ConfigurationHandler;
import buildcraftAdditions.core.Logger;
import buildcraftAdditions.items.dust.Dust;
import buildcraftAdditions.items.dust.DustTypes;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.StringUtils;

public class DustManager
implements IDustManager {
    private final IDust[] dusts = new IDust[Short.MAX_VALUE];

    @Override
    public void addDust(int meta, String name, int colorMultiplier, IDustType dustType) {
        if (!ConfigurationHandler.shouldRegisterDusts && !(dustType instanceof DustTypes.DustAlwaysValid)) {
            Logger.info("Dust registering is disabled via config.");
            Logger.info("Was trying to add: Meta: " + meta + ", Name: " + name + ", Color multiplier: " + colorMultiplier + ", Dust type: " + (dustType != null ? dustType.getName() : "null"));
            return;
        }
        if (meta < 0 || meta >= this.dusts.length) {
            Logger.error("Tried to register an invalid dust! The meta '" + meta + "' is out of bounds! Skipping.");
            Logger.error("Was trying to add: Meta: " + meta + ", Name: " + name + ", Color multiplier: " + colorMultiplier + ", Dust type: " + (dustType != null ? dustType.getName() : "null"));
            return;
        }
        if (StringUtils.func_151246_b((String)name) || Character.isLowerCase(name.charAt(0))) {
            Logger.error("Tried to register an invalid dust! The name '" + name + "' is not valid! Skipping.");
            Logger.error("Was trying to add: Meta: " + meta + ", Name: " + name + ", Color multiplier: " + colorMultiplier + ", Dust type: " + (dustType != null ? dustType.getName() : "null"));
            return;
        }
        if (dustType == null) {
            Logger.error("Tried to register an invalid dust! The dust type must not be null! Skipping.");
            Logger.error("Was trying to add: Meta: " + meta + ", Name: " + name + ", Color multiplier: " + colorMultiplier + ", Dust type: null");
            return;
        }
        IDust dust = this.getDust(meta);
        if (dust != null) {
            Logger.error("A dust with the meta '" + meta + "' is already registered! Skipping.");
            Logger.error("Was trying to add: Meta: " + meta + ", Name: " + name + ", Color multiplier: " + colorMultiplier + ", Dust type: " + dustType.getName());
            Logger.error("Found: Meta: " + dust.getMeta() + ", Name: " + dust.getName() + ", Color multiplier: " + dust.getColorMultiplier() + ", Dust type: " + (dust.getDustType() != null ? dust.getDustType().getName() : "null"));
            return;
        }
        dust = this.getDust(name);
        if (dust != null) {
            Logger.error("A dust with the name '" + name + "' is already registered! Skipping.");
            Logger.error("Was trying to add: Meta: " + meta + ", Name: " + name + ", Color multiplier: " + colorMultiplier + ", Dust type: " + dustType.getName());
            Logger.error("Found: Meta: " + dust.getMeta() + ", Name: " + dust.getName() + ", Color multiplier: " + dust.getColorMultiplier() + ", Dust type: " + (dust.getDustType() != null ? dust.getDustType().getName() : "null"));
            return;
        }
        dust = new Dust(meta, name, colorMultiplier, dustType);
        if (dustType.isValid(meta, name, dust.getDustStack())) {
            this.dusts[meta] = dust;
            Logger.info("Successfully added a dust: Meta: " + meta + ", Name: " + name + ", Color multiplier: " + colorMultiplier + ", Dust type: " + dustType.getName());
        } else {
            Logger.info("The dust with the name '" + name + "' will not be registered because it is invalid in this environment! Skipping.");
            Logger.info("Was trying to add: Meta: " + meta + ", Name: " + name + ", Color multiplier: " + colorMultiplier + ", Dust type: " + dustType.getName());
        }
    }

    @Override
    public void removeDust(int meta) {
        IDust dust = this.getDust(meta);
        if (dust == null) {
            Logger.error("Tried to remove an invalid dust! A dust with the meta '" + meta + "' could not be found! Skipping.");
            return;
        }
        if (meta >= 0 && meta < this.dusts.length) {
            this.dusts[meta] = null;
            Logger.info("Successfully removed dust: Meta: " + dust.getMeta() + ", Name: " + dust.getName() + ", Color multiplier: " + dust.getColorMultiplier() + ", Dust type: " + (dust.getDustType() != null ? dust.getDustType().getName() : "null"));
        }
    }

    @Override
    public void removeDust(String name) {
        IDust dust = this.getDust(name);
        if (dust == null) {
            Logger.error("Tried to remove an invalid dust! A dust with the name '" + name + "' could not be found! Skipping.");
            return;
        }
        if (!StringUtils.func_151246_b((String)name)) {
            for (int i = 0; i < this.dusts.length; ++i) {
                if (this.dusts[i] == null || !this.dusts[i].getName().equalsIgnoreCase(name)) continue;
                this.dusts[i] = null;
                Logger.info("Successfully removed dust: Meta: " + dust.getMeta() + ", Name: " + dust.getName() + ", Color multiplier: " + dust.getColorMultiplier() + ", Dust type: " + (dust.getDustType() != null ? dust.getDustType().getName() : "null"));
                return;
            }
        }
    }

    @Override
    public IDust getDust(int meta) {
        if (meta >= 0 && meta < this.dusts.length) {
            return this.dusts[meta];
        }
        return null;
    }

    @Override
    public IDust getDust(String name) {
        if (!StringUtils.func_151246_b((String)name)) {
            for (IDust dust : this.dusts) {
                if (dust == null || !dust.getName().equalsIgnoreCase(name)) continue;
                return dust;
            }
        }
        return null;
    }

    @Override
    public List<? extends IDust> getDusts() {
        return Collections.unmodifiableList(Arrays.asList(this.dusts));
    }
}

