/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.items.Tools;

import buildcraft.api.core.EnumColor;
import buildcraft.api.transport.IPipeTile;
import buildcraftAdditions.BuildcraftAdditions;
import buildcraftAdditions.config.ConfigurationHandler;
import buildcraftAdditions.items.ItemPoweredBase;
import buildcraftAdditions.reference.Variables;
import buildcraftAdditions.utils.Utils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemPipeColoringTool
extends ItemPoweredBase {
    public static final String[] names = new String[]{"white", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "light_gray", "cyan", "purple", "blue", "brown", "green", "red", "black"};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public ItemPipeColoringTool() {
        super("pipeColoringTool", ConfigurationHandler.capacityPipeColoringTool, ConfigurationHandler.maxTransferColoringTool);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            player.openGui((Object)BuildcraftAdditions.instance, Variables.Gui.PIPE_COLORING_TOOL.ordinal(), world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
        return stack;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (this.extractEnergy(stack, ConfigurationHandler.energyUseColoringTool, true) < ConfigurationHandler.energyUseColoringTool) {
            return false;
        }
        if (stack.field_77990_d != null && stack.field_77990_d.func_150297_b("SortMode", 1) && stack.field_77990_d.func_74767_n("SortMode")) {
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile instanceof IPipeTile && this.setColor(stack.func_77960_j(), (IPipeTile)tile)) {
                this.extractEnergy(stack, ConfigurationHandler.energyUseColoringTool, false);
                return true;
            }
        } else if (world.func_147439_a(x, y, z).recolourBlock(world, x, y, z, ForgeDirection.UNKNOWN, stack.func_77960_j())) {
            this.extractEnergy(stack, ConfigurationHandler.energyUseColoringTool, false);
            return true;
        }
        return false;
    }

    protected boolean setColor(int color, IPipeTile pipeTile) {
        try {
            Method setColor = pipeTile.getPipe().getClass().getMethod("setColor", EnumColor.class);
            setColor.invoke((Object)pipeTile.getPipe(), EnumColor.values()[15 - color]);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase entity) {
        EntitySheep sheep;
        if (this.extractEnergy(stack, ConfigurationHandler.energyUseColoringTool, true) < ConfigurationHandler.energyUseColoringTool) {
            return false;
        }
        if (stack.field_77990_d != null && stack.field_77990_d.func_150297_b("SortMode", 1) && !stack.field_77990_d.func_74767_n("SortMode") && entity instanceof EntitySheep && !(sheep = (EntitySheep)entity).func_70892_o() && sheep.func_70896_n() != stack.func_77960_j()) {
            player.func_71038_i();
            sheep.func_70891_b(stack.func_77960_j());
            this.extractEnergy(stack, ConfigurationHandler.energyUseColoringTool, false);
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advancedTooltips) {
        super.func_77624_a(stack, player, list, advancedTooltips);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("SortMode") && stack.func_77978_p().func_74767_n("SortMode")) {
            list.add(Utils.localize("tooltip.colorSortingMode"));
        } else {
            list.add(Utils.localize("tooltip.colorNormalMode"));
        }
        list.add(Utils.localize("" + EnumChatFormatting.func_96300_b((String)Utils.CHATCOLORS[stack.func_77960_j()]) + Utils.localize("gui.color." + Utils.COLOR_NAMES[stack.func_77960_j()])));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.icons = new IIcon[names.length];
        for (int i = 0; i < names.length; ++i) {
            this.icons[i] = register.func_94245_a("buildcraftcore:paintbrush/" + names[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        return this.icons[meta];
    }
}

