/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.items.Tools;

import buildcraftAdditions.BuildcraftAdditions;
import buildcraftAdditions.config.ConfigurationHandler;
import buildcraftAdditions.inventories.InventoryItem;
import buildcraftAdditions.inventories.InventoryKineticMultiTool;
import buildcraftAdditions.items.ItemInventoryPoweredBase;
import buildcraftAdditions.reference.ItemLoader;
import buildcraftAdditions.reference.Variables;
import buildcraftAdditions.utils.Utils;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import org.lwjgl.input.Keyboard;

public class ItemKineticMultiTool
extends ItemInventoryPoweredBase {
    private static final Set<Material> effectiveMaterialsDrill = Sets.newHashSet((Object[])new Material[]{Material.field_151576_e, Material.field_151573_f, Material.field_151588_w, Material.field_151592_s, Material.field_76233_E, Material.field_151574_g});
    private static final Set<Block> effectiveBlocksDrill = Sets.newHashSet((Object[])new Block[]{Blocks.field_150347_e, Blocks.field_150334_T, Blocks.field_150333_U, Blocks.field_150348_b, Blocks.field_150322_A, Blocks.field_150341_Y, Blocks.field_150366_p, Blocks.field_150339_S, Blocks.field_150365_q, Blocks.field_150340_R, Blocks.field_150352_o, Blocks.field_150482_ag, Blocks.field_150484_ah, Blocks.field_150432_aD, Blocks.field_150424_aL, Blocks.field_150369_x, Blocks.field_150368_y, Blocks.field_150450_ax, Blocks.field_150439_ay, Blocks.field_150448_aq, Blocks.field_150319_E, Blocks.field_150318_D, Blocks.field_150408_cc, Blocks.field_150467_bQ});
    private static final Set<Material> effectiveMaterialsDigger = Sets.newHashSet((Object[])new Material[]{Material.field_151577_b, Material.field_151578_c, Material.field_151595_p, Material.field_151597_y, Material.field_151596_z, Material.field_151571_B});
    private static final Set<Block> effectiveBlocksDigger = Sets.newHashSet((Object[])new Block[]{Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150354_m, Blocks.field_150351_n, Blocks.field_150431_aC, Blocks.field_150433_aE, Blocks.field_150435_aG, Blocks.field_150458_ak, Blocks.field_150425_aM, Blocks.field_150391_bh});
    private static final Set<Material> effectiveMaterialsChainsaw = Sets.newHashSet((Object[])new Material[]{Material.field_151589_v, Material.field_151584_j, Material.field_151585_k, Material.field_151575_d, Material.field_151582_l, Material.field_151569_G});
    private static final Set<Block> effectiveBlocksChainsaw = Sets.newHashSet((Object[])new Block[]{Blocks.field_150344_f, Blocks.field_150342_X, Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150486_ae, Blocks.field_150423_aK, Blocks.field_150428_aP});
    @SideOnly(value=Side.CLIENT)
    private IIcon iconChainsaw;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconDigger;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconDrill;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconHoe;

    public ItemKineticMultiTool() {
        super("kineticMultiTool", "kineticMultiTool");
        this.setNoRepair();
        this.func_77664_n();
    }

    public static Set<ItemStack> getInstalledUpgrades(ItemStack stack) {
        HashSet set = Sets.newHashSet();
        InventoryKineticMultiTool inv = new InventoryKineticMultiTool(stack);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack content = inv.func_70301_a(i);
            if (content == null) continue;
            set.add(content.func_77946_l());
        }
        if (ItemKineticMultiTool.isUpgradeInstalled(stack, "goldStick")) {
            set.add(new ItemStack((Item)ItemLoader.goldStick));
        }
        if (ItemKineticMultiTool.isUpgradeInstalled(stack, "diamondStick")) {
            set.add(new ItemStack((Item)ItemLoader.diamondStick));
        }
        if (ItemKineticMultiTool.isUpgradeInstalled(stack, "emeraldStick")) {
            set.add(new ItemStack((Item)ItemLoader.emeraldStick));
        }
        if (ItemKineticMultiTool.isUpgradeInstalled(stack, "netherStarStick")) {
            set.add(new ItemStack((Item)ItemLoader.netherStarStick));
        }
        if (ItemKineticMultiTool.isUpgradeInstalled(stack, "quartzStick")) {
            set.add(new ItemStack((Item)ItemLoader.quartzStick));
        }
        if (ItemKineticMultiTool.isUpgradeInstalled(stack, "enderStick")) {
            set.add(new ItemStack((Item)ItemLoader.enderStick));
        }
        if (ItemKineticMultiTool.isUpgradeInstalled(stack, "redstoneStick")) {
            set.add(new ItemStack((Item)ItemLoader.redstoneStick));
        }
        if (ItemKineticMultiTool.isUpgradeInstalled(stack, "glowstoneStick")) {
            set.add(new ItemStack((Item)ItemLoader.glowstoneStick));
        }
        if (ItemKineticMultiTool.isUpgradeInstalled(stack, "slimeStick")) {
            set.add(new ItemStack((Item)ItemLoader.slimeStick));
        }
        if (ItemKineticMultiTool.isUpgradeInstalled(stack, "blazeStick")) {
            set.add(new ItemStack((Item)ItemLoader.blazeStick));
        }
        if (ItemKineticMultiTool.isUpgradeInstalled(stack, "drill")) {
            set.add(new ItemStack((Item)ItemLoader.toolUpgradeDrill));
        }
        if (ItemKineticMultiTool.isUpgradeInstalled(stack, "digger")) {
            set.add(new ItemStack((Item)ItemLoader.toolUpgradeDigger));
        }
        if (ItemKineticMultiTool.isUpgradeInstalled(stack, "chainsaw")) {
            set.add(new ItemStack((Item)ItemLoader.toolUpgradeChainsaw));
        }
        if (ItemKineticMultiTool.isUpgradeInstalled(stack, "hoe")) {
            set.add(new ItemStack((Item)ItemLoader.toolUpgradeHoe));
        }
        if (ItemKineticMultiTool.isUpgradeInstalled(stack, "area")) {
            set.add(new ItemStack((Item)ItemLoader.toolUpgradeArea));
        }
        if (ItemKineticMultiTool.isUpgradeInstalled(stack, "silky")) {
            set.add(new ItemStack((Item)ItemLoader.toolUpgradeSilky));
        }
        if (ItemKineticMultiTool.isUpgradeInstalled(stack, "fortune1")) {
            set.add(new ItemStack((Item)ItemLoader.toolUpgradeFortune1));
        }
        if (ItemKineticMultiTool.isUpgradeInstalled(stack, "fortune2")) {
            set.add(new ItemStack((Item)ItemLoader.toolUpgradeFortune2));
        }
        if (ItemKineticMultiTool.isUpgradeInstalled(stack, "fortune3")) {
            set.add(new ItemStack((Item)ItemLoader.toolUpgradeFortune3));
        }
        return set;
    }

    public static void setLastUsedMode(ItemStack stack, String mode) {
        if (stack != null) {
            if (stack.field_77990_d == null) {
                stack.field_77990_d = new NBTTagCompound();
            }
            stack.field_77990_d.func_74778_a("lastUsedMode", mode);
        }
    }

    public static String getLastUsedMode(ItemStack stack) {
        if (stack != null && stack.field_77990_d != null && stack.field_77990_d.func_150297_b("lastUsedMode", 8)) {
            return stack.field_77990_d.func_74779_i("lastUsedMode");
        }
        return null;
    }

    public static void installStick(ItemStack stack, String stick) {
        if (stack != null && !ItemKineticMultiTool.isUpgradeInstalled(stack, stick)) {
            if (stack.field_77990_d == null) {
                stack.field_77990_d = new NBTTagCompound();
            }
            stack.field_77990_d.func_74757_a(stick, true);
            if (!stack.field_77990_d.func_150297_b("upgradesAllowed", 3)) {
                stack.field_77990_d.func_74768_a("upgradesAllowed", 1);
            }
            stack.field_77990_d.func_74768_a("upgradesAllowed", ItemKineticMultiTool.getAllowedUpgrades(stack) + 1);
        }
    }

    public static boolean isUpgradeInstalled(ItemStack stack, String upgrade) {
        return stack != null && stack.field_77990_d != null && stack.field_77990_d.func_150297_b(upgrade, 1) && stack.field_77990_d.func_74767_n(upgrade);
    }

    public static boolean canInstallUpgrade(ItemStack stack, String upgrade) {
        return !("area".equalsIgnoreCase(upgrade) && !ItemKineticMultiTool.isUpgradeInstalled(stack, "drill") && !ItemKineticMultiTool.isUpgradeInstalled(stack, "digger") && !ItemKineticMultiTool.isUpgradeInstalled(stack, "chainsaw") && !ItemKineticMultiTool.isUpgradeInstalled(stack, "hoe") || "silky".equalsIgnoreCase(upgrade) && (ItemKineticMultiTool.isUpgradeInstalled(stack, "fortune1") || ItemKineticMultiTool.isUpgradeInstalled(stack, "fortune2") || ItemKineticMultiTool.isUpgradeInstalled(stack, "fortune3") || !ItemKineticMultiTool.isUpgradeInstalled(stack, "drill") && !ItemKineticMultiTool.isUpgradeInstalled(stack, "digger") && !ItemKineticMultiTool.isUpgradeInstalled(stack, "chainsaw")) || "fortune1".equalsIgnoreCase(upgrade) && !ItemKineticMultiTool.isUpgradeInstalled(stack, "drill") && !ItemKineticMultiTool.isUpgradeInstalled(stack, "digger") && !ItemKineticMultiTool.isUpgradeInstalled(stack, "chainsaw") || "fortune2".equalsIgnoreCase(upgrade) && (ItemKineticMultiTool.isUpgradeInstalled(stack, "fortune1") || !ItemKineticMultiTool.isUpgradeInstalled(stack, "drill") && !ItemKineticMultiTool.isUpgradeInstalled(stack, "digger") && !ItemKineticMultiTool.isUpgradeInstalled(stack, "chainsaw")) || "fortune3".equalsIgnoreCase(upgrade) && (ItemKineticMultiTool.isUpgradeInstalled(stack, "fortune2") || !ItemKineticMultiTool.isUpgradeInstalled(stack, "drill") && !ItemKineticMultiTool.isUpgradeInstalled(stack, "digger") && !ItemKineticMultiTool.isUpgradeInstalled(stack, "chainsaw")) || ItemKineticMultiTool.getAllowedUpgrades(stack) <= 0);
    }

    public static void installUpgrade(ItemStack stack, String upgrade) {
        if (stack != null && upgrade != null && !upgrade.isEmpty() && !ItemKineticMultiTool.isUpgradeInstalled(stack, upgrade)) {
            if (stack.field_77990_d == null) {
                stack.field_77990_d = new NBTTagCompound();
            }
            stack.field_77990_d.func_74757_a(upgrade, true);
            if ("silky".equalsIgnoreCase(upgrade)) {
                Map map = EnchantmentHelper.func_82781_a((ItemStack)stack);
                if (map == null) {
                    map = Maps.newLinkedHashMap();
                }
                map.put(Enchantment.field_77348_q.field_77352_x, 1);
                EnchantmentHelper.func_82782_a((Map)map, (ItemStack)stack);
            } else if ("fortune1".equalsIgnoreCase(upgrade)) {
                Map map = EnchantmentHelper.func_82781_a((ItemStack)stack);
                if (map == null) {
                    map = Maps.newLinkedHashMap();
                }
                map.put(Enchantment.field_77346_s.field_77352_x, 1);
                EnchantmentHelper.func_82782_a((Map)map, (ItemStack)stack);
            } else if ("fortune2".equalsIgnoreCase(upgrade)) {
                Map map = EnchantmentHelper.func_82781_a((ItemStack)stack);
                if (map == null) {
                    map = Maps.newLinkedHashMap();
                }
                map.put(Enchantment.field_77346_s.field_77352_x, 2);
                EnchantmentHelper.func_82782_a((Map)map, (ItemStack)stack);
            } else if ("fortune3".equalsIgnoreCase(upgrade)) {
                Map map = EnchantmentHelper.func_82781_a((ItemStack)stack);
                if (map == null) {
                    map = Maps.newLinkedHashMap();
                }
                map.put(Enchantment.field_77346_s.field_77352_x, 3);
                EnchantmentHelper.func_82782_a((Map)map, (ItemStack)stack);
            }
            if (!stack.field_77990_d.func_150297_b("upgradesAllowed", 3)) {
                stack.field_77990_d.func_74768_a("upgradesAllowed", 1);
            }
            stack.field_77990_d.func_74768_a("upgradesAllowed", ItemKineticMultiTool.getAllowedUpgrades(stack) - 1);
        }
    }

    public static int getAllowedUpgrades(ItemStack stack) {
        if (stack != null && stack.field_77990_d != null && stack.field_77990_d.func_150297_b("upgradesAllowed", 3)) {
            return stack.field_77990_d.func_74762_e("upgradesAllowed");
        }
        return 1;
    }

    public static String getHarvestTool(String upgrade) {
        if (upgrade != null) {
            if (upgrade.equalsIgnoreCase("drill")) {
                return "pickaxe";
            }
            if (upgrade.equalsIgnoreCase("digger")) {
                return "shovel";
            }
            if (upgrade.equalsIgnoreCase("chainsaw")) {
                return "axe";
            }
        }
        return null;
    }

    public static String getUpgrade(String harvestTool) {
        if (harvestTool != null) {
            if (harvestTool.equalsIgnoreCase("pickaxe")) {
                return "drill";
            }
            if (harvestTool.equalsIgnoreCase("shovel")) {
                return "digger";
            }
            if (harvestTool.equalsIgnoreCase("axe")) {
                return "chainsaw";
            }
        }
        return null;
    }

    public static Set<Material> getEffectiveMaterials(ItemStack stack) {
        HashSet set = Sets.newHashSet();
        if (ItemKineticMultiTool.isUpgradeInstalled(stack, "drill")) {
            set.addAll(effectiveMaterialsDrill);
        }
        if (ItemKineticMultiTool.isUpgradeInstalled(stack, "digger")) {
            set.addAll(effectiveMaterialsDigger);
        }
        if (ItemKineticMultiTool.isUpgradeInstalled(stack, "chainsaw")) {
            set.addAll(effectiveMaterialsChainsaw);
        }
        return set;
    }

    public static Set<Block> getEffectiveBlocks(ItemStack stack) {
        HashSet set = Sets.newHashSet();
        if (ItemKineticMultiTool.isUpgradeInstalled(stack, "drill")) {
            set.addAll(effectiveBlocksDrill);
        }
        if (ItemKineticMultiTool.isUpgradeInstalled(stack, "digger")) {
            set.addAll(effectiveBlocksDigger);
        }
        if (ItemKineticMultiTool.isUpgradeInstalled(stack, "chainsaw")) {
            set.addAll(effectiveBlocksChainsaw);
        }
        return set;
    }

    public static float getEfficiency(ItemStack stack, Block block) {
        float f = 1.0f;
        if (ItemKineticMultiTool.isUpgradeInstalled(stack, "drill") && (effectiveMaterialsDrill.contains(block.func_149688_o()) || effectiveBlocksDrill.contains(block))) {
            ItemKineticMultiTool.setLastUsedMode(stack, "pickaxe");
            f = ConfigurationHandler.toolEfficiencyPickaxe;
        } else if (ItemKineticMultiTool.isUpgradeInstalled(stack, "chainsaw") && (effectiveMaterialsChainsaw.contains(block.func_149688_o()) || effectiveBlocksChainsaw.contains(block))) {
            ItemKineticMultiTool.setLastUsedMode(stack, "axe");
            f = ConfigurationHandler.toolEfficiencyAxe;
        } else if (ItemKineticMultiTool.isUpgradeInstalled(stack, "digger") && (effectiveMaterialsDigger.contains(block.func_149688_o()) || effectiveBlocksDigger.contains(block))) {
            ItemKineticMultiTool.setLastUsedMode(stack, "shovel");
            f = ConfigurationHandler.toolEfficiencyShovel;
        }
        return f * (ItemKineticMultiTool.isUpgradeInstalled(stack, "area") ? ConfigurationHandler.toolEfficiencyAreaMultiplier : 1.0f);
    }

    public static boolean isToolEffective(ItemStack stack, Block block, int meta) {
        return stack != null && stack.func_77973_b() != null && stack.func_77973_b().getHarvestLevel(stack, block.getHarvestTool(meta)) > block.getHarvestLevel(meta);
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K && player.func_70093_af()) {
            player.openGui((Object)BuildcraftAdditions.instance, Variables.Gui.KINETIC_MULTI_TOOL.ordinal(), world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
        return stack;
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        if ((float)this.getEnergyStored(stack) <= player.field_70170_p.func_147439_a(x, y, z).func_149712_f(player.field_70170_p, x, y, z) * (float)ConfigurationHandler.powerDifficultyModifiers[player.field_70170_p.field_73013_u.func_151525_a()] * (float)ConfigurationHandler.basePowerModifier) {
            if (!player.field_70170_p.field_72995_K) {
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("kineticTool.outOfPower", new Object[0]));
            }
            return true;
        }
        if (!player.func_70093_af() && ItemKineticMultiTool.isUpgradeInstalled(stack, "area")) {
            int range = 1;
            Block block = player.field_70170_p.func_147439_a(x, y, z);
            if (block.func_149712_f(player.field_70170_p, x, y, z) == 0.0f) {
                return false;
            }
            if (ItemKineticMultiTool.getEfficiency(stack, block) > 1.0f) {
                MovingObjectPosition mop = this.func_77621_a(player.field_70170_p, player, true);
                if (mop == null) {
                    return false;
                }
                switch (ForgeDirection.getOrientation((int)mop.field_72310_e)) {
                    case UP: 
                    case DOWN: {
                        for (int xx = x - range; xx <= x + range; ++xx) {
                            for (int zz = z - range; zz <= z + range; ++zz) {
                                if (xx == x && zz == z || !ItemKineticMultiTool.isToolEffective(stack, block = player.field_70170_p.func_147439_a(xx, y, zz), player.field_70170_p.func_72805_g(xx, y, zz)) || !(ItemKineticMultiTool.getEfficiency(stack, block) > 1.0f) || !this.func_150894_a(stack, player.field_70170_p, block, xx, y, zz, (EntityLivingBase)player) || !this.canHarvestBlock(block, player.func_71045_bC())) continue;
                                Utils.harvestBlock(player.field_70170_p, xx, y, zz, player);
                            }
                        }
                        break;
                    }
                    case NORTH: 
                    case SOUTH: {
                        for (int xx = x - range; xx <= x + range; ++xx) {
                            for (int yy = y - range; yy <= y + range; ++yy) {
                                if (xx == x && yy == y || !ItemKineticMultiTool.isToolEffective(stack, block = player.field_70170_p.func_147439_a(xx, yy, z), player.field_70170_p.func_72805_g(xx, yy, z)) || !(ItemKineticMultiTool.getEfficiency(stack, block) > 1.0f) || !this.func_150894_a(stack, player.field_70170_p, block, xx, yy, z, (EntityLivingBase)player) || !this.canHarvestBlock(block, player.func_71045_bC())) continue;
                                Utils.harvestBlock(player.field_70170_p, xx, yy, z, player);
                            }
                        }
                        break;
                    }
                    case WEST: 
                    case EAST: {
                        for (int yy = y - range; yy <= y + range; ++yy) {
                            for (int zz = z - range; zz <= z + range; ++zz) {
                                if (yy == y && zz == z || !ItemKineticMultiTool.isToolEffective(stack, block = player.field_70170_p.func_147439_a(x, yy, zz), player.field_70170_p.func_72805_g(x, yy, zz)) || !(ItemKineticMultiTool.getEfficiency(stack, block) > 1.0f) || !this.func_150894_a(stack, player.field_70170_p, block, x, yy, zz, (EntityLivingBase)player) || !this.canHarvestBlock(block, player.func_71045_bC())) continue;
                                Utils.harvestBlock(player.field_70170_p, x, yy, zz, player);
                            }
                        }
                        break;
                    }
                }
            }
        }
        return false;
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase entity) {
        if (ItemKineticMultiTool.getEffectiveMaterials(stack).contains(block.func_149688_o()) || ItemKineticMultiTool.getEffectiveBlocks(stack).contains(block)) {
            if (!(entity instanceof EntityPlayer) || !((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
                this.extractEnergy(stack, (int)(block.func_149712_f(world, x, y, z) * (float)ConfigurationHandler.powerDifficultyModifiers[world.field_73013_u.func_151525_a()] * (float)ConfigurationHandler.basePowerModifier), false);
            }
            return true;
        }
        return false;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase entityLivingBase1, EntityLivingBase entityLivingBase2) {
        if (ItemKineticMultiTool.isUpgradeInstalled(stack, "chainsaw")) {
            ItemKineticMultiTool.setLastUsedMode(stack, "axe");
            this.extractEnergy(stack, ConfigurationHandler.entityHitModifier * ConfigurationHandler.powerDifficultyModifiers[entityLivingBase1.field_70170_p.field_73013_u.func_151525_a()] * ConfigurationHandler.basePowerModifier, false);
            return true;
        }
        return false;
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack stack, int pass) {
        return false;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.common;
    }

    public float func_150893_a(ItemStack stack, Block block) {
        return ItemKineticMultiTool.getEfficiency(stack, block);
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        return ItemKineticMultiTool.isToolEffective(stack, block, meta) ? ItemKineticMultiTool.getEfficiency(stack, block) : super.getDigSpeed(stack, block, meta);
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        return this.func_150893_a(stack, block) > 1.0f;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!ItemKineticMultiTool.isUpgradeInstalled(stack, "hoe") || this.getEnergyStored(stack) < ConfigurationHandler.hoeCost) {
            return false;
        }
        boolean tilled = false;
        int range = ItemKineticMultiTool.isUpgradeInstalled(stack, "area") ? 1 : 0;
        for (int xx = x - range; xx <= x + range; ++xx) {
            for (int zz = z - range; zz <= z + range; ++zz) {
                if (!player.func_82247_a(xx, y, zz, side, stack)) continue;
                if (this.getEnergyStored(stack) < ConfigurationHandler.hoeCost) {
                    return tilled;
                }
                UseHoeEvent event = new UseHoeEvent(player, stack, world, xx, y, zz);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) continue;
                if (event.getResult() == Event.Result.ALLOW) {
                    this.extractEnergy(stack, ConfigurationHandler.hoeCost, false);
                    ItemKineticMultiTool.setLastUsedMode(stack, "hoe");
                    tilled = true;
                    continue;
                }
                Block block = world.func_147439_a(xx, y, zz);
                if (side == 0 || !world.func_147439_a(xx, y + 1, zz).isAir((IBlockAccess)world, xx, y + 1, zz) || block != Blocks.field_150349_c && block != Blocks.field_150346_d) continue;
                Block block1 = Blocks.field_150458_ak;
                world.func_72908_a((double)((float)xx + 0.5f), (double)((float)y + 0.5f), (double)((float)zz + 0.5f), block1.field_149762_H.func_150498_e(), (block1.field_149762_H.func_150497_c() + 1.0f) / 2.0f, block1.field_149762_H.func_150494_d() * 0.8f);
                if (!world.field_72995_K) {
                    world.func_147449_b(xx, y, zz, block1);
                }
                this.extractEnergy(stack, ConfigurationHandler.hoeCost, false);
                ItemKineticMultiTool.setLastUsedMode(stack, "hoe");
                tilled = true;
            }
        }
        return tilled;
    }

    public boolean func_82789_a(ItemStack stack1, ItemStack stack2) {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        HashMultimap map = HashMultimap.create();
        if (ItemKineticMultiTool.isUpgradeInstalled(stack, "chainsaw")) {
            map.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)ConfigurationHandler.entityDamage, 0));
        }
        return map;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        return ItemKineticMultiTool.isUpgradeInstalled(stack, ItemKineticMultiTool.getUpgrade(toolClass)) ? ConfigurationHandler.toolHarvestLevel : -1;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        HashSet set = Sets.newHashSet();
        if (ItemKineticMultiTool.isUpgradeInstalled(stack, "drill")) {
            set.add(ItemKineticMultiTool.getHarvestTool("drill"));
        }
        if (ItemKineticMultiTool.isUpgradeInstalled(stack, "digger")) {
            set.add(ItemKineticMultiTool.getHarvestTool("digger"));
        }
        if (ItemKineticMultiTool.isUpgradeInstalled(stack, "chainsaw")) {
            set.add(ItemKineticMultiTool.getHarvestTool("chainsaw"));
        }
        return set;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advancedTooltips) {
        super.func_77624_a(stack, player, list, advancedTooltips);
        if (Keyboard.isKeyDown((int)Minecraft.func_71410_x().field_71474_y.field_74311_E.func_151463_i())) {
            boolean drill = ItemKineticMultiTool.isUpgradeInstalled(stack, "drill");
            boolean digger = ItemKineticMultiTool.isUpgradeInstalled(stack, "digger");
            boolean chainsaw = ItemKineticMultiTool.isUpgradeInstalled(stack, "chainsaw");
            boolean hoe = ItemKineticMultiTool.isUpgradeInstalled(stack, "hoe");
            boolean area = ItemKineticMultiTool.isUpgradeInstalled(stack, "area");
            boolean silky = ItemKineticMultiTool.isUpgradeInstalled(stack, "silky");
            boolean fortune1 = ItemKineticMultiTool.isUpgradeInstalled(stack, "fortune1");
            boolean fortune2 = ItemKineticMultiTool.isUpgradeInstalled(stack, "fortune2");
            boolean fortune3 = ItemKineticMultiTool.isUpgradeInstalled(stack, "fortune3");
            list.add(Utils.localize("tooltip.installed"));
            if (!(drill || digger || chainsaw || hoe || area || silky || fortune1 || fortune2 || fortune3)) {
                list.add(Utils.localize("tooltip.none"));
            } else {
                if (drill) {
                    list.add(ItemLoader.toolUpgradeDrill.func_77653_i(new ItemStack((Item)ItemLoader.toolUpgradeDrill)));
                }
                if (digger) {
                    list.add(ItemLoader.toolUpgradeDigger.func_77653_i(new ItemStack((Item)ItemLoader.toolUpgradeDigger)));
                }
                if (chainsaw) {
                    list.add(ItemLoader.toolUpgradeChainsaw.func_77653_i(new ItemStack((Item)ItemLoader.toolUpgradeChainsaw)));
                }
                if (hoe) {
                    list.add(ItemLoader.toolUpgradeHoe.func_77653_i(new ItemStack((Item)ItemLoader.toolUpgradeHoe)));
                }
                if (area) {
                    list.add(ItemLoader.toolUpgradeArea.func_77653_i(new ItemStack((Item)ItemLoader.toolUpgradeArea)));
                }
                if (silky) {
                    list.add(ItemLoader.toolUpgradeSilky.func_77653_i(new ItemStack((Item)ItemLoader.toolUpgradeSilky)));
                } else if (fortune3) {
                    list.add(ItemLoader.toolUpgradeFortune3.func_77653_i(new ItemStack((Item)ItemLoader.toolUpgradeFortune3)));
                } else if (fortune2) {
                    list.add(ItemLoader.toolUpgradeFortune2.func_77653_i(new ItemStack((Item)ItemLoader.toolUpgradeFortune2)));
                } else if (fortune1) {
                    list.add(ItemLoader.toolUpgradeFortune1.func_77653_i(new ItemStack((Item)ItemLoader.toolUpgradeFortune1)));
                }
            }
            int upgradesAllowed = ItemKineticMultiTool.getAllowedUpgrades(stack);
            if (upgradesAllowed > 0) {
                list.add(Utils.localize("tooltip.upgradesPossible") + ": " + upgradesAllowed);
            }
        } else {
            list.add("<" + Utils.localize("tooltip.holdShiftForMoreInfo") + ">");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        String lastMode = ItemKineticMultiTool.getLastUsedMode(stack);
        if (lastMode != null) {
            if (lastMode.equalsIgnoreCase("pickaxe")) {
                return this.iconDrill;
            }
            if (lastMode.equalsIgnoreCase("axe")) {
                return this.iconChainsaw;
            }
            if (lastMode.equalsIgnoreCase("shovel")) {
                return this.iconDigger;
            }
            if (lastMode.equalsIgnoreCase("hoe")) {
                return this.iconHoe;
            }
        }
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        String lastMode = ItemKineticMultiTool.getLastUsedMode(stack);
        if (lastMode != null) {
            if (lastMode.equalsIgnoreCase("pickaxe")) {
                return this.iconDrill;
            }
            if (lastMode.equalsIgnoreCase("axe")) {
                return this.iconChainsaw;
            }
            if (lastMode.equalsIgnoreCase("shovel")) {
                return this.iconDigger;
            }
            if (lastMode.equalsIgnoreCase("hoe")) {
                return this.iconHoe;
            }
        }
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a("bcadditions:base_tool");
        this.iconChainsaw = register.func_94245_a("bcadditions:Chainsaw");
        this.iconDigger = register.func_94245_a("bcadditions:Digger");
        this.iconDrill = register.func_94245_a("bcadditions:Drill");
        this.iconHoe = register.func_94245_a("bcadditions:Hoe");
    }

    @Override
    public InventoryItem getInventory(ItemStack stack) {
        return new InventoryKineticMultiTool(stack);
    }
}

