/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.items;

import buildcraftAdditions.items.bases.ItemBase;
import buildcraftAdditions.utils.Utils;
import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemPoweredBase
extends ItemBase
implements IEnergyContainerItem {
    protected int capacity;
    protected int maxReceive;
    protected int maxExtract;

    public ItemPoweredBase(String name, String gameRegistryName) {
        super(name, name, gameRegistryName);
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    public ItemPoweredBase(String name, String gameregistryName, int capacity) {
        this(name, gameregistryName, capacity, capacity, capacity);
    }

    public ItemPoweredBase(String name, int capacity, int maxTransfer) {
        this(name, name, capacity, maxTransfer, maxTransfer);
    }

    public ItemPoweredBase(String name, String gameRegistryName, int capacity, int maxReceive, int maxExtract) {
        this(name, gameRegistryName);
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
    }

    public int getMaxReceive() {
        return this.maxReceive;
    }

    public int getMaxExtract() {
        return this.maxExtract;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getMaxEnergyStored(stack) > 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        double maxEnergy = this.getMaxEnergyStored(stack);
        if (maxEnergy <= 0.0) {
            return 1.0;
        }
        return (maxEnergy - (double)this.getEnergyStored(stack)) / maxEnergy;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advancedTooltips) {
        list.add(Utils.getRFInfoTooltip(this.getEnergyStored(stack), this.getMaxEnergyStored(stack)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        list.add(new ItemStack(item));
        ItemStack filled = new ItemStack(item);
        filled.field_77990_d = new NBTTagCompound();
        filled.field_77990_d.func_74768_a("energy", this.getMaxEnergyStored(filled));
        list.add(filled);
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        int energy = container.field_77990_d.func_74762_e("energy");
        int energyReceived = Math.min(this.getMaxEnergyStored(container) - energy, Math.min(this.getMaxReceive(), maxReceive));
        if (!simulate) {
            container.field_77990_d.func_74768_a("energy", energy += energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.field_77990_d == null || !container.field_77990_d.func_150297_b("energy", 3)) {
            return 0;
        }
        int energy = container.field_77990_d.func_74762_e("energy");
        int energyExtracted = Math.min(energy, Math.min(this.getMaxExtract(), maxExtract));
        if (!simulate) {
            container.field_77990_d.func_74768_a("energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        if (container.field_77990_d == null || !container.field_77990_d.func_150297_b("energy", 3)) {
            return 0;
        }
        return container.field_77990_d.func_74762_e("energy");
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return this.capacity;
    }
}

