/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.items;

import buildcraftAdditions.inventories.InventoryItem;
import buildcraftAdditions.items.ItemPoweredBase;
import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public abstract class ItemInventoryPoweredBase
extends ItemPoweredBase {
    public ItemInventoryPoweredBase(String name) {
        this(name, name);
    }

    public ItemInventoryPoweredBase(String name, String gameregistryName) {
        super(name, gameregistryName);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        list.add(new ItemStack(item));
    }

    public abstract InventoryItem getInventory(ItemStack var1);

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        InventoryItem inv = this.getInventory(container);
        int received = 0;
        if (inv != null) {
            for (int i = 0; i < inv.func_70302_i_() && maxReceive - received > 0; ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack == null || stack.func_77973_b() == null || !(stack.func_77973_b() instanceof IEnergyContainerItem)) continue;
                IEnergyContainerItem item = (IEnergyContainerItem)stack.func_77973_b();
                received += item.receiveEnergy(stack, maxReceive - received, simulate);
            }
            inv.func_70305_f();
        }
        return received;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        InventoryItem inv = this.getInventory(container);
        int extracted = 0;
        if (inv != null) {
            for (int i = 0; i < inv.func_70302_i_() && maxExtract - extracted > 0; ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack == null || stack.func_77973_b() == null || !(stack.func_77973_b() instanceof IEnergyContainerItem)) continue;
                IEnergyContainerItem item = (IEnergyContainerItem)stack.func_77973_b();
                extracted += item.extractEnergy(stack, maxExtract - extracted, simulate);
            }
            inv.func_70305_f();
        }
        return extracted;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        InventoryItem inv = this.getInventory(container);
        int stored = 0;
        if (inv != null) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack == null || stack.func_77973_b() == null || !(stack.func_77973_b() instanceof IEnergyContainerItem)) continue;
                IEnergyContainerItem item = (IEnergyContainerItem)stack.func_77973_b();
                stored += item.getEnergyStored(stack);
            }
        }
        return stored;
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        InventoryItem inv = this.getInventory(container);
        int maxStored = 0;
        if (inv != null) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack == null || stack.func_77973_b() == null || !(stack.func_77973_b() instanceof IEnergyContainerItem)) continue;
                IEnergyContainerItem item = (IEnergyContainerItem)stack.func_77973_b();
                maxStored += item.getMaxEnergyStored(stack);
            }
        }
        return maxStored;
    }
}

