/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.items;

import buildcraftAdditions.BuildcraftAdditions;
import buildcraftAdditions.utils.RenderUtils;
import buildcraftAdditions.utils.Utils;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.ItemFluidContainer;

public class ItemCanister
extends ItemFluidContainer {
    @SideOnly(value=Side.CLIENT)
    private IIcon overlay;

    public ItemCanister(String name, int canisterCapacity) {
        super(0);
        this.func_77625_d(1);
        this.func_77637_a(BuildcraftAdditions.bcaCannisters);
        this.func_77655_b(name);
        this.setCapacity(canisterCapacity);
        this.func_111206_d("bcadditions:" + name);
        GameRegistry.registerItem((Item)this, (String)name);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean visible) {
        FluidStack fStack = Utils.getFluidStackFromItemStack(itemStack);
        if (fStack == null) {
            list.add(String.format(Utils.localize("tooltip.FluidCapacity"), this.capacity / 1000));
        } else {
            list.add(String.format(Utils.localize("tooltip.storedFluid"), fStack.getFluid().getLocalizedName(fStack), fStack.amount));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        super.func_94581_a(register);
        this.overlay = RenderUtils.registerIcon(register, "fluidOverlay");
    }

    public ItemStack getFilledItemStack(FluidStack fluidStack) {
        ItemStack itemStack = new ItemStack((Item)this);
        itemStack.field_77990_d = new NBTTagCompound();
        NBTTagCompound fluidTag = fluidStack.writeToNBT(new NBTTagCompound());
        if (fluidStack.amount > this.capacity) {
            fluidTag.func_74768_a("Amount", this.capacity);
        }
        itemStack.func_77978_p().func_74782_a("Fluid", (NBTBase)fluidTag);
        return itemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        super.func_150895_a(item, tab, list);
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            if (fluid == null) continue;
            list.add(this.getFilledItemStack(new FluidStack(fluid, this.capacity)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getOverlay() {
        return this.overlay;
    }
}

