/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.inventories.containers;

import buildcraftAdditions.client.gui.GuiBase;
import buildcraftAdditions.inventories.slots.SlotPhantom;
import buildcraftAdditions.tileEntities.Bases.TileBase;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerBase<T>
extends Container {
    protected final InventoryPlayer inventoryPlayer;
    protected final EntityPlayerMP player;
    protected final T inventory;
    private boolean canShift = true;

    public ContainerBase(EntityPlayer player, T inventory) {
        if (player != null) {
            this.inventoryPlayer = player.field_71071_by;
            this.player = player instanceof EntityPlayerMP ? (EntityPlayerMP)player : null;
        } else {
            this.inventoryPlayer = null;
            this.player = null;
        }
        this.inventory = inventory;
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.player == null) {
            return;
        }
        if (this.inventory instanceof TileBase) {
            ((TileBase)this.inventory).syncToPlayer(this.player);
        }
    }

    private static boolean canStacksMerge(ItemStack stack1, ItemStack stack2) {
        return stack1 != null && stack2 != null && stack1.func_77969_a(stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public ContainerBase setCanShift(boolean canShift) {
        this.canShift = canShift;
        return this;
    }

    protected void addPlayerInventory(int x, int y) {
        if (this.inventoryPlayer != null) {
            for (int inventoryRowIndex = 0; inventoryRowIndex < 3; ++inventoryRowIndex) {
                for (int inventoryColumnIndex = 0; inventoryColumnIndex < 9; ++inventoryColumnIndex) {
                    this.func_75146_a(new Slot((IInventory)this.inventoryPlayer, 9 + inventoryColumnIndex + inventoryRowIndex * 9, x + inventoryColumnIndex * 18, y + inventoryRowIndex * 18));
                }
            }
            for (int hotBarIndex = 0; hotBarIndex < 9; ++hotBarIndex) {
                this.func_75146_a(new Slot((IInventory)this.inventoryPlayer, hotBarIndex, 8 + hotBarIndex * 18, y + 58));
            }
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        if (this.field_75151_b.isEmpty()) {
            return null;
        }
        int numSlots = this.field_75151_b.size();
        if (slotIndex < 0 || slotIndex >= numSlots) {
            return null;
        }
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        ItemStack originalStack = null;
        if (slot != null && slot.func_75216_d()) {
            ItemStack stackInSlot = slot.func_75211_c();
            originalStack = stackInSlot.func_77946_l();
            if ((slotIndex < numSlots - 36 || !this.tryShiftItem(stackInSlot, numSlots)) && (slotIndex >= numSlots - 36 && slotIndex < numSlots - 9 ? !this.shiftItemStack(stackInSlot, numSlots - 9, numSlots) : (slotIndex >= numSlots - 9 && slotIndex < numSlots ? !this.shiftItemStack(stackInSlot, numSlots - 36, numSlots - 9) : !this.shiftItemStack(stackInSlot, numSlots - 36, numSlots)))) {
                return null;
            }
            slot.func_75220_a(stackInSlot, originalStack);
            if (stackInSlot.field_77994_a <= 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (stackInSlot.field_77994_a == originalStack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(player, stackInSlot);
        }
        return originalStack;
    }

    private boolean tryShiftItem(ItemStack stackToShift, int numSlots) {
        for (int machineIndex = 0; machineIndex < numSlots - 36; ++machineIndex) {
            Slot slot = (Slot)this.field_75151_b.get(machineIndex);
            if (!slot.func_75214_a(stackToShift) || !this.shiftItemStack(stackToShift, machineIndex, machineIndex + 1)) continue;
            return true;
        }
        return false;
    }

    private boolean shiftItemStack(ItemStack stackToShift, int start, int end) {
        ItemStack stackInSlot;
        Slot slot;
        int slotIndex;
        if (!this.canShift) {
            return false;
        }
        boolean changed = false;
        if (stackToShift.func_77985_e()) {
            for (slotIndex = start; stackToShift.field_77994_a > 0 && slotIndex < end; ++slotIndex) {
                slot = (Slot)this.field_75151_b.get(slotIndex);
                stackInSlot = slot.func_75211_c();
                if (stackInSlot == null || !ContainerBase.canStacksMerge(stackInSlot, stackToShift)) continue;
                int resultingStackSize = stackInSlot.field_77994_a + stackToShift.field_77994_a;
                int max = Math.min(stackToShift.func_77976_d(), slot.func_75219_a());
                if (resultingStackSize <= max) {
                    stackToShift.field_77994_a = 0;
                    stackInSlot.field_77994_a = resultingStackSize;
                    slot.func_75218_e();
                    changed = true;
                    continue;
                }
                if (stackInSlot.field_77994_a >= max) continue;
                stackToShift.field_77994_a -= max - stackInSlot.field_77994_a;
                stackInSlot.field_77994_a = max;
                slot.func_75218_e();
                changed = true;
            }
        }
        if (stackToShift.field_77994_a > 0) {
            for (slotIndex = start; stackToShift.field_77994_a > 0 && slotIndex < end; ++slotIndex) {
                slot = (Slot)this.field_75151_b.get(slotIndex);
                stackInSlot = slot.func_75211_c();
                if (stackInSlot != null) continue;
                int max = Math.min(stackToShift.func_77976_d(), slot.func_75219_a());
                stackInSlot = stackToShift.func_77946_l();
                stackInSlot.field_77994_a = Math.min(stackToShift.field_77994_a, max);
                stackToShift.field_77994_a -= stackInSlot.field_77994_a;
                slot.func_75215_d(stackInSlot);
                slot.func_75218_e();
                changed = true;
            }
        }
        return changed;
    }

    public boolean func_75145_c(EntityPlayer player) {
        return !(this.inventory instanceof IInventory) || ((IInventory)this.inventory).func_70300_a(player);
    }

    public ItemStack func_75144_a(int slotNum, int mouseButton, int modifier, EntityPlayer player) {
        if (slotNum < 0 || slotNum >= this.field_75151_b.size()) {
            return null;
        }
        Slot slot = (Slot)this.field_75151_b.get(slotNum);
        if (slot instanceof SlotPhantom) {
            return ((SlotPhantom)slot).onClick(mouseButton, player);
        }
        return super.func_75144_a(slotNum, mouseButton, modifier, player);
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (player.field_70170_p != null && !player.field_70170_p.field_72995_K && this.inventory instanceof IInventory) {
            ((IInventory)this.inventory).func_70305_f();
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void redrawOpenGui() {
        GuiScreen gui = FMLClientHandler.instance().getClient().field_71462_r;
        if (gui instanceof GuiBase) {
            ((GuiBase)gui).redraw();
        }
    }
}

