/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.inventories;

import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InventoryItem
extends InventoryBasic {
    protected final ItemStack stack;

    public InventoryItem(ItemStack stack, String name, int size) {
        super(stack.func_82837_s() ? stack.func_82833_r() : name, stack.func_82837_s(), size);
        this.stack = stack;
        this.func_70295_k_();
    }

    public InventoryItem(ItemStack stack) {
        super("", true, 0);
        this.stack = stack;
        this.func_70295_k_();
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.writeToNBT();
    }

    public void func_70295_k_() {
        this.readFromNBT();
    }

    public void func_70305_f() {
        this.writeToNBT();
    }

    public void readFromNBT() {
        NBTTagList itemList;
        NBTTagCompound inventoryTag;
        if (this.stack != null && this.stack.field_77990_d != null && this.stack.field_77990_d.func_150297_b("Inventory", 10) && (inventoryTag = this.stack.field_77990_d.func_74775_l("Inventory")) != null && inventoryTag.func_150297_b("Items", 9) && (itemList = inventoryTag.func_150295_c("Items", 10)) != null) {
            for (int i = 0; i < itemList.func_74745_c(); ++i) {
                int slot;
                NBTTagCompound slotTag = itemList.func_150305_b(i);
                if (!slotTag.func_150297_b("Slot", 1) || (slot = slotTag.func_74771_c("Slot") & 0xFF) < 0 || slot >= this.func_70302_i_()) continue;
                this.func_70299_a(slot, ItemStack.func_77949_a((NBTTagCompound)slotTag));
            }
        }
    }

    public void writeToNBT() {
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null || stack.field_77994_a <= 0) continue;
            NBTTagCompound slotTag = new NBTTagCompound();
            slotTag.func_74774_a("Slot", (byte)(i & 0xFF));
            stack.func_77955_b(slotTag);
            itemList.func_74742_a((NBTBase)slotTag);
        }
        NBTTagCompound inventoryTag = new NBTTagCompound();
        inventoryTag.func_74782_a("Items", (NBTBase)itemList);
        if (this.stack != null) {
            if (this.stack.field_77990_d == null) {
                this.stack.field_77990_d = new NBTTagCompound();
            }
            this.stack.field_77990_d.func_74782_a("Inventory", (NBTBase)inventoryTag);
        }
    }

    public ItemStack getStack() {
        return this.stack;
    }
}

