/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.inventories;

import buildcraftAdditions.api.nbt.INBTSaveable;
import buildcraftAdditions.api.networking.ISyncObject;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class CustomInventory
implements IInventory,
ISyncObject,
INBTSaveable {
    private final ItemStack[] itemStacks;
    private final String name;
    private final int stackLimit;
    private final TileEntity entity;

    public CustomInventory(String name, int slots, int stackLimit, TileEntity entity) {
        this.name = name;
        this.stackLimit = stackLimit;
        this.itemStacks = new ItemStack[slots];
        this.entity = entity;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        NBTTagList nbttaglist = tag.func_150295_c("ItemStacks", 10);
        for (int t = 0; t < nbttaglist.func_74745_c(); ++t) {
            NBTTagCompound slot = nbttaglist.func_150305_b(t);
            int index = slot.func_74764_b("index") ? slot.func_74762_e("index") : (int)slot.func_74771_c("Slot");
            if (index < 0 || index >= this.itemStacks.length) continue;
            this.func_70299_a(index, ItemStack.func_77949_a((NBTTagCompound)slot));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList list = new NBTTagList();
        for (byte t = 0; t < this.itemStacks.length; t = (byte)((byte)(t + 1))) {
            if (this.itemStacks[t] == null || this.itemStacks[t].field_77994_a <= 0) continue;
            NBTTagCompound slot = new NBTTagCompound();
            list.func_74742_a((NBTBase)slot);
            slot.func_74774_a("Slot", t);
            this.itemStacks[t].func_77955_b(slot);
        }
        tag.func_74782_a("ItemStacks", (NBTBase)list);
    }

    @Override
    public void writeToByteBuff(ByteBuf buf) {
        for (ItemStack stack : this.itemStacks) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)stack);
        }
    }

    @Override
    public void readFromByteBuff(ByteBuf buf) {
        for (int i = 0; i < this.itemStacks.length; ++i) {
            this.itemStacks[i] = ByteBufUtils.readItemStack((ByteBuf)buf);
        }
    }

    public int func_70302_i_() {
        return this.itemStacks.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.itemStacks[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (slot < this.itemStacks.length && this.itemStacks[slot] != null) {
            if (this.itemStacks[slot].field_77994_a > amount) {
                return this.itemStacks[slot].func_77979_a(amount);
            }
            ItemStack stack = this.itemStacks[slot];
            this.func_70299_a(slot, null);
            return stack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.itemStacks[slot] == null) {
            return null;
        }
        ItemStack stack = this.itemStacks[slot];
        this.func_70299_a(slot, null);
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.itemStacks[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return this.name;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return this.stackLimit;
    }

    public void func_70296_d() {
        this.entity.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }
}

