/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.entities;

import buildcraft.api.power.ILaserTarget;
import buildcraft.api.power.ILaserTargetBlock;
import buildcraftAdditions.config.ConfigurationHandler;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.common.registry.IThrowableEntity;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;

public class EntityLaserShot
extends EntityThrowable
implements IEntityAdditionalSpawnData,
IThrowableEntity {
    private float strength;
    private EntityLivingBase thrower;

    public EntityLaserShot(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityLaserShot(World world, EntityPlayer player, float strength) {
        super(world, (EntityLivingBase)player);
        this.strength = strength;
        this.func_70105_a(0.5f, 0.5f);
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, this.func_70182_d(), 1.0f);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70170_p.func_72869_a("smoke", this.field_70165_t + this.field_70146_Z.nextDouble() / 4.0 - 0.125, this.field_70163_u + this.field_70146_Z.nextDouble() / 4.0 - 0.125, this.field_70161_v + this.field_70146_Z.nextDouble() / 4.0 - 0.125, 0.0, 0.0, 0.0);
        this.field_70170_p.func_72869_a("flame", this.field_70165_t + this.field_70146_Z.nextDouble() / 4.0 - 0.125, this.field_70163_u + this.field_70146_Z.nextDouble() / 4.0 - 0.125, this.field_70161_v + this.field_70146_Z.nextDouble() / 4.0 - 0.125, 0.0, 0.0, 0.0);
        if (this.field_70173_aa > 6000) {
            this.func_70106_y();
        }
        if (this.func_70090_H() || this.func_70058_J()) {
            int z;
            int y;
            this.field_70170_p.func_72908_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, "random.fizz", 0.5f, 2.6f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.8f);
            for (int i = 0; i < 8; ++i) {
                this.field_70170_p.func_72869_a("largesmoke", this.field_70165_t + Math.random(), this.field_70163_u + 1.2, this.field_70161_v + Math.random(), 0.0, 0.0, 0.0);
            }
            int x = MathHelper.func_76128_c((double)this.field_70165_t);
            Block block = this.field_70170_p.func_147439_a(x, y = MathHelper.func_76128_c((double)this.field_70163_u), z = MathHelper.func_76128_c((double)this.field_70161_v));
            if (block instanceof BlockLiquid || block instanceof IFluidBlock) {
                this.field_70170_p.func_147468_f(x, y, z);
            }
            this.func_70106_y();
        }
    }

    protected void func_70184_a(MovingObjectPosition mop) {
        if (mop == null) {
            return;
        }
        boolean hit = false;
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && mop.field_72308_g != null && mop.field_72308_g != this && mop.field_72308_g != this.thrower && mop.field_72308_g != super.func_85052_h()) {
            hit = true;
            if (ConfigurationHandler.portableLaserEntityBurnTime > 0) {
                mop.field_72308_g.func_70015_d((int)(this.strength * (float)ConfigurationHandler.portableLaserEntityBurnTime));
            }
            if (ConfigurationHandler.portableLaserEntityDamage > 0.0f) {
                mop.field_72308_g.func_70097_a(new EntityDamageSourceIndirect("bcaLaser", (Entity)this, (Entity)(this.thrower != null ? this.thrower : super.func_85052_h())).func_76361_j().func_76348_h().func_76349_b(), (float)((int)(this.strength * ConfigurationHandler.portableLaserEntityDamage)));
            }
        } else if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            ILaserTarget target;
            TileEntity tile;
            hit = true;
            if (this.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d) instanceof ILaserTargetBlock && (tile = this.field_70170_p.func_147438_o(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d)) != null && tile instanceof ILaserTarget && !(target = (ILaserTarget)tile).isInvalidTarget() && target.requiresLaserEnergy()) {
                target.receiveLaserEnergy((int)(this.strength * (float)ConfigurationHandler.portableLaserLaserPower));
            }
        }
        if (hit) {
            for (int i = 0; i < 32; ++i) {
                this.field_70170_p.func_72869_a("smoke", this.field_70165_t + this.field_70146_Z.nextDouble() / 4.0 - 0.125, this.field_70163_u + this.field_70146_Z.nextDouble() / 4.0 - 0.125, this.field_70161_v + this.field_70146_Z.nextDouble() / 4.0 - 0.125, 0.0, 0.0, 0.0);
                this.field_70170_p.func_72869_a("flame", this.field_70165_t + this.field_70146_Z.nextDouble() / 4.0 - 0.125, this.field_70163_u + this.field_70146_Z.nextDouble() / 4.0 - 0.125, this.field_70161_v + this.field_70146_Z.nextDouble() / 4.0 - 0.125, 0.0, 0.0, 0.0);
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74776_a("strength", this.strength);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.strength = nbt.func_74760_g("strength");
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeFloat(this.strength);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.strength = additionalData.readFloat();
    }

    public EntityLivingBase func_85052_h() {
        return this.thrower;
    }

    public void setThrower(Entity entity) {
        if (entity == null) {
            this.thrower = null;
        } else if (entity instanceof EntityLivingBase) {
            this.thrower = (EntityLivingBase)entity;
        }
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    protected float func_70182_d() {
        return this.strength * 2.0f + 1.0f;
    }

    public float getStrength() {
        return this.strength;
    }

    public float func_70013_c(float partialTicks) {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float partialTicks) {
        return 0xF000F0;
    }
}

