/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.config;

import buildcraftAdditions.core.VersionCheck;
import java.io.File;
import java.util.HashSet;
import net.minecraftforge.common.config.Configuration;

public class ConfigurationHandler {
    public static final int[] powerDifficultyModifiers = new int[4];
    private static final HashSet<String> enabledFeatures = new HashSet();
    public static Configuration configFile;
    public static boolean shouldPrintChangelog;
    public static boolean shouldRegisterDusts;
    public static boolean powerloss;
    public static boolean eurekaIntegration;
    public static boolean dusterParticles;
    public static boolean forceEnableBCRefinery;
    public static boolean powerpipesInPowerPlant;
    public static boolean slimesUsingDusters;
    public static int basePowerModifier;
    public static int entityHitModifier;
    public static int hoeCost;
    public static int toolHarvestLevel;
    public static int KEB1powerloss;
    public static int KEB2powerloss;
    public static int KEB3powerloss;
    public static int heatedFurnaceHeatRequired;
    public static int basicCoilHeat;
    public static int lavaCoilHeat;
    public static int kineticCoilHeatModifier;
    public static int portableLaserPowerUse;
    public static int portableLaserLaserPower;
    public static int portableLaserEntityBurnTime;
    public static int capacityPipeColoringTool;
    public static int maxTransferColoringTool;
    public static int energyUseColoringTool;
    public static int capacityPowerCapsuleTier1;
    public static int maxTransferPowerCapsuleTier1;
    public static int capacityPowerCapsuleTier2;
    public static int maxTransferPowerCapsuleTier2;
    public static int capacityPowerCapsuleTier3;
    public static int maxTransferPowerCapsuleTier3;
    public static int capacityKEBTier1;
    public static int maxTransferKEBTier1;
    public static int capacityKEBTier2;
    public static int maxTransferKEBTier2;
    public static int capacityKEBTier3;
    public static int maxTransferKEBTier3;
    public static int capacityChargingStation;
    public static int maxTransferChargingStation;
    public static int capacityFluidicCompressor;
    public static int maxTransferFluidicCompressor;
    public static int capacityMechanicalDuster;
    public static int maxTransferMechanicalDuster;
    public static int energyUseMechanicalDuster;
    public static int capacityRefinery;
    public static int maxTransferRefinery;
    public static int energyUseRefineryMultiplier;
    public static int refineryAutoExportMaxTransfer;
    public static int refineryAutoImportMaxTransfer;
    public static int refinerySpeed1SpeedModifier;
    public static int refinerySpeed2SpeedModifier;
    public static int refinerySpeed3SpeedModifier;
    public static int coolingTowerAutoExportMaxTransfer;
    public static int coolingTowerAutoImportMaxTransfer;
    public static int coolingTowerSpeed1SpeedModifier;
    public static int coolingTowerSpeed2SpeedModifier;
    public static int coolingTowerSpeed3SpeedModifier;
    public static int particleCount;
    public static float portableLaserEntityDamage;
    public static float toolEfficiencyPickaxe;
    public static float toolEfficiencyShovel;
    public static float toolEfficiencyAxe;
    public static float toolEfficiencyAreaMultiplier;
    public static float entityDamage;
    public static float coolingTowerEfficiency1CoolingModifier;
    public static float coolingTowerEfficiency2CoolingModifier;
    public static float coolingTowerEfficiency3CoolingModifier;
    public static double refineryEfficiency1EnergyCostModifier;
    public static double refineryEfficiency2EnergyCostModifier;
    public static double refineryEfficiency3EnergyCostModifier;
    public static double refinerySpeed1EnergyCostModifier;
    public static double refinerySpeed2EnergyCostModifier;
    public static double refinerySpeed3EnergyCostModifier;

    public static void init(File file) {
        configFile = new Configuration(file);
        ConfigurationHandler.readConfig();
    }

    public static boolean enabled(String name) {
        return enabledFeatures.contains(name);
    }

    private static void registerFeature(String name) {
        if (configFile.get("Feature", name, true).setRequiresMcRestart(true).getBoolean()) {
            enabledFeatures.add(name);
        }
    }

    public static void readConfig() {
        ConfigurationHandler.registerFeature("ChargingStation");
        ConfigurationHandler.registerFeature("ColorSorter");
        ConfigurationHandler.registerFeature("ColoringTool");
        ConfigurationHandler.registerFeature("Duster");
        ConfigurationHandler.registerFeature("Coils");
        ConfigurationHandler.registerFeature("HeatedFurnace");
        ConfigurationHandler.registerFeature("FluidCanisters");
        ConfigurationHandler.registerFeature("KineticBackpack");
        ConfigurationHandler.registerFeature("KineticEnergyBuffer");
        ConfigurationHandler.registerFeature("MachineUpgrades");
        ConfigurationHandler.registerFeature("MultiBlockRefining");
        ConfigurationHandler.registerFeature("MultiTools");
        ConfigurationHandler.registerFeature("MultiToolsArea");
        ConfigurationHandler.registerFeature("MultiToolsFortune");
        ConfigurationHandler.registerFeature("MultiToolsSilky");
        ConfigurationHandler.registerFeature("PortableLaser");
        ConfigurationHandler.registerFeature("PowerCapsules");
        configFile.addCustomCategoryComment("Updates", "Section about updates");
        if (configFile.get("Updates", "shouldCheckForUpdates", true).getBoolean()) {
            VersionCheck.start();
        }
        shouldPrintChangelog = configFile.get("Updates", "shouldPrintOutChangelog", false).getBoolean();
        configFile.addCustomCategoryComment("Power Usage", "Configuration stuff for your Kinetic Multi-Tool");
        ConfigurationHandler.powerDifficultyModifiers[0] = configFile.get("Power Usage", "PeacefulDifficultyModifier", 1).setMinValue(0).getInt();
        ConfigurationHandler.powerDifficultyModifiers[1] = configFile.get("Power Usage", "EasyDifficultyModifier", 2).setMinValue(0).getInt();
        ConfigurationHandler.powerDifficultyModifiers[2] = configFile.get("Power Usage", "NormalDifficultyModifier", 3).setMinValue(0).getInt();
        ConfigurationHandler.powerDifficultyModifiers[3] = configFile.get("Power Usage", "HardDifficultyModifier", 4).setMinValue(0).getInt();
        basePowerModifier = configFile.get("Power Usage", "BaseModifier", 10).setMinValue(0).getInt();
        entityHitModifier = configFile.get("Power Usage", "EntityHitModifier", 10).setMinValue(0).getInt();
        entityDamage = (float)configFile.get("Power Usage", "EntityDamage", 7.0).setMinValue(0).setMaxValue(3.4028234663852886E38).getDouble();
        hoeCost = configFile.get("Power Usage", "HoeCost", 5).setMinValue(0).getInt();
        toolEfficiencyPickaxe = (float)configFile.get("Power Usage", "ToolEfficiencyPickaxe", 40.0).setMinValue(1.1).setMaxValue(3.4028234663852886E38).getDouble();
        toolEfficiencyShovel = (float)configFile.get("Power Usage", "ToolEfficiencyShovel", 10.0).setMinValue(1.1).setMaxValue(3.4028234663852886E38).getDouble();
        toolEfficiencyAxe = (float)configFile.get("Power Usage", "ToolEfficiencyAxe", 30.0).setMinValue(1.1).setMaxValue(3.4028234663852886E38).getDouble();
        toolHarvestLevel = configFile.get("Power Usage", "ToolHarvestLevel", Integer.MAX_VALUE).setMinValue(0).getInt();
        toolEfficiencyAreaMultiplier = (float)configFile.get("Power Usage", "ToolEfficiencyAreaMultiplier", 0.25).setMinValue(0).setMaxValue(3.4028234663852886E38).getDouble();
        configFile.addCustomCategoryComment("KEB", "Configuration stuff for your Kinetic Energy Buffers");
        powerloss = configFile.get("KEB", "powerloss", false).getBoolean();
        KEB1powerloss = configFile.get("KEB", "KEB1powerloss", 10).setMinValue(0).getInt();
        KEB2powerloss = configFile.get("KEB", "KEBT2powerloss", 5).setMinValue(0).getInt();
        KEB3powerloss = configFile.get("KEB", "KEBT3powerloss", 3).setMinValue(0).getInt();
        capacityKEBTier1 = configFile.get("KEB", "KEBTier1Capacity", 3000000).setMinValue(0).getInt();
        capacityKEBTier2 = configFile.get("KEB", "KEBTier2Capacity", 25000000).setMinValue(0).getInt();
        capacityKEBTier3 = configFile.get("KEB", "KEBTier3Capacity", 100000000).setMinValue(0).getInt();
        maxTransferKEBTier1 = configFile.get("KEB", "KEBTier1MaxTransfer", 32768).setMinValue(0).getInt();
        maxTransferKEBTier2 = configFile.get("KEB", "KEBTier2MaxTransfer", 65536).setMinValue(0).getInt();
        maxTransferKEBTier3 = configFile.get("KEB", "KEBTier3MaxTransfer", 131072).setMinValue(0).getInt();
        configFile.addCustomCategoryComment("Heated Furnace", "Configuration stuff for your Heated Furnace");
        heatedFurnaceHeatRequired = configFile.get("Heated Furnace", "heatedFurnaceHeatRequired", 6500, "How much heat the furnace needs to receive to process one item").setMinValue(0).getInt();
        basicCoilHeat = configFile.get("Heated Furnace", "basicCoilHeat", 16, "Amount of heat a basic coil can generate each tick").setMinValue(0).getInt();
        lavaCoilHeat = configFile.get("Heated Furnace", "lavaCoilHeat", 32, "Amount of heat generated by a lava coil each tick").setMinValue(0).getInt();
        kineticCoilHeatModifier = configFile.get("Heated Furnace", "kineticCoilHeatModifier", 15, "The amount of heat a kinetic coil generates is the amount of RF it received during the last tick multiplied with this number").setMinValue(0).getInt();
        configFile.addCustomCategoryComment("Charging Station", "Configuration stuff for your Charging Station");
        capacityChargingStation = configFile.get("Charging Station", "ChargingStationCapacity", 10000).setMinValue(0).getInt();
        maxTransferChargingStation = configFile.get("Charging Station", "ChargingStationMaxTransfer", 8192).setMinValue(0).getInt();
        configFile.addCustomCategoryComment("Fluidic Compressor", "Configuration stuff for your Fluidic Compressor");
        capacityFluidicCompressor = configFile.get("Fluidic Compressor", "FluidicCompressorCapacity", 1000).setMinValue(0).getInt();
        maxTransferFluidicCompressor = configFile.get("Fluidic Compressor", "FluidicCompressorMaxTransfer", 128).setMinValue(0).getInt();
        configFile.addCustomCategoryComment("Mechanical Duster", "Configuration stuff for your Mechanical Duster");
        capacityMechanicalDuster = configFile.get("Mechanical Duster", "MechanicalDusterCapacity", 2000).setMinValue(0).getInt();
        maxTransferMechanicalDuster = configFile.get("Mechanical Duster", "MechanicalDusterMaxTransfer", 1024).setMinValue(0).getInt();
        energyUseMechanicalDuster = configFile.get("Mechanical Duster", "MechanicalDusterEnergyUse", 10).setMinValue(0).getInt();
        configFile.addCustomCategoryComment("Refinery", "Configuration stuff for your Refinery");
        capacityRefinery = configFile.get("Refinery", "RefineryCapacity", 50000).setMinValue(0).getInt();
        maxTransferRefinery = configFile.get("Refinery", "RefineryMaxTransfer", 1024).setMinValue(0).getInt();
        energyUseRefineryMultiplier = configFile.get("Refinery", "RefineryEnergyUseMultiplier", 1).setMinValue(0).getInt();
        configFile.addCustomCategoryComment("Portable Laser", "Configuration stuff for your Portable Lasers");
        portableLaserPowerUse = configFile.get("Portable Laser", "PortableLaserPowerUse", 8000).setMinValue(0).getInt();
        portableLaserLaserPower = configFile.get("Portable Laser", "PortableLaserLaserPower", 8000).setMinValue(0).getInt();
        portableLaserEntityDamage = (float)configFile.get("Portable Laser", "PortableLaserEntityDamage", 10.0).setMinValue(0).setMaxValue(3.4028234663852886E38).getDouble();
        portableLaserEntityBurnTime = configFile.get("Portable Laser", "PortableLaserEntityBurnTime", 8).setMinValue(0).getInt();
        configFile.addCustomCategoryComment("Coloring Tool", "Configuration stuff for your Portable Lasers");
        capacityPipeColoringTool = configFile.get("Coloring Tool", "ColoringToolCapacity", 100000).setMinValue(0).getInt();
        maxTransferColoringTool = configFile.get("Coloring Tool", "ColoringToolMaxTransfer", 1024).setMinValue(0).getInt();
        energyUseColoringTool = configFile.get("Coloring Tool", "ColoringToolEnergyUse", 16).setMinValue(0).getInt();
        configFile.addCustomCategoryComment("Power Capsule", "Configuration stuff for your Power Capsules");
        capacityPowerCapsuleTier1 = configFile.get("Power Capsule", "PowerCapsuleTier1Capacity", 100000).setMinValue(0).getInt();
        capacityPowerCapsuleTier2 = configFile.get("Power Capsule", "PowerCapsuleTier2Capacity", 300000).setMinValue(0).getInt();
        capacityPowerCapsuleTier3 = configFile.get("Power Capsule", "PowerCapsuleTier3Capacity", 1000000).setMinValue(0).getInt();
        maxTransferPowerCapsuleTier1 = configFile.get("Power Capsule", "PowerCapsuleTier1MaxTransfer", 1024).setMinValue(0).getInt();
        maxTransferPowerCapsuleTier2 = configFile.get("Power Capsule", "PowerCapsuleTier2MaxTransfer", 4096).setMinValue(0).getInt();
        maxTransferPowerCapsuleTier3 = configFile.get("Power Capsule", "PowerCapsuleTier3MaxTransfer", 16384).setMinValue(0).getInt();
        configFile.addCustomCategoryComment("Upgrades.Refinery", "Configuration stuff for your refinery upgrades");
        refineryAutoExportMaxTransfer = configFile.get("Upgrades.Refinery", "UpgradesRefineryAutoExportMaxTransfer", 100).setMinValue(0).getInt();
        refineryAutoImportMaxTransfer = configFile.get("Upgrades.Refinery", "UpgradesRefineryAutoImportMaxTransfer", 100).setMinValue(0).getInt();
        refineryEfficiency1EnergyCostModifier = configFile.get("Upgrades.Refinery", "UpgradesRefineryEfficiency1EnergyCostModifier", -0.1).setMaxValue(0).getDouble();
        refineryEfficiency2EnergyCostModifier = configFile.get("Upgrades.Refinery", "UpgradesRefineryEfficiency2EnergyCostModifier", -0.15).setMaxValue(0).getDouble();
        refineryEfficiency3EnergyCostModifier = configFile.get("Upgrades.Refinery", "UpgradesRefineryEfficiency3EnergyCostModifier", -0.25).setMaxValue(0).getDouble();
        refinerySpeed1EnergyCostModifier = configFile.get("Upgrades.Refinery", "UpgradesRefinerySpeed1EnergyCostModifier", 0.2).setMinValue(0).getDouble();
        refinerySpeed2EnergyCostModifier = configFile.get("Upgrades.Refinery", "UpgradesRefinerySpeed2EnergyCostModifier", 0.3).setMinValue(0).getDouble();
        refinerySpeed3EnergyCostModifier = configFile.get("Upgrades.Refinery", "UpgradesRefinerySpeed3EnergyCostModifier", 0.5).setMinValue(0).getDouble();
        refinerySpeed1SpeedModifier = configFile.get("Upgrades.Refinery", "UpgradesRefinerySpeed1SpeedModifier", 1).setMinValue(0).getInt();
        refinerySpeed2SpeedModifier = configFile.get("Upgrades.Refinery", "UpgradesRefinerySpeed2SpeedModifier", 2).setMinValue(0).getInt();
        refinerySpeed3SpeedModifier = configFile.get("Upgrades.Refinery", "UpgradesRefinerySpeed3SpeedModifier", 3).setMinValue(0).getInt();
        configFile.addCustomCategoryComment("Upgrades.Cooling Tower", "Configuration stuff for your cooling tower upgrades");
        coolingTowerAutoExportMaxTransfer = configFile.get("Upgrades.Cooling Tower", "UpgradesCoolingTowerAutoExportMaxTransfer", 100).setMinValue(0).getInt();
        coolingTowerAutoImportMaxTransfer = configFile.get("Upgrades.Cooling Tower", "UpgradesCoolingTowerAutoImportMaxTransfer", 100).setMinValue(0).getInt();
        coolingTowerSpeed1SpeedModifier = configFile.get("Upgrades.Cooling Tower", "UpgradesCoolingTowerSpeed1SpeedModifier", 1).setMinValue(0).getInt();
        coolingTowerSpeed2SpeedModifier = configFile.get("Upgrades.Cooling Tower", "UpgradesCoolingTowerSpeed2SpeedModifier", 2).setMinValue(0).getInt();
        coolingTowerSpeed3SpeedModifier = configFile.get("Upgrades.Cooling Tower", "UpgradesCoolingTowerSpeed3SpeedModifier", 3).setMinValue(0).getInt();
        coolingTowerEfficiency1CoolingModifier = (float)configFile.get("Upgrades.Cooling Tower", "UpgradesCoolingTowerEfficiency1CoolingModifier", 0.25).setMinValue(0).setMaxValue(3.4028234663852886E38).getDouble();
        coolingTowerEfficiency2CoolingModifier = (float)configFile.get("Upgrades.Cooling Tower", "UpgradesCoolingTowerEfficiency2CoolingModifier", 0.5).setMinValue(0).setMaxValue(3.4028234663852886E38).getDouble();
        coolingTowerEfficiency3CoolingModifier = (float)configFile.get("Upgrades.Cooling Tower", "UpgradesCoolingTowerEfficiency3CoolingModifier", 1.0).setMinValue(0).setMaxValue(3.4028234663852886E38).getDouble();
        configFile.addCustomCategoryComment("Misc", "Stuff that didn't fit in any other category");
        shouldRegisterDusts = configFile.get("Misc", "shouldRegisterDusts", true).setRequiresMcRestart(true).getBoolean();
        eurekaIntegration = configFile.get("Misc", "eurekaIntegration", true).setRequiresMcRestart(true).getBoolean();
        dusterParticles = configFile.get("Misc", "dusterParticles", true).getBoolean();
        particleCount = configFile.get("Misc", "particleCount", 100).setMinValue(0).getInt();
        forceEnableBCRefinery = !ConfigurationHandler.enabled("MultiBlockRefining") | configFile.get("Misc", "forceEnableBCRefinery", false).setRequiresMcRestart(true).getBoolean();
        powerpipesInPowerPlant = configFile.get("Misc", "powerpipesInPowerPlant", true).getBoolean();
        slimesUsingDusters = configFile.get("Misc", "slimesUsingDusters", false).getBoolean();
        if (configFile.hasChanged()) {
            configFile.save();
        }
    }
}

