/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.compat.nei;

import buildcraftAdditions.api.recipe.BCARecipeManager;
import buildcraftAdditions.api.recipe.refinery.IRefineryRecipe;
import buildcraftAdditions.client.gui.GuiRefinery;
import buildcraftAdditions.compat.nei.RecipeHandlerBase;
import buildcraftAdditions.utils.Utils;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import com.google.common.collect.Lists;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraftforge.fluids.FluidStack;

public class RecipeHandlerRefinery
extends RecipeHandlerBase {
    @Override
    public String getRecipeID() {
        return "bcadditions:refinery";
    }

    public String getGuiTexture() {
        return "bcadditions:textures/gui/nei/guiNEIRefinery.png";
    }

    public String getRecipeName() {
        return Utils.localize("gui.refinery.name");
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiRefinery.class;
    }

    public void drawBackground(int recipe) {
        this.changeToGuiTexture();
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)-3, (int)0, (int)161, (int)129);
    }

    public void loadTransferRects() {
    }

    @Override
    public void loadAllRecipes() {
        for (IRefineryRecipe iRefineryRecipe : BCARecipeManager.refinery.getRecipes()) {
            this.arecipes.add(new CachedRefineryRecipe(iRefineryRecipe));
        }
    }

    @Override
    public void loadCraftingRecipes(FluidStack result) {
        for (IRefineryRecipe iRefineryRecipe : BCARecipeManager.refinery.getRecipes()) {
            if (iRefineryRecipe.getOutput() == null || result == null || iRefineryRecipe.getOutput().getFluid() != result.getFluid()) continue;
            this.arecipes.add(new CachedRefineryRecipe(iRefineryRecipe));
        }
    }

    @Override
    public void loadUsageRecipes(FluidStack ingredient) {
        for (IRefineryRecipe iRefineryRecipe : BCARecipeManager.refinery.getRecipes()) {
            if (iRefineryRecipe.getInput() == null || ingredient == null || iRefineryRecipe.getInput().getFluid() != ingredient.getFluid()) continue;
            this.arecipes.add(new CachedRefineryRecipe(iRefineryRecipe));
        }
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void drawExtras(int recipe) {
        GuiDraw.drawString((String)(Utils.localize("gui.requiredHeat") + ":" + ((CachedRefineryRecipe)((Object)this.arecipes.get((int)recipe))).requiredHeat), (int)39, (int)100, (int)0xFFCC00);
    }

    public class CachedRefineryRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public FluidStack input;
        public FluidStack output;
        public int requiredHeat;
        private int recipeAmount = 3000;

        public CachedRefineryRecipe(IRefineryRecipe recipe) {
            this.input = recipe.getInput();
            this.output = recipe.getOutput();
            this.requiredHeat = recipe.getRequiredHeat();
        }

        @Override
        public List<RecipeHandlerBase.PositionedFluidTank> getFluidTanks() {
            ArrayList tanks = Lists.newArrayList();
            this.input.amount = 3000 - this.recipeAmount;
            this.output.amount = this.recipeAmount;
            tanks.add(new RecipeHandlerBase.PositionedFluidTank(this.input, 3000, new Rectangle(14, 37, 16, 52), RecipeHandlerRefinery.this.getGuiTexture(), new Point(158, 0)));
            tanks.add(new RecipeHandlerBase.PositionedFluidTank(this.output, 3000, new Rectangle(134, 37, 16, 52), RecipeHandlerRefinery.this.getGuiTexture(), new Point(158, 0)));
            return tanks;
        }

        @Override
        public void drawUpdate() {
            this.recipeAmount = RecipeHandlerRefinery.this.cycleticks % 125 * 25;
        }

        public PositionedStack getResult() {
            return null;
        }
    }
}

