/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.compat.nei;

import buildcraft.api.fuels.ICoolant;
import buildcraft.energy.fuels.CoolantManager;
import buildcraftAdditions.api.recipe.BCARecipeManager;
import buildcraftAdditions.api.recipe.refinery.ICoolingTowerRecipe;
import buildcraftAdditions.client.gui.GuiCoolingTower;
import buildcraftAdditions.compat.nei.RecipeHandlerBase;
import buildcraftAdditions.utils.Utils;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import com.google.common.collect.Lists;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class RecipeHandlerCoolingTower
extends RecipeHandlerBase {
    public static List<Fluid> coolants = Lists.newArrayList();

    @Override
    public String getRecipeID() {
        return "bcadditions:coolingTower";
    }

    public String getGuiTexture() {
        return "bcadditions:textures/gui/nei/guiNEICoolingTower.png";
    }

    public String getRecipeName() {
        return Utils.localize("gui.coolingTower.name");
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiCoolingTower.class;
    }

    public void drawBackground(int recipe) {
        this.changeToGuiTexture();
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)-3, (int)0, (int)161, (int)157);
    }

    public void loadTransferRects() {
    }

    @Override
    public void loadAllRecipes() {
        for (ICoolingTowerRecipe iCoolingTowerRecipe : BCARecipeManager.cooling.getRecipes()) {
            this.arecipes.add(new CachedCoolingTowerRecipe(iCoolingTowerRecipe));
        }
    }

    @Override
    public void loadCraftingRecipes(FluidStack result) {
        for (ICoolingTowerRecipe iCoolingTowerRecipe : BCARecipeManager.cooling.getRecipes()) {
            if (iCoolingTowerRecipe.getOutput() == null || result == null || iCoolingTowerRecipe.getOutput().getFluid() != result.getFluid()) continue;
            this.arecipes.add(new CachedCoolingTowerRecipe(iCoolingTowerRecipe));
        }
    }

    @Override
    public void loadUsageRecipes(FluidStack ingredient) {
        for (ICoolingTowerRecipe iCoolingTowerRecipe : BCARecipeManager.cooling.getRecipes()) {
            if (iCoolingTowerRecipe.getInput() == null || ingredient == null || iCoolingTowerRecipe.getInput().getFluid() != ingredient.getFluid()) continue;
            this.arecipes.add(new CachedCoolingTowerRecipe(iCoolingTowerRecipe));
        }
    }

    public int recipiesPerPage() {
        return 1;
    }

    public class CachedCoolingTowerRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public FluidStack input;
        public FluidStack output;
        public float heat;
        private int coolantI = 0;
        private int coolantAmount = 10000;
        private int recipeAmount = 2000;

        public CachedCoolingTowerRecipe(ICoolingTowerRecipe recipe) {
            this.input = recipe.getInput();
            this.output = recipe.getOutput();
            this.heat = recipe.getHeat();
            this.convertCoolants();
        }

        public void convertCoolants() {
            if (!coolants.isEmpty()) {
                return;
            }
            for (ICoolant coolant : CoolantManager.INSTANCE.getCoolants()) {
                coolants.add(coolant.getFluid());
            }
        }

        @Override
        public List<RecipeHandlerBase.PositionedFluidTank> getFluidTanks() {
            ArrayList tanks = Lists.newArrayList();
            this.input.amount = 2000 - this.recipeAmount;
            this.output.amount = this.recipeAmount;
            tanks.add(new RecipeHandlerBase.PositionedFluidTank(this.input, 2000, new Rectangle(21, 27, 16, 52), RecipeHandlerCoolingTower.this.getGuiTexture(), new Point(158, 0)));
            tanks.add(new RecipeHandlerBase.PositionedFluidTank(this.output, 2000, new Rectangle(127, 27, 16, 52), RecipeHandlerCoolingTower.this.getGuiTexture(), new Point(158, 0)));
            tanks.add(new RecipeHandlerBase.PositionedFluidTank(new FluidStack(coolants.get(this.coolantI), this.coolantAmount), 10000, new Rectangle(74, 60, 16, 52), RecipeHandlerCoolingTower.this.getGuiTexture(), new Point(158, 0)));
            return tanks;
        }

        @Override
        public void drawUpdate() {
            this.coolantI = RecipeHandlerCoolingTower.this.cycleticks % (40 * coolants.size()) / 40;
            this.coolantAmount = 10000 - RecipeHandlerCoolingTower.this.cycleticks % 200 * 50;
            this.recipeAmount = RecipeHandlerCoolingTower.this.cycleticks % 100 * 25;
        }

        public PositionedStack getResult() {
            return null;
        }
    }
}

