/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.compat.nei;

import buildcraftAdditions.utils.RenderUtils;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.PositionedStack;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.lwjgl.opengl.GL11;

public abstract class RecipeHandlerBase
extends TemplateRecipeHandler
implements ICraftingHandler,
IUsageHandler {
    public abstract String getRecipeID();

    public String getRecipeSubName() {
        return null;
    }

    public void changeToGuiTexture() {
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void addTransferRect(int x, int y, int width, int height) {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(x, y, width, height), this.getRecipeID(), new Object[0]));
    }

    public void drawForeground(int recipe) {
        super.drawForeground(recipe);
        this.drawFluidTanks(recipe);
        if (recipe % this.recipiesPerPage() == 0 && this.getRecipeSubName() != null) {
            GuiDraw.drawStringC((String)this.getRecipeSubName(), (int)83, (int)-2, (int)0x404040, (boolean)false);
        }
        this.changeToGuiTexture();
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("liquid")) {
            this.loadCraftingRecipes((FluidStack)results[0]);
        } else if (outputId.equals(this.getRecipeID())) {
            this.loadAllRecipes();
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadAllRecipes() {
    }

    public void loadCraftingRecipes(ItemStack result) {
        FluidStack fluid = RecipeHandlerBase.getFluidStackFromItemStack(result);
        if (fluid != null) {
            this.loadCraftingRecipes(fluid);
        }
    }

    public void loadCraftingRecipes(FluidStack result) {
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("liquid")) {
            this.loadUsageRecipes((FluidStack)ingredients[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingred) {
        FluidStack fluid = RecipeHandlerBase.getFluidStackFromItemStack(ingred);
        if (fluid != null) {
            this.loadUsageRecipes(fluid);
        }
    }

    public void loadUsageRecipes(FluidStack ingredient) {
    }

    protected boolean transferFluidTank(GuiRecipe guiRecipe, int recipe, boolean usage) {
        CachedBaseRecipe crecipe = (CachedBaseRecipe)((Object)this.arecipes.get(recipe));
        Point mousepos = GuiDraw.getMousePosition();
        Point offset = guiRecipe.getRecipePosition(recipe);
        Point relMouse = new Point(mousepos.x - (guiRecipe.field_146294_l - 176) / 2 - offset.x, mousepos.y - (guiRecipe.field_146295_m - 166) / 2 - offset.y);
        if (crecipe.getFluidTanks() != null) {
            for (PositionedFluidTank tank : crecipe.getFluidTanks()) {
                if (!tank.position.contains(relMouse)) continue;
                return tank.transfer(usage);
            }
        }
        return false;
    }

    public void drawFluidTanks(int recipe) {
        CachedBaseRecipe crecipe = (CachedBaseRecipe)((Object)this.arecipes.get(recipe));
        if (crecipe.getFluidTanks() != null) {
            crecipe.drawUpdate();
            for (PositionedFluidTank fluidTank : crecipe.getFluidTanks()) {
                fluidTank.draw();
            }
        }
    }

    public List<String> handleTooltip(GuiRecipe guiRecipe, List<String> currenttip, int recipe) {
        super.handleTooltip(guiRecipe, currenttip, recipe);
        CachedBaseRecipe crecipe = (CachedBaseRecipe)((Object)this.arecipes.get(recipe));
        if (GuiContainerManager.shouldShowTooltip((GuiContainer)guiRecipe)) {
            Point mouse = GuiDraw.getMousePosition();
            Point offset = guiRecipe.getRecipePosition(recipe);
            Point relMouse = new Point(mouse.x - (guiRecipe.field_146294_l - 176) / 2 - offset.x, mouse.y - (guiRecipe.field_146295_m - 166) / 2 - offset.y);
            currenttip = this.provideTooltip(guiRecipe, currenttip, crecipe, relMouse);
        }
        return currenttip;
    }

    public List<String> handleItemTooltip(GuiRecipe guiRecipe, ItemStack itemStack, List<String> currenttip, int recipe) {
        super.handleItemTooltip(guiRecipe, itemStack, currenttip, recipe);
        CachedBaseRecipe crecipe = (CachedBaseRecipe)((Object)this.arecipes.get(recipe));
        Point mouse = GuiDraw.getMousePosition();
        Point offset = guiRecipe.getRecipePosition(recipe);
        Point relMouse = new Point(mouse.x - (guiRecipe.field_146294_l - 176) / 2 - offset.x, mouse.y - (guiRecipe.field_146295_m - 166) / 2 - offset.y);
        currenttip = this.provideItemTooltip(guiRecipe, itemStack, currenttip, crecipe, relMouse);
        return currenttip;
    }

    public List<String> provideTooltip(GuiRecipe guiRecipe, List<String> currenttip, CachedBaseRecipe crecipe, Point relMouse) {
        if (crecipe.getFluidTanks() != null) {
            for (PositionedFluidTank tank : crecipe.getFluidTanks()) {
                if (!tank.position.contains(relMouse)) continue;
                tank.handleTooltip(currenttip);
            }
        }
        return currenttip;
    }

    public List<String> provideItemTooltip(GuiRecipe guiRecipe, ItemStack itemStack, List<String> currenttip, CachedBaseRecipe crecipe, Point relMouse) {
        for (PositionedStack stack : crecipe.getIngredients()) {
            if (!(stack instanceof PositionedStackAdv) || !((PositionedStackAdv)stack).getRect().contains(relMouse)) continue;
            currenttip = ((PositionedStackAdv)stack).handleTooltip(guiRecipe, currenttip);
        }
        for (PositionedStack stack : crecipe.getOtherStacks()) {
            if (!(stack instanceof PositionedStackAdv) || !((PositionedStackAdv)stack).getRect().contains(relMouse)) continue;
            currenttip = ((PositionedStackAdv)stack).handleTooltip(guiRecipe, currenttip);
        }
        PositionedStack stack = crecipe.getResult();
        if (stack instanceof PositionedStackAdv && ((PositionedStackAdv)stack).getRect().contains(relMouse)) {
            currenttip = ((PositionedStackAdv)stack).handleTooltip(guiRecipe, currenttip);
        }
        return currenttip;
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe) {
        if (keyCode == NEIClientConfig.getKeyBinding((String)"gui.recipe") ? this.transferFluidTank(gui, recipe, false) : keyCode == NEIClientConfig.getKeyBinding((String)"gui.usage") && this.transferFluidTank(gui, recipe, true)) {
            return true;
        }
        return super.keyTyped(gui, keyChar, keyCode, recipe);
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        if (button == 0 ? this.transferFluidTank(gui, recipe, false) : button == 1 && this.transferFluidTank(gui, recipe, true)) {
            return true;
        }
        return super.mouseClicked(gui, button, recipe);
    }

    public static FluidStack getFluidStackFromItemStack(ItemStack stack) {
        if (stack != null) {
            Block b;
            if (stack.func_77973_b() instanceof IFluidContainerItem) {
                IFluidContainerItem ctr = (IFluidContainerItem)stack.func_77973_b();
                return ctr.getFluid(stack);
            }
            if (FluidContainerRegistry.isFilledContainer((ItemStack)stack)) {
                return FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
            }
            if (stack.func_77973_b() instanceof ItemBlock && (b = Block.func_149634_a((Item)stack.func_77973_b())) != null && b instanceof IFluidBlock && ((IFluidBlock)b).getFluid() != null) {
                return new FluidStack(((IFluidBlock)b).getFluid(), 1000);
            }
        }
        return null;
    }

    public class PositionedFluidTank {
        public FluidTank tank;
        public Rectangle position;
        public String overlayTexture;
        public Point overlayTexturePos;
        public boolean flowingTexture = false;
        public boolean showAmount = false;
        public boolean perTick = false;

        public PositionedFluidTank(FluidTank tank, Rectangle position, String overlayTexture, Point overlayTexturePos) {
            this.position = position;
            this.tank = tank;
            this.overlayTexture = overlayTexture;
            this.overlayTexturePos = overlayTexturePos;
        }

        public PositionedFluidTank(FluidTank tank, Rectangle position) {
            this(tank, position, null, null);
        }

        public PositionedFluidTank(FluidStack fluid, int capacity, Rectangle position, String overlayTexture, Point overlayTexturePos) {
            this(new FluidTank(fluid != null ? fluid.copy() : null, capacity), position, overlayTexture, overlayTexturePos);
        }

        public PositionedFluidTank(FluidStack fluid, int capacity, Rectangle position) {
            this(fluid, capacity, position, null, null);
        }

        public PositionedFluidTank setUseFlowingTexture(boolean useFlowingTexture) {
            this.flowingTexture = useFlowingTexture;
            return this;
        }

        public PositionedFluidTank setShowAmount(boolean showAmount) {
            this.showAmount = showAmount;
            return this;
        }

        public PositionedFluidTank setPerTick(boolean perTick) {
            this.perTick = perTick;
            return this;
        }

        public List<String> handleTooltip(List<String> currenttip) {
            if (this.tank == null || this.tank.getFluid() == null || this.tank.getFluid().getFluid() == null || this.tank.getFluid().amount <= 0) {
                return currenttip;
            }
            currenttip.add(this.tank.getFluid().getLocalizedName());
            if (this.showAmount) {
                currenttip.add(EnumChatFormatting.GRAY.toString() + this.tank.getFluid().amount + (this.perTick ? " mB/t" : " mB"));
            }
            return currenttip;
        }

        public boolean transfer(boolean usage) {
            if (this.tank.getFluid() != null && this.tank.getFluid().amount > 0) {
                return !(usage ? !GuiUsageRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{this.tank.getFluid()}) : !GuiCraftingRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{this.tank.getFluid()}));
            }
            return false;
        }

        public void draw() {
            if (this.tank == null || this.tank.getFluid() == null || this.tank.getFluid().getFluid() == null || this.tank.getFluid().amount <= 0) {
                return;
            }
            IIcon fluidIcon = null;
            if (this.flowingTexture && this.tank.getFluid().getFluid().getFlowingIcon() != null) {
                fluidIcon = this.tank.getFluid().getFluid().getFlowingIcon();
            } else if (this.tank.getFluid().getFluid().getStillIcon() != null) {
                fluidIcon = this.tank.getFluid().getFluid().getStillIcon();
            } else {
                return;
            }
            GuiDraw.changeTexture((ResourceLocation)RenderUtils.MC_BLOCK_SHEET);
            int color = this.tank.getFluid().getFluid().getColor(this.tank.getFluid());
            GL11.glColor3ub((byte)((byte)(color >> 16 & 0xFF)), (byte)((byte)(color >> 8 & 0xFF)), (byte)((byte)(color & 0xFF)));
            GL11.glDisable((int)3042);
            int amount = Math.max(Math.min(this.position.height, this.tank.getFluid().amount * this.position.height / this.tank.getCapacity()), 1);
            int posY = this.position.y + this.position.height - amount;
            for (int i = 0; i < this.position.width; i += 16) {
                for (int j = 0; j < amount; j += 16) {
                    int drawWidth = Math.min(this.position.width - i, 16);
                    int drawHeight = Math.min(amount - j, 16);
                    int drawX = this.position.x + i;
                    int drawY = posY + j;
                    double minU = fluidIcon.func_94209_e();
                    double maxU = fluidIcon.func_94212_f();
                    double minV = fluidIcon.func_94206_g();
                    double maxV = fluidIcon.func_94210_h();
                    Tessellator tessellator = Tessellator.field_78398_a;
                    tessellator.func_78382_b();
                    tessellator.func_78374_a((double)drawX, (double)(drawY + drawHeight), 0.0, minU, minV + (maxV - minV) * (double)drawHeight / 16.0);
                    tessellator.func_78374_a((double)(drawX + drawWidth), (double)(drawY + drawHeight), 0.0, minU + (maxU - minU) * (double)drawWidth / 16.0, minV + (maxV - minV) * (double)drawHeight / 16.0);
                    tessellator.func_78374_a((double)(drawX + drawWidth), (double)drawY, 0.0, minU + (maxU - minU) * (double)drawWidth / 16.0, minV);
                    tessellator.func_78374_a((double)drawX, (double)drawY, 0.0, minU, minV);
                    tessellator.func_78381_a();
                }
            }
            GL11.glEnable((int)3042);
            if (this.overlayTexture != null && this.overlayTexturePos != null) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GuiDraw.changeTexture((String)this.overlayTexture);
                GuiDraw.drawTexturedModalRect((int)this.position.x, (int)this.position.y, (int)this.overlayTexturePos.x, (int)this.overlayTexturePos.y, (int)this.position.width, (int)this.position.height);
            }
        }
    }

    public class PositionedStackAdv
    extends PositionedStack {
        private List<String> tooltip;

        public PositionedStackAdv(Object object, int x, int y) {
            super(object, x, y);
            this.tooltip = new ArrayList<String>();
        }

        public PositionedStackAdv(Object object, int x, int y, List<String> tooltip) {
            super(object, x, y);
            this.tooltip = new ArrayList<String>();
            this.addToTooltip(tooltip);
        }

        public Rectangle getRect() {
            return new Rectangle(this.relx - 1, this.rely - 1, 18, 18);
        }

        public List<String> handleTooltip(GuiRecipe guiRecipe, List<String> currenttip) {
            if (!this.tooltip.isEmpty()) {
                for (String tip : this.tooltip) {
                    currenttip.add(tip);
                }
            }
            return currenttip;
        }

        public PositionedStackAdv addToTooltip(List<String> lines) {
            for (String tip : lines) {
                this.tooltip.add(tip);
            }
            return this;
        }

        public PositionedStackAdv addToTooltip(String line) {
            this.tooltip.add(line);
            return this;
        }
    }

    public abstract class CachedBaseRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public CachedBaseRecipe() {
            super((TemplateRecipeHandler)RecipeHandlerBase.this);
        }

        public List<PositionedFluidTank> getFluidTanks() {
            ArrayList<PositionedFluidTank> tanks = new ArrayList<PositionedFluidTank>();
            PositionedFluidTank tank = this.getFluidTank();
            if (tank != null) {
                tanks.add(tank);
            }
            return tanks;
        }

        public PositionedFluidTank getFluidTank() {
            return null;
        }

        public void drawUpdate() {
        }
    }
}

