/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.compat.nei;

import buildcraftAdditions.api.recipe.BCARecipeManager;
import buildcraftAdditions.api.recipe.duster.IDusterRecipe;
import buildcraftAdditions.utils.Utils;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class DustingRecipeHandler
extends TemplateRecipeHandler {
    private static final ResourceLocation texture = new ResourceLocation("bcadditions", "textures/gui/nei/dusting.png");

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(71, 24, 24, 17), this.getRecipeID(), new Object[0]));
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)166, (int)65);
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeID())) {
            for (IDusterRecipe iDusterRecipe : BCARecipeManager.duster.getRecipes()) {
                for (ItemStack stack : iDusterRecipe.getInputs()) {
                    this.arecipes.add(new CachedDustingRecipe(stack, iDusterRecipe.getOutput(stack)));
                }
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (IDusterRecipe iDusterRecipe : BCARecipeManager.duster.getRecipes()) {
            for (ItemStack stack : iDusterRecipe.getInputs()) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)iDusterRecipe.getOutput(stack), (ItemStack)result)) continue;
                this.arecipes.add(new CachedDustingRecipe(stack, iDusterRecipe.getOutput(stack)));
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (IDusterRecipe iDusterRecipe : BCARecipeManager.duster.getRecipes()) {
            for (ItemStack stack : iDusterRecipe.getInputs()) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)stack, (ItemStack)ingredient)) continue;
                CachedDustingRecipe cRecipe = new CachedDustingRecipe(stack, iDusterRecipe.getOutput(stack));
                cRecipe.setIngredientPermutation(Collections.singletonList(cRecipe.input), ingredient);
                this.arecipes.add(cRecipe);
            }
        }
    }

    public String getGuiTexture() {
        return texture.toString();
    }

    public String getRecipeName() {
        return Utils.localize("gui.nei.dusting");
    }

    public String getRecipeID() {
        return "bcadditions:dusting";
    }

    public class CachedDustingRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public final PositionedStack input;
        public final PositionedStack output;

        public CachedDustingRecipe(ItemStack ingred, ItemStack result) {
            super((TemplateRecipeHandler)DustingRecipeHandler.this);
            ingred.field_77994_a = 1;
            this.input = new PositionedStack((Object)ingred, 28, 24);
            this.output = new PositionedStack((Object)result, 122, 24);
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(DustingRecipeHandler.this.cycleticks / 48, Arrays.asList(this.input));
        }
    }
}

