/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.compat.minetweaker.script;

import buildcraftAdditions.api.recipe.BCARecipeManager;
import buildcraftAdditions.api.recipe.refinery.IRefineryRecipe;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.bcadditions.refinery")
@ModOnly(value={"bcadditions"})
public class Refinery {
    public static void register() {
        MineTweakerAPI.registerClass(Refinery.class);
    }

    @ZenMethod
    public static void addRefineryRecipe(ILiquidStack input, ILiquidStack output, int requiredHeat) {
        MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(input, output, requiredHeat));
    }

    @ZenMethod
    public static void removeRefineryRecipe(ILiquidStack input) {
        MineTweakerAPI.apply((IUndoableAction)new RemoveRecipeAction(input));
    }

    private static class RemoveRecipeAction
    implements IUndoableAction {
        private final ILiquidStack input;
        private IRefineryRecipe refineryRecipe;

        public RemoveRecipeAction(ILiquidStack input) {
            this.input = input;
        }

        public void apply() {
            BCARecipeManager.refinery.removeRecipe(MineTweakerMC.getLiquidStack((ILiquidStack)this.input));
        }

        public boolean canUndo() {
            return this.refineryRecipe != null;
        }

        public void undo() {
            BCARecipeManager.refinery.addRecipe(this.refineryRecipe);
        }

        public String describe() {
            IRefineryRecipe recipe = BCARecipeManager.refinery.getRecipe(MineTweakerMC.getLiquidStack((ILiquidStack)this.input));
            return String.format("Removing BCA Refinery recipe for %s -> %s mB of %s : %s", this.input, recipe != null ? Integer.valueOf(recipe.getOutput().amount) : "?", recipe != null ? recipe.getOutput().getUnlocalizedName() : "?", recipe.getRequiredHeat());
        }

        public String describeUndo() {
            return String.format("Undoing \"Removing BCA Refinery recipe\": Adding BCA Refinery recipe for %s (%s)", this.input, this.refineryRecipe);
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddRecipeAction
    implements IUndoableAction {
        private final ILiquidStack input;
        private final ILiquidStack output;
        private final int requiredHeat;

        public AddRecipeAction(ILiquidStack input, ILiquidStack output, int requiredHeat) {
            this.input = input;
            this.output = output;
            this.requiredHeat = requiredHeat;
        }

        public void apply() {
            BCARecipeManager.refinery.addRecipe(MineTweakerMC.getLiquidStack((ILiquidStack)this.input), MineTweakerMC.getLiquidStack((ILiquidStack)this.output), this.requiredHeat);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            BCARecipeManager.refinery.removeRecipe(MineTweakerMC.getLiquidStack((ILiquidStack)this.input));
        }

        public String describe() {
            return String.format("Adding BCA Refinery recipe for %s -> %s : %s", this.input, this.output, this.requiredHeat);
        }

        public String describeUndo() {
            return String.format("Undoing \"Adding BCA Refinery recipe\": Removing BCA Refinery recipe for %s -> %s : %s", this.input, this.output, this.requiredHeat);
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

