/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.compat.minetweaker.script;

import buildcraftAdditions.api.recipe.BCARecipeManager;
import buildcraftAdditions.api.recipe.duster.IDusterRecipe;
import java.util.ArrayList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.api.oredict.IOreDictEntry;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.bcadditions.dusters")
@ModOnly(value={"bcadditions"})
public class Dusters {
    public static void register() {
        MineTweakerAPI.registerClass(Dusters.class);
    }

    @ZenMethod
    public static void addDusting(IItemStack input, IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(input, output));
    }

    @ZenMethod
    public static void addDusting(IOreDictEntry input, IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new AddRecipeOreDictAction(input, output));
    }

    @ZenMethod
    public static void removeDusting(IItemStack input) {
        MineTweakerAPI.apply((IUndoableAction)new RemoveRecipeAction(input));
    }

    @ZenMethod
    public static void removeDusting(IOreDictEntry input) {
        MineTweakerAPI.apply((IUndoableAction)new RemoveRecipeOreDictAction(input));
    }

    private static class RemoveRecipeOreDictAction
    implements IUndoableAction {
        public final IOreDictEntry input;
        public final List<IDusterRecipe> recipes;

        public RemoveRecipeOreDictAction(IOreDictEntry input) {
            this.input = input;
            this.recipes = new ArrayList<IDusterRecipe>();
        }

        public void apply() {
            for (IItemStack inputStack : this.input.getItems()) {
                ItemStack inputItemStack = MineTweakerMC.getItemStack((IItemStack)inputStack);
                IDusterRecipe recipe = BCARecipeManager.duster.getRecipe(inputItemStack);
                if (recipe == null) continue;
                this.recipes.add(recipe);
                BCARecipeManager.duster.removeRecipe(inputItemStack);
            }
        }

        public boolean canUndo() {
            return !this.recipes.isEmpty();
        }

        public void undo() {
            for (IDusterRecipe recipe : this.recipes) {
                BCARecipeManager.duster.addRecipe(recipe);
            }
        }

        public String describe() {
            ItemStack inputStack = MineTweakerMC.getItemStack((IIngredient)this.input);
            IDusterRecipe recipe = BCARecipeManager.duster.getRecipe(inputStack);
            return String.format("Removing BCA Duster recipe for %s -> %s", this.input, recipe != null ? recipe.getOutput(inputStack) : "?");
        }

        public String describeUndo() {
            return String.format("Undoing \"Removing BCA Duster recipe\": Adding BCA Duster recipe for %s (%s)", this.input, this.recipes);
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddRecipeOreDictAction
    implements IUndoableAction {
        public final IOreDictEntry input;
        public final IItemStack output;

        public AddRecipeOreDictAction(IOreDictEntry input, IItemStack output) {
            this.input = input;
            this.output = output;
        }

        public void apply() {
            BCARecipeManager.duster.addRecipe(this.input.getName(), MineTweakerMC.getItemStack((IItemStack)this.output));
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            for (IItemStack inputStack : this.input.getItems()) {
                BCARecipeManager.duster.removeRecipe(MineTweakerMC.getItemStack((IItemStack)inputStack));
            }
        }

        public String describe() {
            return String.format("Adding BCA Duster recipe for %s -> %s", this.input, this.output);
        }

        public String describeUndo() {
            return String.format("Undoing \"Adding BCA Duster recipe\": Removing BCA Duster recipe for %s -> %s", this.input, this.output);
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class RemoveRecipeAction
    implements IUndoableAction {
        public final IItemStack input;
        public IDusterRecipe dusterRecipe;

        public RemoveRecipeAction(IItemStack input) {
            this.input = input;
        }

        public void apply() {
            ItemStack inputStack = MineTweakerMC.getItemStack((IItemStack)this.input);
            IDusterRecipe recipe = BCARecipeManager.duster.getRecipe(inputStack);
            if (recipe != null) {
                this.dusterRecipe = recipe;
                BCARecipeManager.duster.removeRecipe(inputStack);
            }
        }

        public boolean canUndo() {
            return this.dusterRecipe != null;
        }

        public void undo() {
            BCARecipeManager.duster.addRecipe(this.dusterRecipe);
        }

        public String describe() {
            ItemStack inputStack = MineTweakerMC.getItemStack((IItemStack)this.input);
            IDusterRecipe recipe = BCARecipeManager.duster.getRecipe(inputStack);
            return String.format("Removing BCA Duster recipe for %s -> %s", this.input, recipe != null ? recipe.getOutput(inputStack) : "?");
        }

        public String describeUndo() {
            return String.format("Undoing \"Removing BCA Duster recipe\": Adding BCA Duster recipe for %s (%s)", this.input, this.dusterRecipe);
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddRecipeAction
    implements IUndoableAction {
        public final IItemStack input;
        public final IItemStack output;

        public AddRecipeAction(IItemStack input, IItemStack output) {
            this.input = input;
            this.output = output;
        }

        public void apply() {
            BCARecipeManager.duster.addRecipe(MineTweakerMC.getItemStack((IItemStack)this.input), MineTweakerMC.getItemStack((IItemStack)this.output));
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            BCARecipeManager.duster.removeRecipe(MineTweakerMC.getItemStack((IItemStack)this.input));
        }

        public String describe() {
            return String.format("Adding BCA Duster recipe for %s -> %s", this.input, this.output);
        }

        public String describeUndo() {
            return String.format("Undoing \"Adding BCA Duster recipe\": Removing BCA Duster recipe for %s -> %s", this.input, this.output);
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

