/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.compat.minetweaker.script;

import buildcraftAdditions.api.recipe.BCARecipeManager;
import buildcraftAdditions.api.recipe.refinery.ICoolingTowerRecipe;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.annotations.ModOnly;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.bcadditions.cooling")
@ModOnly(value={"bcadditions"})
public class Cooling {
    public static void register() {
        MineTweakerAPI.registerClass(Cooling.class);
    }

    @ZenMethod
    public static void addCoolingRecipe(ILiquidStack input, ILiquidStack output, float heat) {
        MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(input, output, heat));
    }

    @ZenMethod
    public static void removeCoolingRecipe(ILiquidStack input) {
        MineTweakerAPI.apply((IUndoableAction)new RemoveRecipeAction(input));
    }

    private static class RemoveRecipeAction
    implements IUndoableAction {
        private final ILiquidStack input;
        private ICoolingTowerRecipe coolingTowerRecipe;

        public RemoveRecipeAction(ILiquidStack input) {
            this.input = input;
        }

        public void apply() {
            FluidStack fluidStack = MineTweakerMC.getLiquidStack((ILiquidStack)this.input);
            this.coolingTowerRecipe = BCARecipeManager.cooling.getRecipe(fluidStack);
            BCARecipeManager.cooling.removeRecipe(fluidStack);
        }

        public boolean canUndo() {
            return this.coolingTowerRecipe != null;
        }

        public void undo() {
            BCARecipeManager.cooling.addRecipe(this.coolingTowerRecipe);
        }

        public String describe() {
            ICoolingTowerRecipe recipe = BCARecipeManager.cooling.getRecipe(MineTweakerMC.getLiquidStack((ILiquidStack)this.input));
            return String.format("Removing BCA Cooling Tower recipe for %s -> %s mB of %s : %s", this.input, recipe != null ? Integer.valueOf(recipe.getOutput().amount) : "?", recipe != null ? recipe.getOutput().getUnlocalizedName() : "?", Float.valueOf(recipe.getHeat()));
        }

        public String describeUndo() {
            return String.format("Undoing \"Removing BCA Cooling Tower recipe\": Adding BCA Cooling Tower recipe for %s (%s)", this.input, this.coolingTowerRecipe);
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddRecipeAction
    implements IUndoableAction {
        private final ILiquidStack input;
        private final ILiquidStack output;
        private final float heat;

        public AddRecipeAction(ILiquidStack input, ILiquidStack output, float heat) {
            this.input = input;
            this.output = output;
            this.heat = heat;
        }

        public void apply() {
            BCARecipeManager.cooling.addRecipe(MineTweakerMC.getLiquidStack((ILiquidStack)this.input), MineTweakerMC.getLiquidStack((ILiquidStack)this.output), this.heat);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            BCARecipeManager.cooling.removeRecipe(MineTweakerMC.getLiquidStack((ILiquidStack)this.input));
        }

        public String describe() {
            return String.format("Adding BCA Cooling Tower recipe for %s -> %s : %s", this.input, this.output, Float.valueOf(this.heat));
        }

        public String describeUndo() {
            return String.format("Undoing \"Adding BCA Cooling Tower recipe\":Removing BCA Cooling Tower recipe for %s -> %s : %s", this.input, this.output, Float.valueOf(this.heat));
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

