/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.compat.imc;

import buildcraftAdditions.api.item.BCAItemManager;
import buildcraftAdditions.api.item.dust.IDustType;
import buildcraftAdditions.api.recipe.BCARecipeManager;
import buildcraftAdditions.core.Logger;
import buildcraftAdditions.items.dust.DustTypes;
import com.google.common.base.Strings;
import cpw.mods.fml.common.event.FMLInterModComms;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class IMCHandler {
    public static void handleIMC(List<FMLInterModComms.IMCMessage> messages) {
        for (FMLInterModComms.IMCMessage message : messages) {
            FluidStack output;
            ItemStack input;
            NBTTagCompound tag;
            String type = message.key;
            if (Strings.isNullOrEmpty((String)type)) continue;
            if (type.equalsIgnoreCase("addDustingRecipe")) {
                if (!message.isNBTMessage()) {
                    IMCHandler.logNotNBT(message);
                    continue;
                }
                tag = message.getNBTValue();
                if (IMCHandler.hasNotAllRequiredTags(message, tag, "Input", "Output", 10)) continue;
                ItemStack output2 = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("Output"));
                if (output2 == null) {
                    IMCHandler.logWrongNBT(message);
                    continue;
                }
                if (tag.func_150297_b("Input", 8)) {
                    String oreInput = tag.func_74779_i("Input");
                    if (!Strings.isNullOrEmpty((String)oreInput)) {
                        BCARecipeManager.duster.addRecipe(oreInput, output2);
                        continue;
                    }
                    IMCHandler.logWrongNBT(message);
                    continue;
                }
                if (tag.func_150297_b("Input", 10)) {
                    ItemStack input2 = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("Input"));
                    if (input2 != null) {
                        BCARecipeManager.duster.addRecipe(input2, output2);
                        continue;
                    }
                    IMCHandler.logWrongNBT(message);
                    continue;
                }
                IMCHandler.logError(message, "Missing required NBT Tag 'Input' of type STRING or TAG_COMPOUND!");
                continue;
            }
            if (type.equalsIgnoreCase("addCoolingTowerRecipe")) {
                if (!message.isNBTMessage()) {
                    IMCHandler.logNotNBT(message);
                    continue;
                }
                tag = message.getNBTValue();
                if (IMCHandler.hasNotAllRequiredTags(message, tag, "Input", 10, "Output", 10, "Heat", 5)) continue;
                input = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("Input"));
                if (input == null) {
                    IMCHandler.logNotNBT(message);
                    continue;
                }
                output = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("Output"));
                if (output == null) {
                    IMCHandler.logNotNBT(message);
                    continue;
                }
                BCARecipeManager.cooling.addRecipe((FluidStack)input, output, tag.func_74760_g("Heat"));
                continue;
            }
            if (type.equalsIgnoreCase("addRefineryRecipe")) {
                if (!message.isNBTMessage()) {
                    IMCHandler.logNotNBT(message);
                    continue;
                }
                tag = message.getNBTValue();
                if (IMCHandler.hasNotAllRequiredTags(message, tag, "Input", 10, "Output", 10, "RequiredHeat", 3)) continue;
                input = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("Input"));
                if (input == null) {
                    IMCHandler.logNotNBT(message);
                    continue;
                }
                output = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("Output"));
                if (output == null) {
                    IMCHandler.logNotNBT(message);
                    continue;
                }
                BCARecipeManager.refinery.addRecipe((FluidStack)input, output, tag.func_74762_e("RequiredHeat"));
                continue;
            }
            if (type.equalsIgnoreCase("removeDustingRecipe")) {
                if (!message.isNBTMessage()) {
                    IMCHandler.logNotNBT(message);
                    continue;
                }
                tag = message.getNBTValue();
                if (IMCHandler.hasNotAllRequiredTags(message, tag, "Input", 10)) continue;
                input = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("Input"));
                if (input == null) {
                    IMCHandler.logNotNBT(message);
                    continue;
                }
                BCARecipeManager.duster.removeRecipe(input);
                continue;
            }
            if (type.equalsIgnoreCase("removeCoolingRecipe")) {
                if (!message.isNBTMessage()) {
                    IMCHandler.logNotNBT(message);
                    continue;
                }
                tag = message.getNBTValue();
                if (IMCHandler.hasNotAllRequiredTags(message, tag, "Input", 10)) continue;
                input = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("Input"));
                if (input == null) {
                    IMCHandler.logNotNBT(message);
                    continue;
                }
                BCARecipeManager.cooling.removeRecipe((FluidStack)input);
                continue;
            }
            if (type.equalsIgnoreCase("removeRefineryRecipe")) {
                if (!message.isNBTMessage()) {
                    IMCHandler.logNotNBT(message);
                    continue;
                }
                tag = message.getNBTValue();
                if (IMCHandler.hasNotAllRequiredTags(message, tag, "Input", 10)) continue;
                input = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("Input"));
                if (input == null) {
                    IMCHandler.logNotNBT(message);
                    continue;
                }
                BCARecipeManager.refinery.removeRecipe((FluidStack)input);
                continue;
            }
            if (type.equalsIgnoreCase("addMetalDust")) {
                if (!message.isNBTMessage()) {
                    IMCHandler.logNotNBT(message);
                    continue;
                }
                tag = message.getNBTValue();
                if (IMCHandler.hasNotAllRequiredTags(message, tag, "Meta", 3, "Name", 8, "ColorMultiplier", 3)) continue;
                BCAItemManager.dusts.addDust(tag.func_74762_e("Meta"), tag.func_74779_i("Name"), tag.func_74762_e("ColorMultiplier"), DustTypes.METAL_DUST);
                continue;
            }
            if (type.equalsIgnoreCase("addGemDust")) {
                if (!message.isNBTMessage()) {
                    IMCHandler.logNotNBT(message);
                    continue;
                }
                tag = message.getNBTValue();
                if (IMCHandler.hasNotAllRequiredTags(message, tag, "Meta", 3, "Name", 8, "ColorMultiplier", 3)) continue;
                BCAItemManager.dusts.addDust(tag.func_74762_e("Meta"), tag.func_74779_i("Name"), tag.func_74762_e("ColorMultiplier"), DustTypes.GEM_DUST);
                continue;
            }
            if (type.equalsIgnoreCase("addDust")) {
                IDustType iDustType;
                if (!message.isNBTMessage()) {
                    IMCHandler.logNotNBT(message);
                    continue;
                }
                tag = message.getNBTValue();
                if (IMCHandler.hasNotAllRequiredTags(message, tag, "Meta", 3, "Name", 8, "ColorMultiplier", 3, "DustType", 8)) continue;
                String className = tag.func_74779_i("DustType");
                if (Strings.isNullOrEmpty((String)className)) {
                    IMCHandler.logWrongNBT(message);
                    continue;
                }
                try {
                    iDustType = (IDustType)Class.forName(className).newInstance();
                }
                catch (Throwable t) {
                    IMCHandler.logWrongNBT(message);
                    continue;
                }
                BCAItemManager.dusts.addDust(tag.func_74762_e("Meta"), tag.func_74779_i("Name"), tag.func_74762_e("ColorMultiplier"), iDustType);
                continue;
            }
            if (type.equalsIgnoreCase("removeDust")) {
                if (!message.isStringMessage()) {
                    IMCHandler.logNotString(message);
                    continue;
                }
                String string = message.getStringValue();
                if (Strings.isNullOrEmpty((String)string)) {
                    IMCHandler.logError(message, "The string is null or empty!");
                    continue;
                }
                try {
                    BCAItemManager.dusts.removeDust(Integer.valueOf(string));
                }
                catch (NumberFormatException e) {
                    BCAItemManager.dusts.removeDust(string);
                }
                continue;
            }
            IMCHandler.logError(message, "Message type not supported!");
        }
    }

    private static void logNotNBT(FMLInterModComms.IMCMessage message) {
        IMCHandler.logInvalidMessage(message, "NBT");
    }

    private static void logNotItemStack(FMLInterModComms.IMCMessage message) {
        IMCHandler.logInvalidMessage(message, "ItemStack");
    }

    private static void logNotString(FMLInterModComms.IMCMessage message) {
        IMCHandler.logInvalidMessage(message, "String");
    }

    private static void logInvalidMessage(FMLInterModComms.IMCMessage message, String type) {
        IMCHandler.logError(message, "This message is not of the type '%s'!", type);
    }

    private static void logWrongNBT(FMLInterModComms.IMCMessage message) {
        IMCHandler.logError(message, "This message contains (a/an) wrong/corrupt/incomplete NBT tag(s)!");
    }

    private static void logError(FMLInterModComms.IMCMessage message, String string) {
        Logger.error(String.format("Received an invalid IMC message: '%s' from '%s'. " + string, message.key, message.getSender()));
    }

    private static void logError(FMLInterModComms.IMCMessage message, String string, Object ... args) {
        if (args != null) {
            Object[] formatArgs = new Object[args.length + 2];
            formatArgs[0] = message.key;
            formatArgs[1] = message.getSender();
            System.arraycopy(args, 0, formatArgs, 2, formatArgs.length - 2);
            IMCHandler.logError(message, String.format(string, formatArgs));
        }
    }

    private static boolean hasNotAllRequiredTags(FMLInterModComms.IMCMessage message, NBTTagCompound tag, Object ... requiredArgs) {
        boolean error = false;
        for (int i = 0; i < requiredArgs.length; ++i) {
            Object o = requiredArgs[i];
            if (o == null || !(o instanceof String)) continue;
            String tagKey = (String)o;
            Object tagType = null;
            if (i < requiredArgs.length - 1) {
                tagType = requiredArgs[i + 1];
            }
            if (tagType != null && tagType instanceof Integer) {
                int tagTypeCode = (Integer)tagType;
                if (tag.func_150297_b(tagKey, tagTypeCode)) continue;
                IMCHandler.logError(message, "Missing required NBT Tag '%s' of type %d!", tagKey, tagTypeCode);
                error = true;
                continue;
            }
            if (tag.func_74764_b(tagKey)) continue;
            IMCHandler.logError(message, "Missing required NBT Tag '%s'!", tagKey);
            error = true;
        }
        return error;
    }
}

