/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.compat.buildcraft.recipe.tool;

import buildcraft.api.recipes.IIntegrationRecipe;
import buildcraftAdditions.compat.buildcraft.recipe.tool.IKineticToolUpgrade;
import buildcraftAdditions.compat.buildcraft.recipe.tool.KineticToolStickUpgrade;
import buildcraftAdditions.compat.buildcraft.recipe.tool.KineticToolUpgrade;
import buildcraftAdditions.items.Tools.ItemKineticMultiTool;
import buildcraftAdditions.reference.ItemLoader;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class KineticToolUpgradeRecipe
implements IIntegrationRecipe {
    private final List<IKineticToolUpgrade> upgrades = new ArrayList<IKineticToolUpgrade>();

    public void register(String stickName, String inputStickOreDictName) {
        this.register(stickName, inputStickOreDictName, "NONE");
    }

    public void register(String stickName, String inputStickOreDictName, String prevStickName) {
        this.upgrades.add(new KineticToolStickUpgrade(stickName, inputStickOreDictName, prevStickName));
    }

    public void register(String upgradeName, Item upgradeItem) {
        this.register(upgradeName, new ItemStack(upgradeItem));
    }

    public void register(String upgradeName, Block upgradeBlock) {
        this.register(upgradeName, new ItemStack(upgradeBlock));
    }

    public void register(String upgradeName, ItemStack upgradeStack) {
        this.upgrades.add(new KineticToolUpgrade(upgradeName, upgradeStack));
    }

    public int getEnergyCost() {
        return 20000;
    }

    public List<ItemStack> getExampleInput() {
        ArrayList list = Lists.newArrayList();
        list.add(new ItemStack(ItemLoader.kineticMultiTool));
        return list;
    }

    public List<List<ItemStack>> getExampleExpansions() {
        ArrayList lists = Lists.newArrayList();
        ArrayList list = Lists.newArrayList();
        list.add(new ItemStack((Item)ItemLoader.goldStick));
        list.add(new ItemStack((Item)ItemLoader.toolUpgradeDrill));
        lists.add(list);
        return lists;
    }

    public List<ItemStack> getExampleOutput() {
        ArrayList list = Lists.newArrayList();
        list.add(new ItemStack(ItemLoader.kineticMultiTool));
        return list;
    }

    public boolean isValidInput(ItemStack input) {
        if (input != null && input.func_77973_b() != null && input.field_77994_a > 0 && input.func_77973_b() instanceof ItemKineticMultiTool) {
            for (IKineticToolUpgrade upgrade : this.upgrades) {
                if (!upgrade.canUpgradeBeApplied(input)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValidExpansion(ItemStack input, ItemStack expansion) {
        if (input != null && input.func_77973_b() != null && input.field_77994_a > 0 && input.func_77973_b() instanceof ItemKineticMultiTool && expansion != null && expansion.func_77973_b() != null && expansion.field_77994_a > 0) {
            for (IKineticToolUpgrade upgrade : this.upgrades) {
                if (!upgrade.canUpgradeBeApplied(input) || !upgrade.doesExpansionMatch(expansion)) continue;
                return true;
            }
        }
        return false;
    }

    public ItemStack craft(ItemStack input, List<ItemStack> expansions, boolean preview) {
        if (input == null || input.func_77973_b() == null || input.field_77994_a <= 0) {
            return null;
        }
        if (expansions.size() != 1) {
            return null;
        }
        ItemStack expansion = expansions.get(0);
        if (expansion == null || expansion.func_77973_b() == null || expansion.field_77994_a <= 0) {
            return null;
        }
        for (IKineticToolUpgrade upgrade : this.upgrades) {
            if (!upgrade.canUpgradeBeApplied(input) || !upgrade.doesExpansionMatch(expansion)) continue;
            if (!preview) {
                --expansion.field_77994_a;
            }
            ItemStack output = input.func_77946_l();
            output.field_77994_a = 1;
            upgrade.install(output);
            return output;
        }
        return null;
    }

    public int getMaximumExpansionCount(ItemStack input) {
        return 1;
    }
}

