/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.compat.buildcraft.recipe.tool;

import buildcraftAdditions.compat.buildcraft.recipe.tool.IKineticToolUpgrade;
import buildcraftAdditions.items.Tools.ItemKineticMultiTool;
import buildcraftAdditions.utils.Utils;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class KineticToolUpgrade
implements IKineticToolUpgrade {
    private final String upgradeName;
    private final ItemStack upgradeStack;

    public KineticToolUpgrade(String upgradeName, Block upgradeBlock) {
        this(upgradeName, new ItemStack(upgradeBlock));
    }

    public KineticToolUpgrade(String upgradeName, Item upgradeItem) {
        this(upgradeName, new ItemStack(upgradeItem));
    }

    public KineticToolUpgrade(String upgradeName, ItemStack upgradeStack) {
        this.upgradeName = upgradeName;
        this.upgradeStack = upgradeStack;
    }

    @Override
    public boolean canUpgradeBeApplied(ItemStack input) {
        return !ItemKineticMultiTool.isUpgradeInstalled(input, this.upgradeName) && ItemKineticMultiTool.canInstallUpgrade(input, this.upgradeName);
    }

    @Override
    public boolean doesExpansionMatch(ItemStack expansion) {
        return Utils.areItemStacksEqualRecipe(this.upgradeStack, expansion);
    }

    @Override
    public void install(ItemStack output) {
        ItemKineticMultiTool.installUpgrade(output, this.upgradeName);
    }
}

