/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.compat.buildcraft.recipe.tool;

import buildcraftAdditions.compat.buildcraft.recipe.tool.IKineticToolUpgrade;
import buildcraftAdditions.items.Tools.ItemKineticMultiTool;
import com.google.common.base.Strings;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class KineticToolStickUpgrade
implements IKineticToolUpgrade {
    private final String stickName;
    private final String inputStickOreDictName;
    private final String prevStickName;

    public KineticToolStickUpgrade(String stickName, String inputStickOreDictName) {
        this(stickName, inputStickOreDictName, "NONE");
    }

    public KineticToolStickUpgrade(String stickName, String inputStickOreDictName, String prevStickName) {
        this.stickName = stickName;
        this.inputStickOreDictName = inputStickOreDictName;
        this.prevStickName = prevStickName;
    }

    @Override
    public boolean canUpgradeBeApplied(ItemStack input) {
        return !ItemKineticMultiTool.isUpgradeInstalled(input, this.stickName) && ("NONE".equals(this.prevStickName) || ItemKineticMultiTool.isUpgradeInstalled(input, this.prevStickName));
    }

    @Override
    public boolean doesExpansionMatch(ItemStack expansion) {
        int[] oreIDs = OreDictionary.getOreIDs((ItemStack)expansion);
        if (oreIDs != null && oreIDs.length > 0) {
            for (int oreID : oreIDs) {
                String oreName = OreDictionary.getOreName((int)oreID);
                if (Strings.isNullOrEmpty((String)oreName) || !oreName.equals(this.inputStickOreDictName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void install(ItemStack output) {
        ItemKineticMultiTool.installStick(output, this.stickName);
    }
}

