/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.compat;

import buildcraftAdditions.compat.CompatModule;
import buildcraftAdditions.core.Logger;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.reflect.ClassPath;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;

public final class ModuleManager {
    private final Map<String, Object> modules = Maps.newHashMap();

    public void setupModules() {
        try {
            for (ClassPath.ClassInfo info : ClassPath.from((ClassLoader)ModuleManager.class.getClassLoader()).getTopLevelClassesRecursive(ModuleManager.class.getPackage().getName())) {
                if (!info.getSimpleName().startsWith("Compat") || info.getSimpleName().startsWith("CompatModule")) continue;
                this.registerModule(info);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unknown error while searching for modules!", e);
        }
    }

    private void registerModule(ClassPath.ClassInfo moduleClassInfo) {
        try {
            boolean enabled = true;
            Class moduleClass = moduleClassInfo.load();
            CompatModule module = moduleClass.getAnnotation(CompatModule.class);
            String id = module.id();
            String requiredMods = module.requiredMods();
            if (!Strings.isNullOrEmpty((String)requiredMods)) {
                for (String mod : requiredMods.split(",")) {
                    if (Loader.isModLoaded((String)mod)) continue;
                    enabled = false;
                    Logger.info(String.format("CompatModule '%s' is missing a dependency: '%s'! This module will not be loaded.", id, mod));
                    break;
                }
            }
            if (enabled) {
                Logger.info(String.format("CompatModule '%s' activated.", id));
                this.modules.put(id, moduleClass.newInstance());
            }
        }
        catch (Throwable t) {
            Logger.error(String.format("CompatModule '%s' failed to load: '%s'!", moduleClassInfo.getName(), t.getMessage()));
        }
    }

    public void preInit(FMLPreInitializationEvent event) {
        for (Object module : this.modules.values()) {
            this.invokeHandlers(module, event);
        }
    }

    public void init(FMLInitializationEvent event) {
        for (Object module : this.modules.values()) {
            this.invokeHandlers(module, event);
        }
    }

    public void postInit(FMLPostInitializationEvent event) {
        for (Object module : this.modules.values()) {
            this.invokeHandlers(module, event);
        }
    }

    public void doneLoadingEvent(FMLLoadCompleteEvent event) {
        for (Object module : this.modules.values()) {
            this.invokeHandlers(module, event);
        }
    }

    private void invokeHandlers(Object module, Object event) {
        for (Method method : module.getClass().getDeclaredMethods()) {
            try {
                if (method.getAnnotation(CompatModule.Handler.class) == null || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].isAssignableFrom(event.getClass())) continue;
                method.invoke(module, event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

