/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.client.render.items;

import buildcraftAdditions.items.ItemBucketBCA;
import buildcraftAdditions.utils.RenderUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.fluids.Fluid;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class BucketItemRenderer
implements IItemRenderer {
    public static final BucketItemRenderer INSTANCE = new BucketItemRenderer();

    private BucketItemRenderer() {
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type.equals((Object)IItemRenderer.ItemRenderType.ENTITY);
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (item == null || item.func_77973_b() == null || !(item.func_77973_b() instanceof ItemBucketBCA)) {
            return;
        }
        ItemBucketBCA bucket = (ItemBucketBCA)item.func_77973_b();
        Fluid fluid = null;
        boolean gaseous = false;
        if (bucket.getFluid() != null && (fluid = bucket.getFluid().getFluid()) != null && (fluid.isGaseous() || fluid.getDensity() < 0)) {
            gaseous = true;
        }
        IIcon overlay = bucket.getOverlay();
        IIcon bucketIcon = Items.field_151133_ar.func_77617_a(0);
        GL11.glPushMatrix();
        GL11.glEnable((int)3008);
        if (type.equals((Object)IItemRenderer.ItemRenderType.EQUIPPED)) {
            GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)-1.0, (double)-1.0, (double)0.0);
        } else if (type.equals((Object)IItemRenderer.ItemRenderType.ENTITY)) {
            GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
            GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glTranslated((double)-0.5, (double)-0.9, (double)0.0);
            if (item.func_82839_y()) {
                GL11.glTranslated((double)0.075, (double)0.475, (double)0.0);
                GL11.glScaled((double)0.85, (double)0.85, (double)0.85);
            }
        } else if (type.equals((Object)IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON)) {
            GL11.glTranslated((double)1.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
        }
        if (fluid != null) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(RenderUtils.MC_ITEM_SHEET);
            this.renderMask(overlay, fluid.getIcon(), type, gaseous);
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(RenderUtils.MC_ITEM_SHEET);
        if (!type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
            if (gaseous) {
                ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)bucketIcon.func_94212_f(), (float)bucketIcon.func_94206_g(), (float)bucketIcon.func_94209_e(), (float)bucketIcon.func_94210_h(), (int)bucketIcon.func_94211_a(), (int)bucketIcon.func_94216_b(), (float)0.0625f);
            } else {
                ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)bucketIcon.func_94209_e(), (float)bucketIcon.func_94210_h(), (float)bucketIcon.func_94212_f(), (float)bucketIcon.func_94206_g(), (int)bucketIcon.func_94211_a(), (int)bucketIcon.func_94216_b(), (float)0.0625f);
            }
        } else {
            this.renderIcon(bucketIcon, 0.0, gaseous);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    private void renderMask(IIcon mask, IIcon subIcon, IItemRenderer.ItemRenderType type, boolean flip) {
        if (mask == null || subIcon == null) {
            return;
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2884);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
            this.preRenderInvIcon(mask, 0.001, flip);
        } else {
            this.preRenderWorldIcon(mask, 0.001, flip);
        }
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
            this.preRenderInvIcon(mask, -0.0635, flip);
        } else {
            this.preRenderWorldIcon(mask, -0.0635, flip);
        }
        tessellator.func_78381_a();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(RenderUtils.MC_BLOCK_SHEET);
        GL11.glDepthFunc((int)514);
        GL11.glDepthMask((boolean)false);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
            this.preRenderInvIcon(subIcon, 0.001, flip);
        } else {
            this.preRenderWorldIcon(subIcon, 0.001, flip);
        }
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
            this.preRenderInvIcon(subIcon, -0.0635, flip);
        } else {
            this.preRenderWorldIcon(subIcon, -0.0635, flip);
        }
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glDepthFunc((int)515);
        GL11.glEnable((int)2884);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void preRenderInvIcon(IIcon icon, double z, boolean flip) {
        Tessellator.field_78398_a.func_78374_a(16.0, flip ? 1.0 : 0.0, z, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        Tessellator.field_78398_a.func_78374_a(0.0, flip ? 1.0 : 0.0, z, (double)icon.func_94212_f(), (double)icon.func_94210_h());
        Tessellator.field_78398_a.func_78374_a(0.0, (double)(16 + (flip ? 1 : 0)), z, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        Tessellator.field_78398_a.func_78374_a(16.0, (double)(16 + (flip ? 1 : 0)), z, (double)icon.func_94209_e(), (double)icon.func_94206_g());
    }

    private void preRenderWorldIcon(IIcon icon, double z, boolean flip) {
        Tessellator.field_78398_a.func_78374_a(1.0, 0.0, z, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        Tessellator.field_78398_a.func_78374_a(0.0, 0.0, z, (double)icon.func_94212_f(), (double)icon.func_94210_h());
        Tessellator.field_78398_a.func_78374_a(0.0, 1.0, z, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        Tessellator.field_78398_a.func_78374_a(1.0, 1.0, z, (double)icon.func_94209_e(), (double)icon.func_94206_g());
    }

    private void renderIcon(IIcon icon, double z, boolean flip) {
        Tessellator.field_78398_a.func_78382_b();
        if (flip) {
            Tessellator.field_78398_a.func_78374_a(16.0, 1.0, z, (double)icon.func_94209_e(), (double)icon.func_94210_h());
            Tessellator.field_78398_a.func_78374_a(0.0, 1.0, z, (double)icon.func_94212_f(), (double)icon.func_94210_h());
            Tessellator.field_78398_a.func_78374_a(0.0, 17.0, z, (double)icon.func_94212_f(), (double)icon.func_94206_g());
            Tessellator.field_78398_a.func_78374_a(16.0, 17.0, z, (double)icon.func_94209_e(), (double)icon.func_94206_g());
        } else {
            Tessellator.field_78398_a.func_78374_a(16.0, 0.0, z, (double)icon.func_94212_f(), (double)icon.func_94206_g());
            Tessellator.field_78398_a.func_78374_a(0.0, 0.0, z, (double)icon.func_94209_e(), (double)icon.func_94206_g());
            Tessellator.field_78398_a.func_78374_a(0.0, 16.0, z, (double)icon.func_94209_e(), (double)icon.func_94210_h());
            Tessellator.field_78398_a.func_78374_a(16.0, 16.0, z, (double)icon.func_94212_f(), (double)icon.func_94210_h());
        }
        Tessellator.field_78398_a.func_78381_a();
    }
}

