/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.client.gui.widgets;

import buildcraftAdditions.BuildcraftAdditions;
import buildcraftAdditions.client.gui.GuiBase;
import buildcraftAdditions.client.gui.widgets.WidgetBase;
import buildcraftAdditions.core.SpecialListMananger;
import buildcraftAdditions.tileEntities.Bases.TileKineticEnergyBufferBase;
import buildcraftAdditions.tileEntities.interfaces.IOwnableMachine;
import buildcraftAdditions.utils.PlayerUtils;
import buildcraftAdditions.utils.RenderUtils;
import buildcraftAdditions.utils.Utils;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public class WidgetSelfDestruct
extends WidgetBase {
    private static final ResourceLocation RED_BUTTON = new ResourceLocation("bcadditions:textures/gui/Pieces/RedButton.png");
    private static final ResourceLocation YELLOW_BUTTON = new ResourceLocation("bcadditions:textures/gui/Pieces/YellowButton.png");
    private static final ResourceLocation GREEN_BUTTON = new ResourceLocation("bcadditions:textures/gui/Pieces/GreenButton.png");
    private final boolean isOwner;
    private final String uuidString;
    private final TileKineticEnergyBufferBase keb;
    private boolean primed = false;
    private int counter;

    public WidgetSelfDestruct(int id, int x, int y, int width, int height, GuiBase gui, TileKineticEnergyBufferBase keb) {
        super(id, x, y, width, height, gui);
        this.isOwner = PlayerUtils.playerMatches((IOwnableMachine)keb, BuildcraftAdditions.proxy.getClientPlayer());
        this.uuidString = PlayerUtils.getPlayerUUIDString(BuildcraftAdditions.proxy.getClientPlayer());
        this.keb = keb;
        this.counter = 80;
    }

    @Override
    public void render(int mouseX, int mouseY) {
        ResourceLocation button = RED_BUTTON;
        if (this.primed) {
            if (this.counter < 40) {
                button = SpecialListMananger.greenButtonList.contains(this.uuidString) ? GREEN_BUTTON : YELLOW_BUTTON;
            }
            if (this.counter <= 0) {
                this.counter = 80;
            }
            --this.counter;
        }
        RenderUtils.drawImage(button, this.x, this.y, this.width, this.height);
    }

    @Override
    public void onWidgetClicked(int x, int y, int button) {
        if (!this.isOwner) {
            return;
        }
        if (!this.primed) {
            this.primed = true;
        } else {
            this.keb.activateSelfDestruct();
        }
    }

    @Override
    public void addTooltip(int mouseX, int mouseY, List<String> list, boolean shift) {
        if (this.primed) {
            if (SpecialListMananger.specialTexts.containsKey(this.uuidString)) {
                list.add(SpecialListMananger.specialTexts.get(this.uuidString) + "!!!");
            } else {
                list.add(Utils.localize("gui.keb.pressForBoom"));
            }
        } else if (SpecialListMananger.specialTexts.containsKey(this.uuidString)) {
            list.add(SpecialListMananger.specialTexts.get(this.uuidString) + "?");
        } else {
            list.add(Utils.localize("gui.keb.dangerousButton"));
            list.add(Utils.localize("gui.keb.noPushing"));
        }
    }
}

