/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.client.gui.widgets;

import buildcraftAdditions.client.gui.GuiBase;
import buildcraftAdditions.client.gui.widgets.WidgetBase;
import buildcraftAdditions.utils.RenderUtils;
import buildcraftAdditions.utils.Utils;
import buildcraftAdditions.utils.fluids.Tank;
import java.util.List;
import net.minecraft.item.EnumRarity;
import net.minecraft.util.ResourceLocation;

public class WidgetFluidTank
extends WidgetBase {
    private static final ResourceLocation texture = new ResourceLocation("bcadditions:textures/gui/Pieces/tankStripes.png");
    private final Tank tank;

    public WidgetFluidTank(int id, int x, int y, int width, int height, GuiBase gui, Tank tank) {
        super(id, x, y, 0, 0, width, height, gui, "");
        this.setEnableClockSound(false);
        this.tank = tank;
    }

    @Override
    public void render(int mouseX, int mouseY) {
        if (this.tank.getFluidAmount() > 0) {
            RenderUtils.drawFluid(this.tank.getFluid(), (int)((float)this.tank.getFluidAmount() / (float)this.tank.getCapacity() * (float)this.height), this.x, this.y, this.width, this.height);
        }
        RenderUtils.drawImage(texture, this.x, this.y + this.height / 10, this.width, this.height - this.height / 5);
    }

    @Override
    public void addTooltip(int mouseX, int mouseY, List<String> tooltips, boolean shift) {
        if (this.tank.getFluid() != null && this.tank.getFluidType() != null) {
            EnumRarity r = this.tank.getFluidType().getRarity(this.tank.getFluid());
            tooltips.add((r != null && r.field_77937_e != null ? r.field_77937_e : EnumRarity.common.field_77937_e) + this.tank.getFluid().getLocalizedName());
        } else {
            tooltips.add(Utils.localize("gui.empty"));
        }
        tooltips.add(Utils.localizeFormatted("fluids.info", this.tank.getFluidAmount(), this.tank.getCapacity()));
    }
}

