/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.client.gui.widgets;

import buildcraftAdditions.client.gui.GuiBase;
import java.awt.Rectangle;
import java.util.List;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class WidgetBase {
    public final int id;
    public final int x;
    public final int y;
    public final int width;
    public final int height;
    public final int u;
    public final int v;
    public final GuiBase gui;
    public final ResourceLocation[] textures;
    public int textureIndex = 0;
    public int value = 0;
    public boolean enabled = true;
    public boolean playSound = true;

    public WidgetBase(int id, int x, int y, int u, int v, int width, int height, GuiBase gui, String ... textures) {
        this.id = id;
        this.x = x;
        this.y = y;
        this.u = u;
        this.v = v;
        this.width = width;
        this.height = height;
        this.gui = gui;
        this.textures = new ResourceLocation[textures.length];
        for (int i = 0; i < textures.length; ++i) {
            this.textures[i] = new ResourceLocation(textures[i]);
        }
    }

    public WidgetBase(int id, int x, int y, int u, int v, int width, int height, GuiBase gui, ResourceLocation ... textures) {
        this.id = id;
        this.x = x;
        this.y = y;
        this.u = u;
        this.v = v;
        this.width = width;
        this.height = height;
        this.gui = gui;
        this.textures = textures;
    }

    public WidgetBase(int id, int x, int y, int u, int v, int width, int height, GuiBase gui, int value, ResourceLocation ... textures) {
        this(id, x, y, u, v, width, height, gui, textures);
        this.value = value;
    }

    public WidgetBase(int id, int x, int y, int u, int v, int width, int height, GuiBase gui, int value, String ... textures) {
        this(id, x, y, u, v, width, height, gui, textures);
        this.value = value;
    }

    public WidgetBase(int id, int x, int y, int width, int height, GuiBase gui) {
        this(id, x, y, 0, 0, width, height, gui, "");
    }

    public WidgetBase setEnableClockSound(boolean value) {
        this.playSound = value;
        return this;
    }

    public void render(int mouseX, int mouseY) {
        float shade = this.enabled ? 1.0f : 0.2f;
        GL11.glColor4f((float)shade, (float)shade, (float)shade, (float)shade);
        if (this.textures[this.textureIndex] != null) {
            this.gui.bindTexture(this.textures[this.textureIndex]);
        }
        this.gui.func_73729_b(this.x, this.y, this.u, this.v, this.width, this.height);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void onWidgetClicked(int x, int y, int button) {
        if (this.playSound) {
            this.gui.soundHandler().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
        }
        this.gui.widgetActionPerformed(this);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void addTooltip(int mouseX, int mouseY, List<String> tooltips, boolean shift) {
    }
}

