/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.client.gui;

import buildcraftAdditions.client.gui.GuiBase;
import buildcraftAdditions.client.gui.widgets.WidgetFluidTank;
import buildcraftAdditions.inventories.containers.ContainerRefinery;
import buildcraftAdditions.tileEntities.TileRefinery;
import buildcraftAdditions.utils.Utils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class GuiRefinery
extends GuiBase {
    private static final ResourceLocation texture = new ResourceLocation("bcadditions:textures/gui/guiRefinery.png");
    private final TileRefinery refinery;

    public GuiRefinery(EntityPlayer player, TileRefinery refinery) {
        super(new ContainerRefinery(player, refinery));
        this.setTitleXOffset(70);
        this.setTitleYOffset(3);
        this.refinery = refinery;
    }

    @Override
    public ResourceLocation texture() {
        return texture;
    }

    @Override
    public int getXSize() {
        return 186;
    }

    @Override
    public int getYSize() {
        return 186;
    }

    @Override
    public String getInventoryName() {
        return "refinery";
    }

    @Override
    public void drawBackgroundPostWidgets(float f, int x, int y) {
        this.func_73729_b(this.field_147003_i + 53, this.field_147009_r + 150, 0, 186, 80, 7);
        this.func_73729_b(this.field_147003_i + 59, this.field_147009_r + 151, 6, 198, this.refinery.currentHeat * 68 / (this.refinery.lastRequiredHeat + 1), 5);
        this.func_73729_b(this.field_147003_i + 59, this.field_147009_r + 151, 6, 193, 80, 5);
    }

    @Override
    public void drawForegroundExtra(int x, int y) {
        this.drawString(Utils.localize("gui.heat") + ": " + this.refinery.currentHeat, 45, 80);
        this.drawString(Utils.localize("gui.requiredHeat") + ": " + this.refinery.requiredHeat, 45, 90);
        this.drawString(Utils.localize("gui.powerUsage") + ": " + this.refinery.energyCost, 45, 100);
    }

    @Override
    public void initialize() {
        this.addWidget(new WidgetFluidTank(0, this.field_147003_i + 22, this.field_147009_r + 65, 16, 52, this, this.refinery.getTanks()[0]));
        this.addWidget(new WidgetFluidTank(1, this.field_147003_i + 148, this.field_147009_r + 65, 16, 52, this, this.refinery.getTanks()[1]));
    }
}

