/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.client.gui;

import buildcraftAdditions.client.gui.GuiBase;
import buildcraftAdditions.client.gui.widgets.WidgetBase;
import buildcraftAdditions.client.gui.widgets.WidgetButtonText;
import buildcraftAdditions.client.gui.widgets.WidgetButtonUpdate;
import buildcraftAdditions.inventories.containers.ContainerPipeColoringTool;
import buildcraftAdditions.networking.MessagePipeColoringTool;
import buildcraftAdditions.networking.PacketHandler;
import buildcraftAdditions.reference.ItemLoader;
import buildcraftAdditions.utils.RenderUtils;
import buildcraftAdditions.utils.Utils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class GuiPipeColoringTool
extends GuiBase {
    public static final ResourceLocation TEXTURE = new ResourceLocation("bcadditions", "textures/gui/guiPipeColoringTool.png");
    public boolean sortMode = false;
    private int activeWidget;

    public GuiPipeColoringTool(ItemStack stack) {
        super(new ContainerPipeColoringTool());
        this.activeWidget = stack.func_77960_j();
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("SortMode")) {
            this.sortMode = stack.func_77978_p().func_74767_n("SortMode");
        }
    }

    @Override
    public ResourceLocation texture() {
        return TEXTURE;
    }

    @Override
    public int getXSize() {
        return 198;
    }

    @Override
    public int getYSize() {
        return 99;
    }

    @Override
    public String getInventoryName() {
        return "pipeColorTool";
    }

    @Override
    public void initialize() {
        for (int i = 0; i < 16; ++i) {
            this.addWidget(new PaintWidget(i, this.field_147003_i + 18 + i * 20 - (i > 7 ? 160 : 0), this.field_147009_r + (i > 7 ? 37 : 17), 176, 0, 20, 20, this));
        }
        ((PaintWidget)this.widgets.get(this.activeWidget)).setActive(true);
        this.addWidget(new WidgetButtonText(16, this.field_147003_i + 90, this.field_147009_r + 63, 80, 15, this){

            @Override
            public void addTooltip(int mouseX, int mouseY, List<String> tooltips, boolean shift) {
                if (!((GuiPipeColoringTool)this.gui).sortMode) {
                    tooltips.add(Utils.localize("tooltip.colorNormalMode") + ":");
                    tooltips.add(Utils.localize("tooltip.colorNormalMode.info"));
                } else {
                    tooltips.add(Utils.localize("tooltip.colorSortingMode") + ":");
                    tooltips.add(Utils.localize("tooltip.colorSortingMode.info"));
                }
            }
        });
        this.updateTextButton();
    }

    @Override
    public void drawForegroundExtra(int x, int y) {
        this.drawString(Utils.localize("gui.coloringMode") + ":", this.titleXoffset + 9, 67);
    }

    @Override
    public void widgetActionPerformed(WidgetBase widget) {
        if (widget.id >= 0 && widget.id < 16) {
            ((PaintWidget)this.widgets.get(this.activeWidget)).setActive(false);
            this.activeWidget = widget.id;
        } else if (widget.id == 16) {
            this.sortMode = !this.sortMode;
            this.updateTextButton();
        }
        PacketHandler.instance.sendToServer((IMessage)new MessagePipeColoringTool((byte)widget.id, this.sortMode));
    }

    public void updateTextButton() {
        if (this.sortMode) {
            ((WidgetButtonText)this.widgets.get(16)).setText(Utils.localize("gui.colorSortingMode"));
        } else {
            ((WidgetButtonText)this.widgets.get(16)).setText(Utils.localize("gui.colorNormalMode"));
        }
    }

    public static class PaintWidget
    extends WidgetButtonUpdate {
        private static final ResourceLocation ACTIVE = new ResourceLocation("bcadditions:textures/gui/Pieces/ButtonActive.png");
        private static final ResourceLocation INACTIVE = new ResourceLocation("bcadditions:textures/gui/Pieces/ButtonInactive.png");

        public PaintWidget(int id, int x, int y, int u, int v, int width, int height, GuiBase gui) {
            super(id, x, y, u, v, width, height, gui);
        }

        @Override
        public void render(int mouseX, int mouseY) {
            RenderUtils.drawImage(this.active ? ACTIVE : INACTIVE, this.x, this.y, this.width, this.height);
            this.gui.bindTexture(RenderUtils.MC_ITEM_SHEET);
            this.gui.func_94065_a(this.x + 2, this.y + 2, ItemLoader.pipeColoringTool.func_77617_a(this.id), 16, 16);
        }

        @Override
        public void addTooltip(int mouseX, int mouseY, List<String> tooltips, boolean shift) {
            tooltips.add(Utils.localize("gui.color." + Utils.COLOR_NAMES[this.id]));
        }
    }
}

