/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.client.gui;

import buildcraftAdditions.api.configurableOutput.IConfigurableOutput;
import buildcraftAdditions.client.gui.GuiBase;
import buildcraftAdditions.client.gui.widgets.WidgetBase;
import buildcraftAdditions.client.gui.widgets.WidgetButtonText;
import buildcraftAdditions.client.gui.widgets.WidgetImage;
import buildcraftAdditions.inventories.containers.ContainerMachineConfigurator;
import buildcraftAdditions.networking.MessageConfiguration;
import buildcraftAdditions.networking.PacketHandler;
import buildcraftAdditions.reference.enums.EnumMachineUpgrades;
import buildcraftAdditions.tileEntities.interfaces.IUpgradableMachine;
import buildcraftAdditions.utils.Utils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

@SideOnly(value=Side.CLIENT)
public class GuiMachineConfigurator
extends GuiBase {
    private static final ResourceLocation texture = new ResourceLocation("bcadditions:textures/gui/guiMachineConfigurator.png");
    private final IConfigurableOutput configurableOutput;
    private final IUpgradableMachine upgradableMachine;
    private final boolean configurable;
    private final boolean upgradable;
    private WidgetButtonText northConfiguration;
    private WidgetButtonText eastConfiguration;
    private WidgetButtonText southConfiguration;
    private WidgetButtonText westConfiguration;
    private WidgetButtonText upConfiguration;
    private WidgetButtonText downConfiguration;
    private WidgetButtonText northPriority;
    private WidgetButtonText eastPriority;
    private WidgetButtonText southPriority;
    private WidgetButtonText westPriority;
    private WidgetButtonText upPriority;
    private WidgetButtonText downPriority;
    private WidgetButtonText toggleMode;
    private WidgetImage[] upgrades;
    private boolean configurationMode;

    public GuiMachineConfigurator(EntityPlayer player, TileEntity entity) {
        super(new ContainerMachineConfigurator(player, entity));
        if (entity instanceof IConfigurableOutput) {
            this.configurableOutput = (IConfigurableOutput)entity;
            this.configurable = true;
        } else {
            this.configurableOutput = null;
            this.configurable = false;
        }
        if (entity instanceof IUpgradableMachine) {
            this.upgradableMachine = (IUpgradableMachine)entity;
            this.upgradable = true;
        } else {
            this.upgradableMachine = null;
            this.upgradable = false;
        }
        this.configurationMode = this.configurable;
        this.setCenterTitle(true);
    }

    @Override
    public ResourceLocation texture() {
        return texture;
    }

    @Override
    public int getXSize() {
        return 224;
    }

    @Override
    public int getYSize() {
        return 165;
    }

    @Override
    public String getInventoryName() {
        return "machineConfigurator";
    }

    @Override
    public void initialize() {
        this.toggleMode = new WidgetButtonText(30, this.field_147003_i + 40, this.field_147009_r + 145, 140, 15, this).setText(this.configurationMode ? Utils.localize("gui.configureIO") : Utils.localize("gui.showUpgrades"));
        if (this.configurationMode) {
            this.northConfiguration = new WidgetButtonText(2, this.field_147003_i + 45, this.field_147009_r + 26, 60, 15, this);
            this.eastConfiguration = new WidgetButtonText(5, this.field_147003_i + 45, this.field_147009_r + 46, 60, 15, this);
            this.southConfiguration = new WidgetButtonText(3, this.field_147003_i + 45, this.field_147009_r + 66, 60, 15, this);
            this.westConfiguration = new WidgetButtonText(4, this.field_147003_i + 45, this.field_147009_r + 86, 60, 15, this);
            this.upConfiguration = new WidgetButtonText(1, this.field_147003_i + 45, this.field_147009_r + 106, 60, 15, this);
            this.downConfiguration = new WidgetButtonText(0, this.field_147003_i + 45, this.field_147009_r + 126, 60, 15, this);
            this.northPriority = new WidgetButtonText(8, this.field_147003_i + 158, this.field_147009_r + 26, 62, 15, this);
            this.eastPriority = new WidgetButtonText(11, this.field_147003_i + 158, this.field_147009_r + 46, 62, 15, this);
            this.southPriority = new WidgetButtonText(9, this.field_147003_i + 158, this.field_147009_r + 66, 62, 15, this);
            this.westPriority = new WidgetButtonText(10, this.field_147003_i + 158, this.field_147009_r + 86, 62, 15, this);
            this.upPriority = new WidgetButtonText(7, this.field_147003_i + 158, this.field_147009_r + 106, 62, 15, this);
            this.downPriority = new WidgetButtonText(6, this.field_147003_i + 158, this.field_147009_r + 126, 62, 15, this);
            this.addWidget(this.downConfiguration);
            this.addWidget(this.upConfiguration);
            this.addWidget(this.northConfiguration);
            this.addWidget(this.southConfiguration);
            this.addWidget(this.westConfiguration);
            this.addWidget(this.eastConfiguration);
            this.addWidget(this.downPriority);
            this.addWidget(this.upPriority);
            this.addWidget(this.northPriority);
            this.addWidget(this.southPriority);
            this.addWidget(this.westPriority);
            this.addWidget(this.eastPriority);
        } else {
            int t = 1;
            for (EnumMachineUpgrades upgrade : this.upgradableMachine.getInstalledUpgrades()) {
                this.addWidget(new WidgetImage(14 + t, this.field_147003_i + 25 * t, this.field_147009_r + 50, 20, 20, this, upgrade.getTexture(), Utils.localize("item.upgrade." + upgrade.getTag() + ".name")));
                ++t;
            }
        }
        if (this.upgradable && this.configurable) {
            this.addWidget(this.toggleMode);
        }
        this.updateButtons();
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        super.func_146976_a(f, x, y);
        if (this.configurationMode) {
            this.drawString(Utils.localize("gui.north") + ":", this.field_147003_i + 10, this.field_147009_r + 30);
            this.drawString(Utils.localize("gui.east") + ": ", this.field_147003_i + 10, this.field_147009_r + 50);
            this.drawString(Utils.localize("gui.south") + ": ", this.field_147003_i + 10, this.field_147009_r + 70);
            this.drawString(Utils.localize("gui.west") + ": ", this.field_147003_i + 10, this.field_147009_r + 90);
            this.drawString(Utils.localize("gui.up") + ": ", this.field_147003_i + 10, this.field_147009_r + 110);
            this.drawString(Utils.localize("gui.down") + ": ", this.field_147003_i + 10, this.field_147009_r + 130);
            if (this.configurableOutput.getStatus(ForgeDirection.NORTH).hasPriority()) {
                this.drawString(Utils.localize("gui.priority") + ": ", this.field_147003_i + 110, this.field_147009_r + 30);
            }
            if (this.configurableOutput.getStatus(ForgeDirection.EAST).hasPriority()) {
                this.drawString(Utils.localize("gui.priority") + ": ", this.field_147003_i + 110, this.field_147009_r + 50);
            }
            if (this.configurableOutput.getStatus(ForgeDirection.SOUTH).hasPriority()) {
                this.drawString(Utils.localize("gui.priority") + ": ", this.field_147003_i + 110, this.field_147009_r + 70);
            }
            if (this.configurableOutput.getStatus(ForgeDirection.WEST).hasPriority()) {
                this.drawString(Utils.localize("gui.priority") + ": ", this.field_147003_i + 110, this.field_147009_r + 90);
            }
            if (this.configurableOutput.getStatus(ForgeDirection.UP).hasPriority()) {
                this.drawString(Utils.localize("gui.priority") + ": ", this.field_147003_i + 110, this.field_147009_r + 110);
            }
            if (this.configurableOutput.getStatus(ForgeDirection.DOWN).hasPriority()) {
                this.drawString(Utils.localize("gui.priority") + ": ", this.field_147003_i + 110, this.field_147009_r + 130);
            }
        } else {
            this.drawString(Utils.localize("gui.installedUpgrades"), this.field_147003_i + 20, this.field_147009_r + 25);
        }
    }

    @Override
    public void widgetActionPerformed(WidgetBase widget) {
        if (widget.id < 6) {
            this.configurableOutput.changeStatus(ForgeDirection.getOrientation((int)widget.id));
        } else if (widget.id < 14) {
            this.configurableOutput.changePriority(ForgeDirection.getOrientation((int)(widget.id - 6)));
        } else if (widget.id == 30) {
            boolean bl = this.configurationMode = !this.configurationMode;
        }
        if (this.configurableOutput != null) {
            PacketHandler.instance.sendToServer((IMessage)new MessageConfiguration(this.configurableOutput));
        }
    }

    @Override
    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        this.redraw();
        this.updateButtons();
    }

    private void updateButtons() {
        if (!this.configurationMode) {
            return;
        }
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            WidgetButtonText button = (WidgetButtonText)this.widgets.get(direction.ordinal());
            button.setText(this.configurableOutput.getStatus(direction).getName());
            button.setColor(this.configurableOutput.getStatus(direction).getColor());
            button = (WidgetButtonText)this.widgets.get(direction.ordinal() + 6);
            button.setText(this.configurableOutput.getPriority(direction).getName());
            button.setColor(this.configurableOutput.getPriority(direction).getColor());
            button.setShouldRender(this.configurableOutput.getStatus(direction).hasPriority());
        }
    }
}

