/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.client.gui;

import buildcraftAdditions.client.gui.GuiBase;
import buildcraftAdditions.client.gui.widgets.WidgetFluidTank;
import buildcraftAdditions.inventories.containers.ContainerCoolingTower;
import buildcraftAdditions.tileEntities.TileCoolingTower;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class GuiCoolingTower
extends GuiBase {
    public static final ResourceLocation texture = new ResourceLocation("bcadditions:textures/gui/guiCoolingTower.png");
    private final TileCoolingTower tower;

    public GuiCoolingTower(EntityPlayer player, TileCoolingTower tower) {
        super(new ContainerCoolingTower(player, tower));
        this.tower = tower;
        this.setTitleXOffset(70);
        this.setTitleYOffset(3);
        this.setCenterTitle(true);
    }

    @Override
    public void drawBackgroundPostWidgets(float f, int x, int y) {
        int width = (int)(this.tower.heat * 68.0f) / 80;
        this.func_73729_b(this.field_147003_i + 53, this.field_147009_r + 84, 0, 186, 80, 7);
        this.func_73729_b(this.field_147003_i + 59, this.field_147009_r + 85, 6, 198, width, 5);
        this.func_73729_b(this.field_147003_i + 59, this.field_147009_r + 85, 6, 193, 80, 5);
    }

    @Override
    public void drawForegroundExtra(int x, int y) {
        this.drawString("Heat: " + Math.round(this.tower.heat), 50, 60);
    }

    @Override
    public ResourceLocation texture() {
        return texture;
    }

    @Override
    public int getXSize() {
        return 186;
    }

    @Override
    public int getYSize() {
        return 186;
    }

    @Override
    public String getInventoryName() {
        return "coolingTower";
    }

    @Override
    public void initialize() {
        this.addWidget(new WidgetFluidTank(0, this.field_147003_i + 22, this.field_147009_r + 65, 16, 52, this, this.tower.getTanks()[0]));
        this.addWidget(new WidgetFluidTank(1, this.field_147003_i + 148, this.field_147009_r + 65, 16, 52, this, this.tower.getTanks()[1]));
        this.addWidget(new WidgetFluidTank(2, this.field_147003_i + 85, this.field_147009_r + 108, 16, 52, this, this.tower.getTanks()[2]));
    }
}

