/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.client.gui;

import buildcraftAdditions.client.gui.widgets.WidgetBase;
import buildcraftAdditions.utils.RenderUtils;
import buildcraftAdditions.utils.Utils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class GuiBase
extends GuiContainer {
    public static final ResourceLocation PLAYER_INV_TEXTURE = new ResourceLocation("bcadditions:textures/gui/guiPlayerInv.png");
    public final List<WidgetBase> widgets = new ArrayList<WidgetBase>();
    public final int xSizePlayerInv = 176;
    public final int ySizePlayerInv = 100;
    private final ResourceLocation texture = this.texture();
    public int titleXoffset = 5;
    public int titleYoffset = 8;
    public boolean shouldDrawWidgets = true;
    public int textColor = 14977;
    public boolean centerTitle = true;
    public int tileGuiYSize = 0;
    private boolean drawPlayerInv = false;

    public GuiBase(Container container) {
        super(container);
        this.field_146999_f = this.getXSize();
        this.field_147000_g = this.getYSize();
        this.tileGuiYSize = this.getYSize();
    }

    public GuiBase setDrawPlayerInv(boolean draw) {
        this.drawPlayerInv = draw;
        if (draw) {
            this.field_147000_g = this.getYSize() + 100;
        }
        return this;
    }

    public GuiBase setTitleXOffset(int offset) {
        this.titleXoffset = offset;
        return this;
    }

    public GuiBase setTitleYOffset(int offset) {
        this.titleYoffset = offset;
        return this;
    }

    public GuiBase setTextColor(int color) {
        this.textColor = color;
        return this;
    }

    public GuiBase setCenterTitle(boolean value) {
        this.centerTitle = value;
        return this;
    }

    public GuiBase setDrawWidgets(boolean value) {
        this.shouldDrawWidgets = value;
        return this;
    }

    public abstract ResourceLocation texture();

    public abstract int getXSize();

    public abstract int getYSize();

    public abstract String getInventoryName();

    public abstract void initialize();

    public SoundHandler soundHandler() {
        return Minecraft.func_71410_x().func_147118_V();
    }

    public void bindTexture(ResourceLocation texture) {
        RenderUtils.bindTexture(texture);
    }

    public void drawString(String text, int x, int y) {
        this.drawString(text, x, y, this.textColor);
    }

    public void drawString(String text, int x, int y, int color) {
        this.field_146289_q.func_78276_b(text, x, y, color);
    }

    public void widgetActionPerformed(WidgetBase widget) {
    }

    public boolean hasCustomName() {
        return false;
    }

    public String getCustomName() {
        return null;
    }

    public void addWidget(WidgetBase widget) {
        this.widgets.add(widget);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.drawPlayerInv) {
            this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        }
        this.initialize();
    }

    protected void func_146976_a(float f, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture(this.texture());
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.tileGuiYSize);
        if (this.drawPlayerInv) {
            this.bindTexture(PLAYER_INV_TEXTURE);
            this.func_73729_b(this.field_147003_i, this.field_147009_r + this.tileGuiYSize, 0, 0, 176, 100);
        }
        this.bindTexture(this.texture());
        this.drawBackgroundPreWidgets(f, x, y);
        if (this.shouldDrawWidgets) {
            this.drawWidgets(x, y);
        }
        this.bindTexture(this.texture());
        this.drawBackgroundPostWidgets(f, x, y);
    }

    public void drawBackgroundPreWidgets(float f, int x, int y) {
    }

    public void drawBackgroundPostWidgets(float f, int x, int y) {
    }

    protected void drawWidgets(int x, int y) {
        for (WidgetBase widget : this.widgets) {
            widget.render(x, y);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    protected void func_146979_b(int x, int y) {
        if (this.drawPlayerInv) {
            this.drawString(Utils.localize("container.inventory"), 8, this.tileGuiYSize + 6, this.textColor);
        }
        String name = this.hasCustomName() && this.getCustomName() != null ? this.getCustomName() : Utils.localize(String.format("gui.%s.name", this.getInventoryName()));
        this.drawString(name, this.centerTitle ? (int)((double)(this.getXSize() / 2) - (double)name.length() * 2.5) : this.titleXoffset, this.titleYoffset, this.textColor);
        this.drawForegroundExtra(x, y);
    }

    public void drawForegroundExtra(int x, int y) {
    }

    public void func_146280_a(Minecraft minecraft, int width, int height) {
        this.widgets.clear();
        super.func_146280_a(minecraft, width, height);
    }

    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        for (WidgetBase widget : this.widgets) {
            if (!widget.getBounds().contains(x, y) || !widget.enabled) continue;
            widget.onWidgetClicked(x, y, button);
        }
    }

    public void func_73863_a(int x, int y, float f) {
        super.func_73863_a(x, y, f);
        ArrayList<String> tooltips = new ArrayList<String>();
        for (WidgetBase widget : this.widgets) {
            if (!widget.getBounds().contains(x, y)) continue;
            widget.addTooltip(x, y, tooltips, GuiBase.func_146272_n());
        }
        if (!tooltips.isEmpty()) {
            ArrayList finalLines = new ArrayList();
            for (String line : tooltips) {
                String[] lines = WordUtils.wrap((String)line, (int)30).split(System.getProperty("line.separator"));
                Collections.addAll(finalLines, lines);
            }
            this.drawHoveringText(finalLines, x, y, this.field_146289_q);
        }
    }

    public void redraw() {
        this.widgets.clear();
        this.field_146292_n.clear();
        this.initialize();
    }

    public int guiLeft() {
        return this.field_147003_i;
    }

    public int guiTop() {
        return this.field_147009_r;
    }
}

