/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.blocks;

import buildcraftAdditions.blocks.BlockBase;
import buildcraftAdditions.reference.Variables;
import buildcraftAdditions.utils.RenderUtils;
import buildcraftAdditions.utils.Utils;
import com.google.common.base.Strings;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockRotationBase
extends BlockBase {
    protected final String textureBaseName;
    private final boolean leftRight;
    private IIcon front;
    private IIcon bottom;
    private IIcon top;
    private IIcon back;
    private IIcon sides;
    private IIcon left;
    private IIcon right;

    public BlockRotationBase(String name, String textureBaseName, boolean leftRight) {
        this(name, textureBaseName, leftRight, name);
    }

    public BlockRotationBase(String name, String textureBaseName, boolean leftRight, String gameRegistryName) {
        super(name, "", gameRegistryName);
        this.textureBaseName = textureBaseName;
        this.leftRight = leftRight;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        world.func_72921_c(x, y, z, Utils.get2dOrientation(entity).getOpposite().ordinal(), 3);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta == 0 && side == 3) {
            return this.front;
        }
        if (side == meta && meta > 1) {
            return this.front;
        }
        if (side == ForgeDirection.getOrientation((int)meta).getOpposite().ordinal()) {
            return this.back;
        }
        switch (side) {
            case 0: {
                return this.bottom;
            }
            case 1: {
                return this.top;
            }
            case 3: {
                if (ForgeDirection.getOrientation((int)meta) == ForgeDirection.WEST) {
                    return this.leftRight ? this.left : this.sides;
                }
                return this.leftRight ? this.right : this.sides;
            }
            case 5: {
                if (ForgeDirection.getOrientation((int)meta) == ForgeDirection.SOUTH) {
                    return this.leftRight ? this.left : this.sides;
                }
                return this.leftRight ? this.right : this.sides;
            }
            case 2: {
                if (ForgeDirection.getOrientation((int)meta) == ForgeDirection.WEST) {
                    return this.leftRight ? this.right : this.sides;
                }
                return this.leftRight ? this.left : this.sides;
            }
            case 4: {
                if (ForgeDirection.getOrientation((int)meta) == ForgeDirection.SOUTH) {
                    return this.leftRight ? this.right : this.sides;
                }
                return this.leftRight ? this.left : this.sides;
            }
        }
        return this.sides;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        if (Strings.isNullOrEmpty((String)this.textureBaseName)) {
            return;
        }
        this.front = RenderUtils.registerIcon(register, this.textureBaseName + "Front");
        this.back = RenderUtils.registerIcon(register, this.textureBaseName + "Back");
        if (this.leftRight) {
            this.left = RenderUtils.registerIcon(register, this.textureBaseName + "Left");
            this.right = RenderUtils.registerIcon(register, this.textureBaseName + "Right");
        } else {
            this.sides = RenderUtils.registerIcon(register, this.textureBaseName + "Sides");
        }
        this.top = RenderUtils.registerIcon(register, this.textureBaseName + "Top");
        this.bottom = RenderUtils.registerIcon(register, this.textureBaseName + "Bottom");
    }

    public int func_149645_b() {
        return Variables.RenderIDs.SIDED_TEXTURES_RENDER_ID;
    }
}

