/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.blocks;

import buildcraft.api.tools.IToolWrench;
import buildcraftAdditions.BuildcraftAdditions;
import buildcraftAdditions.blocks.BlockBase;
import buildcraftAdditions.reference.Variables;
import buildcraftAdditions.tileEntities.TileItemSorter;
import buildcraftAdditions.utils.RenderUtils;
import buildcraftAdditions.utils.Utils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockItemSorter
extends BlockBase {
    @SideOnly(value=Side.CLIENT)
    private IIcon textureIn;
    @SideOnly(value=Side.CLIENT)
    private IIcon textureOut;
    @SideOnly(value=Side.CLIENT)
    private IIcon textureSide;
    @SideOnly(value=Side.CLIENT)
    private IIcon textureSide2;

    public BlockItemSorter() {
        super("blockItemSorter");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.textureSide = RenderUtils.registerIcon(register, "sorter/Side");
        this.textureSide2 = RenderUtils.registerIcon(register, "sorter/Side2");
        this.textureIn = RenderUtils.registerIcon(register, "sorter/In");
        this.textureOut = RenderUtils.registerIcon(register, "sorter/Out");
    }

    public int func_149645_b() {
        return Variables.RenderIDs.SORTER;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        ForgeDirection direction = ForgeDirection.getOrientation((int)meta);
        if (side == direction.ordinal()) {
            return this.textureOut;
        }
        if (side == direction.getOpposite().ordinal()) {
            return this.textureIn;
        }
        if (!(direction.ordinal() != 0 && direction.getOpposite().ordinal() != 0 || side != 2 && side != 3)) {
            return this.textureSide2;
        }
        if (!(direction.ordinal() != 2 && direction.getOpposite().ordinal() != 2 || side != 4 && side != 5)) {
            return this.textureSide2;
        }
        if (!(direction.ordinal() != 4 && direction.getOpposite().ordinal() != 4 || side != 2 && side != 3)) {
            return this.textureSide2;
        }
        return this.textureSide;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        ForgeDirection orientation = Utils.get3dOrientation(entity).getOpposite();
        world.func_72921_c(x, y, z, orientation.ordinal(), 3);
        this.getSorterTile(world, x, y, z).setRotation(orientation);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        Item equipped;
        if (player.func_70093_af()) {
            return false;
        }
        Item item = equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
        if (equipped != null && equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(player, x, y, z)) {
            this.getSorterTile(world, x, y, z).setRotation(ForgeDirection.getOrientation((int)this.rotate(world.func_72805_g(x, y, z))));
            ((IToolWrench)equipped).wrenchUsed(player, x, y, z);
            return true;
        }
        if (!world.field_72995_K) {
            player.openGui((Object)BuildcraftAdditions.instance, Variables.Gui.ITEM_SORTER.ordinal(), world, x, y, z);
        }
        return true;
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileItemSorter) {
            TileItemSorter tile = (TileItemSorter)te;
            tile.func_70295_k_();
            ItemStack stack = tile.func_70301_a(0);
            if (stack != null) {
                tile.func_70299_a(0, null);
                Utils.dropItemstack(world, x, y, z, stack);
            }
            tile.func_70305_f();
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileItemSorter();
    }

    protected TileItemSorter getSorterTile(World world, int x, int y, int z) {
        return (TileItemSorter)world.func_147438_o(x, y, z);
    }

    protected int rotate(int meta) {
        int rotatedMeta = meta + 1;
        if (rotatedMeta > 5) {
            rotatedMeta = 0;
        }
        return rotatedMeta;
    }
}

