/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.blocks;

import buildcraftAdditions.BuildcraftAdditions;
import buildcraftAdditions.blocks.BlockBase;
import buildcraftAdditions.reference.Variables;
import buildcraftAdditions.tileEntities.TileHeatedFurnace;
import buildcraftAdditions.utils.RenderUtils;
import buildcraftAdditions.utils.Utils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockHeatedFurnace
extends BlockBase {
    @SideOnly(value=Side.CLIENT)
    private IIcon front;
    @SideOnly(value=Side.CLIENT)
    private IIcon back;
    @SideOnly(value=Side.CLIENT)
    private IIcon sides;
    @SideOnly(value=Side.CLIENT)
    private IIcon top;
    @SideOnly(value=Side.CLIENT)
    private IIcon bottom;
    @SideOnly(value=Side.CLIENT)
    private IIcon frontActivated;

    public BlockHeatedFurnace() {
        super("blockHeatedFurnace");
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileHeatedFurnace();
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityplayer, int par6, float par7, float par8, float par9) {
        if (!world.field_72995_K) {
            entityplayer.openGui((Object)BuildcraftAdditions.instance, Variables.Gui.HEATED_FURNACE.ordinal(), world, x, y, z);
        }
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileHeatedFurnace) {
            TileHeatedFurnace furnace = (TileHeatedFurnace)tile;
            furnace.updateCoils();
        }
    }

    public void func_149714_e(World world, int x, int y, int z, int meta) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileHeatedFurnace) {
            TileHeatedFurnace furnace = (TileHeatedFurnace)tile;
            furnace.updateCoils();
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        world.func_72921_c(x, y, z, Utils.get2dOrientation(entity).getOpposite().ordinal(), 3);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 0 && side == 3) {
            return this.front;
        }
        if (side == meta && meta > 1) {
            TileHeatedFurnace furnace = (TileHeatedFurnace)world.func_147438_o(x, y, z);
            if (furnace.isCooking) {
                return this.frontActivated;
            }
            return this.front;
        }
        switch (side) {
            case 0: {
                return this.bottom;
            }
            case 1: {
                return this.top;
            }
            case 5: {
                return this.back;
            }
        }
        return this.sides;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta == 0 && side == 3) {
            return this.front;
        }
        if (side == meta && meta > 1) {
            return this.front;
        }
        if (side == ForgeDirection.getOrientation((int)meta).getOpposite().ordinal()) {
            switch (side) {
                case 0: {
                    return this.bottom;
                }
                case 1: {
                    return this.top;
                }
            }
        }
        return this.sides;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.front = RenderUtils.registerIcon(register, "heatedFurnace/Front");
        this.frontActivated = RenderUtils.registerIcon(register, "heatedFurnace/Front_on");
        this.top = RenderUtils.registerIcon(register, "heatedFurnace/Top");
        this.back = RenderUtils.registerIcon(register, "heatedFurnace/Back");
        this.bottom = RenderUtils.registerIcon(register, "heatedFurnace/Bottom");
        this.sides = RenderUtils.registerIcon(register, "heatedFurnace/Side");
    }
}

