/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.armour;

import buildcraftAdditions.BuildcraftAdditions;
import buildcraftAdditions.client.models.BackPackModel;
import buildcraftAdditions.items.ItemPoweredBase;
import buildcraftAdditions.reference.ItemLoader;
import buildcraftAdditions.utils.IHUD;
import buildcraftAdditions.utils.Utils;
import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import org.apache.commons.lang3.text.WordUtils;

public class ItemKineticBackpack
extends ItemArmor
implements IEnergyContainerItem,
IHUD {
    public ItemKineticBackpack() {
        super(ItemArmor.ArmorMaterial.IRON, BuildcraftAdditions.proxy.addArmor("kineticBackpack"), 1);
        this.func_77655_b("kineticBackpack");
        GameRegistry.registerItem((Item)this, (String)"kineticBackpack");
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        this.setDamage(itemStack, 0);
        ItemStack stack = player.func_71045_bC();
        Object capsule = null;
        if (stack != null && stack.func_77973_b() instanceof IEnergyContainerItem) {
            IEnergyContainerItem eci = (IEnergyContainerItem)stack.func_77973_b();
            int transfer = Math.min(eci.receiveEnergy(player.func_71045_bC(), this.getEnergyStored(itemStack), true), 20000);
            eci.receiveEnergy(player.func_71045_bC(), transfer, false);
            this.extractEnergy(itemStack, transfer, false);
        }
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        int recieved = maxReceive;
        if (recieved > this.getMaxEnergyStored(container) - this.getEnergyStored(container)) {
            recieved = this.getMaxEnergyStored(container) - this.getEnergyStored(container);
        }
        if (!simulate) {
            this.setEnergy(container, this.getEnergyStored(container) + recieved);
        }
        return recieved;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        int max = Math.min(this.getMaxEnergyStored(container), maxExtract);
        max = Math.min(max, this.getEnergyStored(container));
        if (!simulate) {
            this.setEnergy(container, this.getEnergyStored(container) - max);
        }
        return max;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        this.tagTest(container);
        return container.field_77990_d.func_74762_e("energy");
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        this.tagTest(container);
        return container.field_77990_d.func_74762_e("maxEnergy");
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean sneaking) {
        list.add(Utils.getRFInfoTooltip(this.getEnergyStored(stack), this.getMaxEnergyStored(stack)));
        for (String line : WordUtils.wrap((String)Utils.localize("backpack.info"), (int)60).split(System.getProperty("line.separator"))) {
            list.add(Utils.colorText(line, EnumChatFormatting.AQUA));
        }
    }

    private void tagTest(ItemStack stack) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
            stack.field_77990_d.func_74768_a("maxEnergy", 0);
            stack.field_77990_d.func_74768_a("energy", 0);
            for (int t = 0; t < 4; ++t) {
                stack.field_77990_d.func_74768_a("capsule" + t, 0);
            }
        }
    }

    private void setEnergy(ItemStack stack, int energy) {
        this.tagTest(stack);
        stack.field_77990_d.func_74768_a("energy", energy);
    }

    private void setMaxEnergy(ItemStack stack, int capacity) {
        this.tagTest(stack);
        stack.field_77990_d.func_74768_a("maxEnergy", capacity);
    }

    public void installCapsule(ItemStack backpack, int slot, ItemStack capsule) {
        this.tagTest(backpack);
        int capsuleType = 0;
        if (capsule.func_77973_b() == ItemLoader.powerCapsuleTier1) {
            capsuleType = 1;
        } else if (capsule.func_77973_b() == ItemLoader.powerCapsuleTier2) {
            capsuleType = 2;
        } else if (capsule.func_77973_b() == ItemLoader.powerCapsuleTier3) {
            capsuleType = 3;
        }
        if (capsuleType > 0) {
            ItemPoweredBase base = (ItemPoweredBase)capsule.func_77973_b();
            this.setMaxEnergy(backpack, this.getMaxEnergyStored(backpack) + base.getMaxEnergyStored(capsule));
            this.receiveEnergy(backpack, base.getEnergyStored(capsule), false);
            backpack.field_77990_d.func_74768_a("capsule" + slot, capsuleType);
        }
    }

    public int getInstalledCapsule(ItemStack stack, int slot) {
        this.tagTest(stack);
        return stack.field_77990_d.func_74762_e("capsule" + slot);
    }

    public int removeCapsule(ItemStack stack, int slot) {
        this.tagTest(stack);
        int tier = stack.field_77990_d.func_74762_e("capsule" + slot);
        stack.field_77990_d.func_74768_a("capsule" + slot, 0);
        int capacity = 0;
        for (int t = 0; t < 4; ++t) {
            int capsuletier = stack.field_77990_d.func_74762_e("capsule" + t);
            if (capsuletier == 1) {
                capacity += 100000;
                continue;
            }
            if (capsuletier == 2) {
                capacity += 300000;
                continue;
            }
            if (capsuletier != 3) continue;
            capacity += 1000000;
        }
        this.setMaxEnergy(stack, capacity);
        return tier;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        return BackPackModel.INSTANCE2;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "bcadditions:textures/models/armor/kineticBackpack_layer_1.png";
    }

    public void func_94581_a(IIconRegister register) {
    }

    public boolean func_77645_m() {
        return false;
    }

    @Override
    public String getInfo(ItemStack stack) {
        return EnumChatFormatting.GOLD + Utils.localize("hud.backpack") + " " + Utils.getRFPercentTooltip(this.getEnergyStored(stack), this.getMaxEnergyStored(stack));
    }
}

