/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.api.configurableOutput;

import buildcraftAdditions.api.configurableOutput.EnumPriority;
import buildcraftAdditions.api.configurableOutput.EnumSideStatus;
import buildcraftAdditions.api.configurableOutput.IConfigurableOutput;
import buildcraftAdditions.api.nbt.INBTSaveable;
import buildcraftAdditions.api.networking.ISyncObject;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class SideConfiguration
implements ISyncObject,
INBTSaveable {
    private static final EnumSet<ForgeDirection> VALID_DIRECTIONS = EnumSet.noneOf(ForgeDirection.class);
    private final EnumMap<ForgeDirection, EnumSideStatus> configurations = new EnumMap(ForgeDirection.class);
    private final EnumMap<ForgeDirection, EnumPriority> priorities = new EnumMap(ForgeDirection.class);

    public SideConfiguration() {
        this(EnumSideStatus.BOTH, EnumPriority.NORMAL);
    }

    public SideConfiguration(EnumSideStatus status) {
        this(status, EnumPriority.NORMAL);
    }

    public SideConfiguration(EnumPriority priority) {
        this(EnumSideStatus.BOTH, priority);
    }

    public SideConfiguration(EnumSideStatus status, EnumPriority priority) {
        this.setAllStatus(status);
        this.setAllPriority(priority);
    }

    private static boolean isValidDirection(ForgeDirection direction) {
        return direction != null && VALID_DIRECTIONS.contains(direction);
    }

    @Override
    public void writeToByteBuff(ByteBuf buf) {
        for (ForgeDirection direction : VALID_DIRECTIONS) {
            buf.writeByte(this.getStatus(direction).ordinal());
            buf.writeByte(this.getPriority(direction).ordinal());
        }
    }

    @Override
    public void readFromByteBuff(ByteBuf buf) {
        for (ForgeDirection direction : VALID_DIRECTIONS) {
            this.setStatus(EnumSideStatus.values()[buf.readByte()], direction);
            this.setPriority(EnumPriority.values()[buf.readByte()], direction);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        for (ForgeDirection direction : VALID_DIRECTIONS) {
            if (tag.func_150297_b("configuration" + direction.ordinal(), 3)) {
                this.setStatus(EnumSideStatus.values()[tag.func_74762_e("configuration" + direction.ordinal())], direction);
            }
            if (tag.func_150297_b("configuration" + direction.ordinal(), 1)) {
                this.setStatus(EnumSideStatus.values()[tag.func_74771_c("configuration" + direction.ordinal())], direction);
            }
            if (tag.func_150297_b("priority" + direction.ordinal(), 3)) {
                this.setPriority(EnumPriority.values()[tag.func_74762_e("priority" + direction.ordinal())], direction);
            }
            if (!tag.func_150297_b("priority" + direction.ordinal(), 1)) continue;
            this.setPriority(EnumPriority.values()[tag.func_74771_c("priority" + direction.ordinal())], direction);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        for (ForgeDirection direction : VALID_DIRECTIONS) {
            tag.func_74774_a("configuration" + direction.ordinal(), (byte)(0xFF & this.getStatus(direction).ordinal()));
            tag.func_74774_a("priority" + direction.ordinal(), (byte)(0xFF & this.getPriority(direction).ordinal()));
        }
    }

    public void load(IConfigurableOutput configurableOutput) {
        this.configurations.putAll(configurableOutput.getSideConfiguration().configurations);
        this.priorities.putAll(configurableOutput.getSideConfiguration().priorities);
    }

    public void load(SideConfiguration configuration) {
        this.configurations.putAll(configuration.configurations);
        this.priorities.putAll(configuration.priorities);
    }

    public boolean canReceive(ForgeDirection side) {
        return this.getStatus(side).canReceive();
    }

    public boolean canSend(ForgeDirection side) {
        return this.getStatus(side).canSend();
    }

    public void changeStatus(ForgeDirection side) {
        this.setStatus(this.getNextStatus(side), side);
    }

    public void changePriority(ForgeDirection side) {
        this.setPriority(this.getNextPriority(side), side);
    }

    public EnumSideStatus getStatus(ForgeDirection side) {
        return SideConfiguration.isValidDirection(side) ? this.configurations.get(side) : EnumSideStatus.DISABLED;
    }

    public EnumSideStatus getNextStatus(ForgeDirection side) {
        return this.getStatus(side).getNextStatus();
    }

    public EnumPriority getPriority(ForgeDirection side) {
        return SideConfiguration.isValidDirection(side) ? this.priorities.get(side) : EnumPriority.NORMAL;
    }

    public EnumPriority getNextPriority(ForgeDirection side) {
        return this.getPriority(side).getNextPriority();
    }

    public void setStatus(EnumSideStatus status, ForgeDirection side) {
        if (SideConfiguration.isValidDirection(side)) {
            this.configurations.put(side, status);
        }
    }

    public void setPriority(EnumPriority priority, ForgeDirection side) {
        if (SideConfiguration.isValidDirection(side)) {
            this.priorities.put(side, priority);
        }
    }

    public void setAllStatus(EnumSideStatus status) {
        for (ForgeDirection side : VALID_DIRECTIONS) {
            this.setStatus(status, side);
        }
    }

    public void setAllPriority(EnumPriority priority) {
        for (ForgeDirection side : VALID_DIRECTIONS) {
            this.setPriority(priority, side);
        }
    }

    public void invalidate() {
        this.setAllStatus(EnumSideStatus.BOTH);
        this.setAllPriority(EnumPriority.NORMAL);
    }

    public String toString() {
        String string = "SideConfiguration[ ";
        for (ForgeDirection direction : VALID_DIRECTIONS) {
            string = string + direction.name() + ":{ ";
            string = string + (Object)((Object)this.getStatus(direction)) + ", ";
            string = string + (Object)((Object)this.getPriority(direction)) + " }, ";
        }
        return string + " ]";
    }

    static {
        Collections.addAll(VALID_DIRECTIONS, ForgeDirection.VALID_DIRECTIONS);
    }
}

